/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bitcoinj.base.Sha256Hash;
import org.bitcoinj.base.internal.InternalUtils;
import org.bitcoinj.core.Block;

public final class BlockLocator {
    private final List<Sha256Hash> hashes;

    @Deprecated
    public BlockLocator() {
        this.hashes = Collections.emptyList();
    }

    public BlockLocator(List<Sha256Hash> hashes) {
        this.hashes = Collections.unmodifiableList(hashes);
    }

    static BlockLocator ofBlocks(Block ... blocks) {
        return new BlockLocator(Arrays.stream(blocks).map(Block::getHash).collect(Collectors.toList()));
    }

    @Deprecated
    private BlockLocator(BlockLocator old, Sha256Hash hashToAdd) {
        this(Stream.concat(old.hashes.stream(), Stream.of(hashToAdd)).collect(Collectors.toList()));
    }

    @Deprecated
    public BlockLocator add(Sha256Hash hash) {
        return new BlockLocator(this, hash);
    }

    public int size() {
        return this.hashes.size();
    }

    public List<Sha256Hash> getHashes() {
        return this.hashes;
    }

    public Sha256Hash get(int i2) {
        return this.hashes.get(i2);
    }

    public String toString() {
        return "Block locator with " + this.size() + " blocks\n " + InternalUtils.SPACE_JOINER.join(this.hashes);
    }

    public int hashCode() {
        return this.hashes.stream().mapToInt(Sha256Hash::hashCode).reduce(0, (a, b) -> a ^ b);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return ((BlockLocator)o).getHashes().equals(this.hashes);
    }
}

