/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import java.util.Objects;
import org.bitcoinj.base.Coin;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TxConfidenceTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Context {
    private static final Logger log = LoggerFactory.getLogger(Context.class);
    public static final int DEFAULT_EVENT_HORIZON = 100;
    private final TxConfidenceTable confidenceTable;
    private final int eventHorizon;
    private final boolean ensureMinRequiredFee;
    private final Coin feePerKb;
    private final boolean relaxProofOfWork;
    private static volatile Context lastConstructed;
    private static boolean isStrictMode;
    private static final ThreadLocal<Context> slot;

    public Context() {
        this(100, Transaction.DEFAULT_TX_FEE, true, false);
    }

    @Deprecated
    public Context(NetworkParameters params) {
        this();
    }

    public Context(int eventHorizon, Coin feePerKb, boolean ensureMinRequiredFee, boolean relaxProofOfWork) {
        log.info("Creating bitcoinj {} context.", (Object)"0.17");
        this.confidenceTable = new TxConfidenceTable();
        this.eventHorizon = eventHorizon;
        this.ensureMinRequiredFee = ensureMinRequiredFee;
        this.feePerKb = feePerKb;
        this.relaxProofOfWork = relaxProofOfWork;
        lastConstructed = this;
    }

    @Deprecated
    public Context(NetworkParameters params, int eventHorizon, Coin feePerKb, boolean ensureMinRequiredFee) {
        this(eventHorizon, feePerKb, ensureMinRequiredFee, false);
    }

    public static Context get() {
        Context tls = slot.get();
        if (tls == null) {
            if (isStrictMode) {
                log.error("Thread is missing a bitcoinj context.");
                log.error("You should use Context.propagate() or a ContextPropagatingThreadFactory.");
                throw new IllegalStateException("missing context");
            }
            if (lastConstructed == null) {
                throw new IllegalStateException("You must construct a Context object before using bitcoinj!");
            }
            slot.set(lastConstructed);
            log.error("Performing thread fixup: you are accessing bitcoinj via a thread that has not had any context set on it.");
            log.error("This error has been corrected for, but doing this makes your app less robust.");
            log.error("You should use Context.propagate() or a ContextPropagatingThreadFactory.");
            log.error("Please refer to the user guide for more information about this.");
            log.error("Thread name is {}.", (Object)Thread.currentThread().getName());
            return lastConstructed;
        }
        return tls;
    }

    public static void enableStrictMode() {
        isStrictMode = true;
    }

    public static Context getOrCreate() {
        Context context;
        try {
            context = Context.get();
        }
        catch (IllegalStateException e) {
            log.warn("Implicitly creating context. This is a migration step and this message will eventually go away.");
            Context context2 = new Context();
            return context2;
        }
        return context;
    }

    @Deprecated
    public static Context getOrCreate(NetworkParameters params) {
        return Context.getOrCreate();
    }

    public static void propagate(Context context) {
        slot.set(Objects.requireNonNull(context));
    }

    public TxConfidenceTable getConfidenceTable() {
        return this.confidenceTable;
    }

    public int getEventHorizon() {
        return this.eventHorizon;
    }

    public Coin getFeePerKb() {
        return this.feePerKb;
    }

    public boolean isEnsureMinRequiredFee() {
        return this.ensureMinRequiredFee;
    }

    public boolean isRelaxProofOfWork() {
        return this.relaxProofOfWork;
    }

    static {
        slot = new ThreadLocal();
    }
}

