/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.bitcoinj.base.Coin;
import org.bitcoinj.base.internal.Preconditions;
import org.bitcoinj.core.BaseMessage;
import org.bitcoinj.core.ProtocolException;

public class FeeFilterMessage
extends BaseMessage {
    private final Coin feeRate;

    public static FeeFilterMessage of(Coin feeRate) {
        return new FeeFilterMessage(feeRate);
    }

    public static FeeFilterMessage read(ByteBuffer payload) throws BufferUnderflowException, ProtocolException {
        Coin feeRate = Coin.read(payload);
        Preconditions.check(feeRate.signum() >= 0, () -> new ProtocolException("fee rate out of range: " + feeRate));
        return new FeeFilterMessage(feeRate);
    }

    private FeeFilterMessage(Coin feeRate) {
        this.feeRate = feeRate;
    }

    @Override
    protected void bitcoinSerializeToStream(OutputStream stream) throws IOException {
        stream.write(this.feeRate.serialize());
    }

    public Coin feeRate() {
        return this.feeRate;
    }

    @Deprecated
    public Coin getFeeRate() {
        return this.feeRate();
    }

    public String toString() {
        return "feefilter: " + this.feeRate.toFriendlyString() + "/kB";
    }
}

