/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.bitcoinj.base.Sha256Hash;
import org.bitcoinj.base.VarInt;
import org.bitcoinj.base.internal.ByteUtils;
import org.bitcoinj.base.internal.Preconditions;
import org.bitcoinj.core.BaseMessage;
import org.bitcoinj.core.BlockLocator;
import org.bitcoinj.core.ProtocolException;

public class GetBlocksMessage
extends BaseMessage {
    protected long version;
    protected BlockLocator locator;
    protected Sha256Hash stopHash;

    public static GetBlocksMessage read(ByteBuffer payload) throws BufferUnderflowException, ProtocolException {
        long version = ByteUtils.readUint32(payload);
        VarInt startCountVarInt = VarInt.read(payload);
        Preconditions.check(startCountVarInt.fitsInt(), BufferUnderflowException::new);
        int startCount = startCountVarInt.intValue();
        if (startCount > 500) {
            throw new ProtocolException("Number of locators cannot be > 500, received: " + startCount);
        }
        ArrayList<Sha256Hash> hashList = new ArrayList<Sha256Hash>();
        for (int i2 = 0; i2 < startCount; ++i2) {
            hashList.add(Sha256Hash.read(payload));
        }
        Sha256Hash stopHash = Sha256Hash.read(payload);
        return new GetBlocksMessage(version, new BlockLocator(hashList), stopHash);
    }

    public GetBlocksMessage(long protocolVersion, BlockLocator locator, Sha256Hash stopHash) {
        this.version = protocolVersion;
        this.locator = locator;
        this.stopHash = stopHash;
    }

    public BlockLocator getLocator() {
        return this.locator;
    }

    public Sha256Hash getStopHash() {
        return this.stopHash;
    }

    public String toString() {
        return "getblocks: " + this.locator.toString();
    }

    @Override
    protected void bitcoinSerializeToStream(OutputStream stream) throws IOException {
        ByteUtils.writeInt32LE(this.version, stream);
        stream.write(VarInt.of(this.locator.size()).serialize());
        for (Sha256Hash hash : this.locator.getHashes()) {
            stream.write(hash.serialize());
        }
        stream.write(this.stopHash.serialize());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetBlocksMessage other = (GetBlocksMessage)o;
        return this.version == other.version && this.stopHash.equals(other.stopHash) && this.locator.size() == other.locator.size() && this.locator.equals(other.locator);
    }

    public int hashCode() {
        int hashCode = (int)this.version ^ "getblocks".hashCode() ^ this.stopHash.hashCode();
        return hashCode ^= this.locator.hashCode();
    }
}

