/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.bitcoinj.base.Sha256Hash;
import org.bitcoinj.core.InventoryItem;
import org.bitcoinj.core.ListMessage;
import org.bitcoinj.core.ProtocolException;

public class GetDataMessage
extends ListMessage {
    public static GetDataMessage read(ByteBuffer payload) throws BufferUnderflowException, ProtocolException {
        return new GetDataMessage(GetDataMessage.readItems(payload));
    }

    @Deprecated
    public GetDataMessage() {
    }

    GetDataMessage(List<InventoryItem> items) {
        super(items);
    }

    public static GetDataMessage ofBlock(Sha256Hash blockHash, boolean includeWitness) {
        return new GetDataMessage(Collections.singletonList(new InventoryItem(includeWitness ? InventoryItem.Type.WITNESS_BLOCK : InventoryItem.Type.BLOCK, blockHash)));
    }

    public static GetDataMessage ofTransaction(Sha256Hash txId, boolean includeWitness) {
        return new GetDataMessage(Collections.singletonList(new InventoryItem(includeWitness ? InventoryItem.Type.WITNESS_TRANSACTION : InventoryItem.Type.TRANSACTION, txId)));
    }

    @Deprecated
    public void addTransaction(Sha256Hash hash, boolean includeWitness) {
        this.addItem(new InventoryItem(includeWitness ? InventoryItem.Type.WITNESS_TRANSACTION : InventoryItem.Type.TRANSACTION, hash));
    }

    @Deprecated
    public void addBlock(Sha256Hash hash, boolean includeWitness) {
        this.addItem(new InventoryItem(includeWitness ? InventoryItem.Type.WITNESS_BLOCK : InventoryItem.Type.BLOCK, hash));
    }

    @Deprecated
    public void addFilteredBlock(Sha256Hash hash) {
        this.addItem(new InventoryItem(InventoryItem.Type.FILTERED_BLOCK, hash));
    }

    public Sha256Hash getHashOf(int i2) {
        return this.getItems().get((int)i2).hash;
    }
}

