/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.bitcoinj.base.Sha256Hash;
import org.bitcoinj.base.VarInt;
import org.bitcoinj.base.internal.ByteUtils;
import org.bitcoinj.base.internal.Preconditions;
import org.bitcoinj.core.BlockLocator;
import org.bitcoinj.core.GetBlocksMessage;
import org.bitcoinj.core.ProtocolException;

public class GetHeadersMessage
extends GetBlocksMessage {
    public static GetHeadersMessage read(ByteBuffer payload) throws BufferUnderflowException, ProtocolException {
        long version = ByteUtils.readUint32(payload);
        VarInt startCountVarInt = VarInt.read(payload);
        Preconditions.check(startCountVarInt.fitsInt(), BufferUnderflowException::new);
        int startCount = startCountVarInt.intValue();
        if (startCount > 500) {
            throw new ProtocolException("Number of locators cannot be > 500, received: " + startCount);
        }
        ArrayList<Sha256Hash> hashList = new ArrayList<Sha256Hash>();
        for (int i2 = 0; i2 < startCount; ++i2) {
            hashList.add(Sha256Hash.read(payload));
        }
        Sha256Hash stopHash = Sha256Hash.read(payload);
        return new GetHeadersMessage(version, new BlockLocator(hashList), stopHash);
    }

    public GetHeadersMessage(long protocolVersion, BlockLocator locator, Sha256Hash stopHash) {
        super(protocolVersion, locator, stopHash);
    }

    @Override
    public String toString() {
        return "getheaders: " + this.locator.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetHeadersMessage other = (GetHeadersMessage)o;
        return this.version == other.version && this.stopHash.equals(other.stopHash) && this.locator.size() == other.locator.size() && this.locator.equals(other.locator);
    }

    @Override
    public int hashCode() {
        int hashCode = (int)this.version ^ "getheaders".hashCode() ^ this.stopHash.hashCode();
        return hashCode ^= this.locator.hashCode();
    }
}

