/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bitcoinj.base.VarInt;
import org.bitcoinj.base.internal.Preconditions;
import org.bitcoinj.core.BaseMessage;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.ProtocolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeadersMessage
extends BaseMessage {
    private static final Logger log = LoggerFactory.getLogger(HeadersMessage.class);
    public static final int MAX_HEADERS = 2000;
    private List<Block> blockHeaders;

    public static HeadersMessage read(ByteBuffer payload) throws BufferUnderflowException, ProtocolException {
        int i2;
        VarInt numHeadersVarInt = VarInt.read(payload);
        Preconditions.check(numHeadersVarInt.fitsInt(), BufferUnderflowException::new);
        int numHeaders = numHeadersVarInt.intValue();
        if (numHeaders > 2000) {
            throw new ProtocolException("Too many headers: got " + numHeaders + " which is larger than " + 2000);
        }
        ArrayList<Block> blockHeaders = new ArrayList<Block>();
        for (i2 = 0; i2 < numHeaders; ++i2) {
            Block newBlockHeader = Block.read(payload);
            if (newBlockHeader.hasTransactions()) {
                throw new ProtocolException("Block header does not end with a null byte");
            }
            blockHeaders.add(newBlockHeader);
        }
        if (log.isDebugEnabled()) {
            for (i2 = 0; i2 < numHeaders; ++i2) {
                log.debug(((Block)blockHeaders.get(i2)).toString());
            }
        }
        return new HeadersMessage(blockHeaders);
    }

    public HeadersMessage(Block ... headers) throws ProtocolException {
        this.blockHeaders = Arrays.asList(headers);
    }

    public HeadersMessage(List<Block> headers) throws ProtocolException {
        this.blockHeaders = headers;
    }

    @Override
    public void bitcoinSerializeToStream(OutputStream stream) throws IOException {
        stream.write(VarInt.of(this.blockHeaders.size()).serialize());
        for (Block header : this.blockHeaders) {
            header.cloneAsHeader().bitcoinSerializeToStream(stream);
            stream.write(0);
        }
    }

    public List<Block> getBlockHeaders() {
        return this.blockHeaders;
    }
}

