/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import java.util.Objects;
import javax.annotation.Nullable;
import org.bitcoinj.base.Coin;

public class InsufficientMoneyException
extends Exception {
    @Nullable
    public final Coin missing;

    protected InsufficientMoneyException() {
        this.missing = null;
    }

    public InsufficientMoneyException(Coin missing) {
        this(missing, "Insufficient money, missing " + missing.toFriendlyString());
    }

    public InsufficientMoneyException(Coin missing, String message) {
        super(message);
        this.missing = Objects.requireNonNull(missing);
    }

    public InsufficientMoneyException(Coin missing, Coin available, Coin outputs, Coin fee) {
        this(missing, InsufficientMoneyException.format(missing, available, outputs, fee));
    }

    static String format(Coin missing, Coin available, Coin outputs, Coin fee) {
        return String.format("Insufficient money, missing %s (available: %s, total outputs: %s, fee: %s)", missing.toFriendlyString(), available.toFriendlyString(), outputs.toFriendlyString(), fee.toFriendlyString());
    }
}

