/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bitcoinj.base.internal.Preconditions;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.InventoryItem;
import org.bitcoinj.core.ListMessage;
import org.bitcoinj.core.ProtocolException;
import org.bitcoinj.core.Transaction;

public class InventoryMessage
extends ListMessage {
    public static final int MAX_INV_SIZE = 50000;

    public static InventoryMessage read(ByteBuffer payload) throws BufferUnderflowException, ProtocolException {
        return new InventoryMessage(InventoryMessage.readItems(payload));
    }

    @Deprecated
    protected InventoryMessage() {
    }

    protected InventoryMessage(List<InventoryItem> items) {
        super(items);
    }

    public static InventoryMessage ofBlocks(List<Block> blocks) {
        Preconditions.checkArgument(!blocks.isEmpty());
        return new InventoryMessage(blocks.stream().map(InventoryItem::new).collect(Collectors.toList()));
    }

    public static InventoryMessage ofBlocks(Block ... blocks) {
        return InventoryMessage.ofBlocks(Arrays.asList(blocks));
    }

    public static InventoryMessage ofTransactions(List<Transaction> transactions) {
        Preconditions.checkArgument(!transactions.isEmpty());
        return new InventoryMessage(transactions.stream().map(InventoryItem::new).collect(Collectors.toList()));
    }

    public static InventoryMessage ofTransactions(Transaction ... transactions) {
        return InventoryMessage.ofTransactions(Arrays.asList(transactions));
    }

    @Deprecated
    public void addBlock(Block block) {
        this.addItem(new InventoryItem(block));
    }

    @Deprecated
    public void addTransaction(Transaction tx) {
        this.addItem(new InventoryItem(tx));
    }

    @Deprecated
    public static InventoryMessage with(Transaction ... txns) {
        return InventoryMessage.ofTransactions(txns);
    }
}

