/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bitcoinj.base.Sha256Hash;
import org.bitcoinj.base.VarInt;
import org.bitcoinj.base.internal.ByteUtils;
import org.bitcoinj.base.internal.Preconditions;
import org.bitcoinj.core.BaseMessage;
import org.bitcoinj.core.InventoryItem;
import org.bitcoinj.core.ProtocolException;

public abstract class ListMessage
extends BaseMessage {
    protected final List<InventoryItem> items;
    public static final int MAX_INVENTORY_ITEMS = 50000;

    protected static List<InventoryItem> readItems(ByteBuffer payload) throws BufferUnderflowException, ProtocolException {
        VarInt arrayLenVarInt = VarInt.read(payload);
        Preconditions.check(arrayLenVarInt.fitsInt(), BufferUnderflowException::new);
        int arrayLen = arrayLenVarInt.intValue();
        if (arrayLen > 50000) {
            throw new ProtocolException("Too many items in INV message: " + arrayLen);
        }
        ArrayList<InventoryItem> items = new ArrayList<InventoryItem>(arrayLen);
        for (int i2 = 0; i2 < arrayLen; ++i2) {
            if (payload.remaining() < 36) {
                throw new ProtocolException("Ran off the end of the INV");
            }
            int typeCode = (int)ByteUtils.readUint32(payload);
            InventoryItem.Type type = InventoryItem.Type.ofCode(typeCode);
            if (type == null) {
                throw new ProtocolException("Unknown CInv type: " + typeCode);
            }
            InventoryItem item = new InventoryItem(type, Sha256Hash.read(payload));
            items.add(item);
        }
        return items;
    }

    @Deprecated
    public ListMessage() {
        this.items = new ArrayList<InventoryItem>();
    }

    protected ListMessage(List<InventoryItem> items) {
        this.items = items;
    }

    public List<InventoryItem> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    @Deprecated
    public void addItem(InventoryItem item) {
        this.items.add(item);
    }

    @Deprecated
    public void removeItem(int index) {
        this.items.remove(index);
    }

    @Override
    public void bitcoinSerializeToStream(OutputStream stream) throws IOException {
        stream.write(VarInt.of(this.items.size()).serialize());
        for (InventoryItem i2 : this.items) {
            ByteUtils.writeInt32LE(i2.type.code, stream);
            stream.write(i2.hash.serialize());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.items.equals(((ListMessage)o).items);
    }

    public int hashCode() {
        return this.items.hashCode();
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this);
        helper.addValue(this.items);
        return helper.toString();
    }
}

