/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import java.time.Instant;
import java.util.Objects;
import org.bitcoinj.base.internal.TimeUtils;

public abstract class LockTime {
    public static final long THRESHOLD = 500000000L;
    protected final long value;

    public static LockTime of(long rawValue) {
        if (rawValue < 0L) {
            throw new IllegalArgumentException("illegal negative lock time: " + rawValue);
        }
        return rawValue < 500000000L ? new HeightLock(rawValue) : new TimeLock(rawValue);
    }

    public static HeightLock ofBlockHeight(int blockHeight) {
        if (blockHeight < 0) {
            throw new IllegalArgumentException("illegal negative block height: " + blockHeight);
        }
        if ((long)blockHeight >= 500000000L) {
            throw new IllegalArgumentException("block height too high: " + blockHeight);
        }
        return new HeightLock(blockHeight);
    }

    public static TimeLock ofTimestamp(Instant time) {
        long secs = time.getEpochSecond();
        if (secs < 500000000L) {
            throw new IllegalArgumentException("timestamp too low: " + secs);
        }
        return new TimeLock(secs);
    }

    public static LockTime unset() {
        return LockTime.ofBlockHeight(0);
    }

    private LockTime(long rawValue) {
        this.value = rawValue;
    }

    public long rawValue() {
        return this.value;
    }

    public boolean isSet() {
        return this.value > 0L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.value == ((LockTime)o).value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this instanceof HeightLock ? "block " + ((HeightLock)this).blockHeight() : TimeUtils.dateTimeFormat(((TimeLock)this).timestamp());
    }

    public static final class HeightLock
    extends LockTime {
        private HeightLock(long value) {
            super(value);
        }

        public int blockHeight() {
            return Math.toIntExact(this.value);
        }
    }

    public static final class TimeLock
    extends LockTime {
        private TimeLock(long value) {
            super(value);
        }

        public Instant timestamp() {
            return Instant.ofEpochSecond(this.value);
        }
    }
}

