/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import java.math.BigInteger;
import java.time.Instant;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.bitcoinj.base.Address;
import org.bitcoinj.base.BitcoinNetwork;
import org.bitcoinj.base.Coin;
import org.bitcoinj.base.Network;
import org.bitcoinj.base.Sha256Hash;
import org.bitcoinj.base.utils.MonetaryFormat;
import org.bitcoinj.core.BitcoinSerializer;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.MessageSerializer;
import org.bitcoinj.core.ProtocolVersion;
import org.bitcoinj.core.StoredBlock;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.params.BitcoinNetworkParams;
import org.bitcoinj.params.Networks;
import org.bitcoinj.protocols.payments.PaymentProtocol;
import org.bitcoinj.script.Script;
import org.bitcoinj.store.BlockStore;
import org.bitcoinj.store.BlockStoreException;
import org.bitcoinj.utils.VersionTally;

public abstract class NetworkParameters {
    @Deprecated
    public static final String PAYMENT_PROTOCOL_ID_MAINNET = "main";
    @Deprecated
    public static final String PAYMENT_PROTOCOL_ID_TESTNET = "test";
    @Deprecated
    public static final String PAYMENT_PROTOCOL_ID_SIGNET = "signet";
    @Deprecated
    public static final String PAYMENT_PROTOCOL_ID_UNIT_TESTS = "unittest";
    @Deprecated
    public static final String PAYMENT_PROTOCOL_ID_REGTEST = "regtest";
    protected BigInteger maxTarget;
    protected int port;
    protected int packetMagic;
    protected int addressHeader;
    protected int p2shHeader;
    protected int dumpedPrivateKeyHeader;
    protected String segwitAddressHrp;
    protected int interval;
    protected int targetTimespan;
    protected int bip32HeaderP2PKHpub;
    protected int bip32HeaderP2PKHpriv;
    protected int bip32HeaderP2WPKHpub;
    protected int bip32HeaderP2WPKHpriv;
    protected int majorityEnforceBlockUpgrade;
    protected int majorityRejectBlockOutdated;
    protected int majorityWindow;
    protected final String id;
    protected final Network network;
    protected int spendableCoinbaseDepth;
    protected int subsidyDecreaseBlockCount;
    protected String[] dnsSeeds;
    protected int[] addrSeeds;
    protected Map<Integer, Sha256Hash> checkpoints = new HashMap<Integer, Sha256Hash>();
    protected volatile transient MessageSerializer defaultSerializer = null;
    public static final int TARGET_TIMESPAN = 1209600;
    public static final int TARGET_SPACING = 600;
    public static final int INTERVAL = 2016;
    public static final Instant BIP16_ENFORCE_TIME = Instant.ofEpochSecond(1333238400L);
    @Deprecated
    public static final long MAX_COINS = BitcoinNetwork.MAX_MONEY.longValue();
    @Deprecated
    public static final Coin MAX_MONEY = BitcoinNetwork.MAX_MONEY;

    protected NetworkParameters(Network network) {
        this.network = network;
        this.id = network.id();
    }

    public String getId() {
        return this.id;
    }

    public Network network() {
        return this.network;
    }

    @Deprecated
    public abstract String getPaymentProtocolId();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.getId().equals(((NetworkParameters)o).getId());
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    @Deprecated
    @Nullable
    public static NetworkParameters fromID(String id) {
        return BitcoinNetworkParams.fromID(id);
    }

    public static NetworkParameters of(Network network) {
        return network instanceof BitcoinNetwork ? BitcoinNetworkParams.of((BitcoinNetwork)network) : Networks.find(network).orElseThrow(() -> new IllegalArgumentException("Unknown network"));
    }

    @Nullable
    @Deprecated
    public static NetworkParameters fromPmtProtocolID(String pmtProtocolId) {
        return PaymentProtocol.paramsFromPmtProtocolID(pmtProtocolId);
    }

    @Deprecated
    public static NetworkParameters fromAddress(Address address) {
        return address.getParameters();
    }

    public int getSpendableCoinbaseDepth() {
        return this.spendableCoinbaseDepth;
    }

    public abstract void checkDifficultyTransitions(StoredBlock var1, Block var2, BlockStore var3) throws VerificationException, BlockStoreException;

    public boolean passesCheckpoint(int height, Sha256Hash hash) {
        Sha256Hash checkpointHash = this.checkpoints.get(height);
        return checkpointHash == null || checkpointHash.equals(hash);
    }

    public boolean isCheckpoint(int height) {
        Sha256Hash checkpointHash = this.checkpoints.get(height);
        return checkpointHash != null;
    }

    public int getSubsidyDecreaseBlockCount() {
        return this.subsidyDecreaseBlockCount;
    }

    public String[] getDnsSeeds() {
        return this.dnsSeeds;
    }

    public int[] getAddrSeeds() {
        return this.addrSeeds;
    }

    public abstract Block getGenesisBlock();

    public int getPort() {
        return this.port;
    }

    public int getPacketMagic() {
        return this.packetMagic;
    }

    @Deprecated
    public int getAddressHeader() {
        return this.addressHeader;
    }

    @Deprecated
    public int getP2SHHeader() {
        return this.p2shHeader;
    }

    public int getDumpedPrivateKeyHeader() {
        return this.dumpedPrivateKeyHeader;
    }

    @Deprecated
    public String getSegwitAddressHrp() {
        return this.segwitAddressHrp;
    }

    public int getTargetTimespan() {
        return this.targetTimespan;
    }

    public boolean allowEmptyPeerChain() {
        return true;
    }

    public int getInterval() {
        return this.interval;
    }

    public BigInteger getMaxTarget() {
        return this.maxTarget;
    }

    public int getBip32HeaderP2PKHpub() {
        return this.bip32HeaderP2PKHpub;
    }

    public int getBip32HeaderP2PKHpriv() {
        return this.bip32HeaderP2PKHpriv;
    }

    public int getBip32HeaderP2WPKHpub() {
        return this.bip32HeaderP2WPKHpub;
    }

    public int getBip32HeaderP2WPKHpriv() {
        return this.bip32HeaderP2WPKHpriv;
    }

    @Deprecated
    public abstract Coin getMaxMoney();

    @Deprecated
    public abstract MonetaryFormat getMonetaryFormat();

    @Deprecated
    public abstract String getUriScheme();

    @Deprecated
    public abstract boolean hasMaxMoney();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MessageSerializer getDefaultSerializer() {
        if (null == this.defaultSerializer) {
            NetworkParameters networkParameters = this;
            synchronized (networkParameters) {
                if (null == this.defaultSerializer) {
                    this.defaultSerializer = this.getSerializer();
                }
            }
        }
        return this.defaultSerializer;
    }

    public abstract BitcoinSerializer getSerializer();

    public int getMajorityEnforceBlockUpgrade() {
        return this.majorityEnforceBlockUpgrade;
    }

    public int getMajorityRejectBlockOutdated() {
        return this.majorityRejectBlockOutdated;
    }

    public int getMajorityWindow() {
        return this.majorityWindow;
    }

    public EnumSet<Block.VerifyFlag> getBlockVerificationFlags(Block block, VersionTally tally, Integer height) {
        Integer count;
        EnumSet<Block.VerifyFlag> flags = EnumSet.noneOf(Block.VerifyFlag.class);
        if (block.isBIP34() && null != (count = tally.getCountAtOrAbove(2L)) && count >= this.getMajorityEnforceBlockUpgrade()) {
            flags.add(Block.VerifyFlag.HEIGHT_IN_COINBASE);
        }
        return flags;
    }

    public EnumSet<Script.VerifyFlag> getTransactionVerificationFlags(Block block, Transaction transaction, VersionTally tally, Integer height) {
        EnumSet<Script.VerifyFlag> verifyFlags = EnumSet.noneOf(Script.VerifyFlag.class);
        if (!block.time().isBefore(BIP16_ENFORCE_TIME)) {
            verifyFlags.add(Script.VerifyFlag.P2SH);
        }
        if (block.getVersion() >= 4L && tally.getCountAtOrAbove(4L) > this.getMajorityEnforceBlockUpgrade()) {
            verifyFlags.add(Script.VerifyFlag.CHECKLOCKTIMEVERIFY);
        }
        return verifyFlags;
    }

    @Deprecated
    public int getProtocolVersionNum(ProtocolVersion version) {
        return version.intValue();
    }
}

