/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.jcip.annotations.GuardedBy;
import org.bitcoinj.base.Coin;
import org.bitcoinj.base.Sha256Hash;
import org.bitcoinj.base.internal.FutureUtils;
import org.bitcoinj.base.internal.Preconditions;
import org.bitcoinj.base.internal.TimeUtils;
import org.bitcoinj.core.AbstractBlockChain;
import org.bitcoinj.core.AddressMessage;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.BlockLocator;
import org.bitcoinj.core.BloomFilter;
import org.bitcoinj.core.Context;
import org.bitcoinj.core.FeeFilterMessage;
import org.bitcoinj.core.FilteredBlock;
import org.bitcoinj.core.GetAddrMessage;
import org.bitcoinj.core.GetBlocksMessage;
import org.bitcoinj.core.GetDataMessage;
import org.bitcoinj.core.GetHeadersMessage;
import org.bitcoinj.core.HeadersMessage;
import org.bitcoinj.core.InventoryItem;
import org.bitcoinj.core.InventoryMessage;
import org.bitcoinj.core.MemoryPoolMessage;
import org.bitcoinj.core.Message;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.NotFoundMessage;
import org.bitcoinj.core.PeerAddress;
import org.bitcoinj.core.PeerSocketHandler;
import org.bitcoinj.core.Ping;
import org.bitcoinj.core.Pong;
import org.bitcoinj.core.ProtocolException;
import org.bitcoinj.core.ProtocolVersion;
import org.bitcoinj.core.PrunedException;
import org.bitcoinj.core.RejectMessage;
import org.bitcoinj.core.SendAddrV2Message;
import org.bitcoinj.core.SendHeadersMessage;
import org.bitcoinj.core.Services;
import org.bitcoinj.core.StoredBlock;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionConfidence;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.core.VersionAck;
import org.bitcoinj.core.VersionMessage;
import org.bitcoinj.core.listeners.AddressEventListener;
import org.bitcoinj.core.listeners.BlocksDownloadedEventListener;
import org.bitcoinj.core.listeners.ChainDownloadStartedEventListener;
import org.bitcoinj.core.listeners.GetDataEventListener;
import org.bitcoinj.core.listeners.OnTransactionBroadcastListener;
import org.bitcoinj.core.listeners.PeerConnectedEventListener;
import org.bitcoinj.core.listeners.PeerDisconnectedEventListener;
import org.bitcoinj.core.listeners.PreMessageReceivedEventListener;
import org.bitcoinj.store.BlockStore;
import org.bitcoinj.store.BlockStoreException;
import org.bitcoinj.utils.ListenableCompletableFuture;
import org.bitcoinj.utils.ListenerRegistration;
import org.bitcoinj.utils.Threading;
import org.bitcoinj.wallet.Wallet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Peer
extends PeerSocketHandler {
    private static final Logger log = LoggerFactory.getLogger(Peer.class);
    protected final ReentrantLock lock = Threading.lock(Peer.class);
    private final NetworkParameters params;
    private final AbstractBlockChain blockChain;
    private final long requiredServices;
    private final Context context;
    private final CopyOnWriteArrayList<ListenerRegistration<BlocksDownloadedEventListener>> blocksDownloadedEventListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ListenerRegistration<ChainDownloadStartedEventListener>> chainDownloadStartedEventListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ListenerRegistration<PeerConnectedEventListener>> connectedEventListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ListenerRegistration<PeerDisconnectedEventListener>> disconnectedEventListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ListenerRegistration<GetDataEventListener>> getDataEventListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ListenerRegistration<PreMessageReceivedEventListener>> preMessageReceivedEventListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ListenerRegistration<OnTransactionBroadcastListener>> onTransactionEventListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ListenerRegistration<AddressEventListener>> addressEventListeners = new CopyOnWriteArrayList();
    private volatile boolean vDownloadData;
    private final VersionMessage versionMessage;
    private volatile int vDownloadTxDependencyDepth;
    private final AtomicInteger blocksAnnounced = new AtomicInteger();
    private final CopyOnWriteArrayList<Wallet> wallets;
    @GuardedBy(value="lock")
    private Instant fastCatchupTime;
    @GuardedBy(value="lock")
    private boolean downloadBlockBodies = true;
    @GuardedBy(value="lock")
    private boolean useFilteredBlocks = false;
    private volatile BloomFilter vBloomFilter;
    private FilteredBlock currentFilteredBlock = null;
    @GuardedBy(value="lock")
    @Nullable
    private List<Sha256Hash> awaitingFreshFilter;
    private final HashSet<Sha256Hash> pendingBlockDownloads = new HashSet();
    private final HashSet<TransactionConfidence> pendingTxDownloads = new HashSet();
    private static final int PENDING_TX_DOWNLOADS_LIMIT = 100;
    private volatile int vMinProtocolVersion;
    private final Queue<GetDataRequest<?>> getDataFutures;
    @GuardedBy(value="getAddrFutures")
    private final LinkedList<CompletableFuture<AddressMessage>> getAddrFutures;
    private final ReentrantLock pingIntervalsLock = new ReentrantLock();
    @GuardedBy(value="pingIntervalsLock")
    private final Deque<Duration> pingIntervals = new ArrayDeque<Duration>(20);
    private volatile Duration lastPing = null;
    private volatile Duration averagePing = null;
    private final CopyOnWriteArrayList<PendingPing> pendingPings;
    private static final int PENDING_PINGS_LIMIT = 50;
    private static final int PING_MOVING_AVERAGE_WINDOW = 20;
    private volatile VersionMessage vPeerVersionMessage;
    private volatile Coin vFeeFilter;
    private final CompletableFuture<Peer> connectionOpenFuture = new CompletableFuture();
    private final CompletableFuture<Peer> outgoingVersionHandshakeFuture = new CompletableFuture();
    private final CompletableFuture<Peer> incomingVersionHandshakeFuture = new CompletableFuture();
    private final CompletableFuture<Peer> versionHandshakeFuture = this.outgoingVersionHandshakeFuture.thenCombine(this.incomingVersionHandshakeFuture, (peer1, peer2) -> {
        Objects.requireNonNull(peer1);
        Preconditions.checkState(peer1 == peer2);
        return peer1;
    });
    @GuardedBy(value="lock")
    private Sha256Hash lastGetBlocksBegin;
    @GuardedBy(value="lock")
    private Sha256Hash lastGetBlocksEnd;

    @Deprecated
    public Peer(NetworkParameters params, VersionMessage ver, @Nullable AbstractBlockChain chain, PeerAddress remoteAddress) {
        this(params, ver, remoteAddress, chain);
    }

    public Peer(NetworkParameters params, VersionMessage ver, PeerAddress remoteAddress, @Nullable AbstractBlockChain chain) {
        this(params, ver, remoteAddress, chain, 0L, Integer.MAX_VALUE);
    }

    public Peer(NetworkParameters params, VersionMessage ver, PeerAddress remoteAddress, @Nullable AbstractBlockChain chain, long requiredServices, int downloadTxDependencyDepth) {
        super(params, remoteAddress);
        this.params = Objects.requireNonNull(params);
        this.versionMessage = Objects.requireNonNull(ver);
        this.vDownloadTxDependencyDepth = chain != null ? downloadTxDependencyDepth : 0;
        this.blockChain = chain;
        this.requiredServices = requiredServices;
        this.vDownloadData = chain != null;
        this.getDataFutures = new ConcurrentLinkedQueue();
        this.getAddrFutures = new LinkedList();
        this.fastCatchupTime = params.getGenesisBlock().time();
        this.pendingPings = new CopyOnWriteArrayList();
        this.vMinProtocolVersion = ProtocolVersion.MINIMUM.intValue();
        this.wallets = new CopyOnWriteArrayList();
        this.context = Context.get();
        this.versionHandshakeFuture.thenRunAsync(this::versionHandshakeComplete, Threading.SAME_THREAD);
    }

    public Peer(NetworkParameters params, AbstractBlockChain blockChain, PeerAddress peerAddress, String thisSoftwareName, String thisSoftwareVersion) {
        this(params, new VersionMessage(params, blockChain.getBestChainHeight()), blockChain, peerAddress);
        this.versionMessage.appendToSubVer(thisSoftwareName, thisSoftwareVersion, null);
    }

    public void addBlocksDownloadedEventListener(BlocksDownloadedEventListener listener) {
        this.addBlocksDownloadedEventListener(Threading.USER_THREAD, listener);
    }

    public void addBlocksDownloadedEventListener(Executor executor, BlocksDownloadedEventListener listener) {
        this.blocksDownloadedEventListeners.add(new ListenerRegistration<BlocksDownloadedEventListener>(listener, executor));
    }

    public void addChainDownloadStartedEventListener(ChainDownloadStartedEventListener listener) {
        this.addChainDownloadStartedEventListener(Threading.USER_THREAD, listener);
    }

    public void addChainDownloadStartedEventListener(Executor executor, ChainDownloadStartedEventListener listener) {
        this.chainDownloadStartedEventListeners.add(new ListenerRegistration<ChainDownloadStartedEventListener>(listener, executor));
    }

    public void addConnectedEventListener(PeerConnectedEventListener listener) {
        this.addConnectedEventListener(Threading.USER_THREAD, listener);
    }

    public void addConnectedEventListener(Executor executor, PeerConnectedEventListener listener) {
        this.connectedEventListeners.add(new ListenerRegistration<PeerConnectedEventListener>(listener, executor));
    }

    public void addDisconnectedEventListener(PeerDisconnectedEventListener listener) {
        this.addDisconnectedEventListener(Threading.USER_THREAD, listener);
    }

    public void addDisconnectedEventListener(Executor executor, PeerDisconnectedEventListener listener) {
        this.disconnectedEventListeners.add(new ListenerRegistration<PeerDisconnectedEventListener>(listener, executor));
    }

    public void addGetDataEventListener(GetDataEventListener listener) {
        this.addGetDataEventListener(Threading.USER_THREAD, listener);
    }

    public void addGetDataEventListener(Executor executor, GetDataEventListener listener) {
        this.getDataEventListeners.add(new ListenerRegistration<GetDataEventListener>(listener, executor));
    }

    public void addOnTransactionBroadcastListener(OnTransactionBroadcastListener listener) {
        this.addOnTransactionBroadcastListener(Threading.USER_THREAD, listener);
    }

    public void addOnTransactionBroadcastListener(Executor executor, OnTransactionBroadcastListener listener) {
        this.onTransactionEventListeners.add(new ListenerRegistration<OnTransactionBroadcastListener>(listener, executor));
    }

    public void addPreMessageReceivedEventListener(PreMessageReceivedEventListener listener) {
        this.addPreMessageReceivedEventListener(Threading.USER_THREAD, listener);
    }

    public void addPreMessageReceivedEventListener(Executor executor, PreMessageReceivedEventListener listener) {
        this.preMessageReceivedEventListeners.add(new ListenerRegistration<PreMessageReceivedEventListener>(listener, executor));
    }

    public void addAddressEventListener(AddressEventListener listener) {
        this.addAddressEventListener(Threading.USER_THREAD, listener);
    }

    public void addAddressEventListener(Executor executor, AddressEventListener listener) {
        this.addressEventListeners.add(new ListenerRegistration<AddressEventListener>(listener, executor));
    }

    public boolean removeBlocksDownloadedEventListener(BlocksDownloadedEventListener listener) {
        return ListenerRegistration.removeFromList(listener, this.blocksDownloadedEventListeners);
    }

    public boolean removeChainDownloadStartedEventListener(ChainDownloadStartedEventListener listener) {
        return ListenerRegistration.removeFromList(listener, this.chainDownloadStartedEventListeners);
    }

    public boolean removeConnectedEventListener(PeerConnectedEventListener listener) {
        return ListenerRegistration.removeFromList(listener, this.connectedEventListeners);
    }

    public boolean removeDisconnectedEventListener(PeerDisconnectedEventListener listener) {
        return ListenerRegistration.removeFromList(listener, this.disconnectedEventListeners);
    }

    public boolean removeGetDataEventListener(GetDataEventListener listener) {
        return ListenerRegistration.removeFromList(listener, this.getDataEventListeners);
    }

    public boolean removeOnTransactionBroadcastListener(OnTransactionBroadcastListener listener) {
        return ListenerRegistration.removeFromList(listener, this.onTransactionEventListeners);
    }

    public boolean removePreMessageReceivedEventListener(PreMessageReceivedEventListener listener) {
        return ListenerRegistration.removeFromList(listener, this.preMessageReceivedEventListeners);
    }

    public boolean removeAddressEventListener(AddressEventListener listener) {
        return ListenerRegistration.removeFromList(listener, this.addressEventListeners);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this).omitNullValues();
        helper.addValue((Object)this.getAddress());
        helper.add("version", this.vPeerVersionMessage.clientVersion);
        helper.add("subVer", (Object)this.vPeerVersionMessage.subVer);
        if (this.vPeerVersionMessage.localServices.hasAny()) {
            helper.add("services", (Object)this.vPeerVersionMessage.localServices.toString());
        }
        helper.add("time", (Object)TimeUtils.dateTimeFormat(this.vPeerVersionMessage.time));
        helper.add("height", this.vPeerVersionMessage.bestHeight);
        return helper.toString();
    }

    @Override
    protected void timeoutOccurred() {
        super.timeoutOccurred();
        if (!this.connectionOpenFuture.isDone()) {
            this.connectionClosed();
        }
    }

    @Override
    public void connectionClosed() {
        for (ListenerRegistration<PeerDisconnectedEventListener> registration : this.disconnectedEventListeners) {
            registration.executor.execute(() -> ((PeerDisconnectedEventListener)registration.listener).onPeerDisconnected(this, 0));
        }
    }

    @Override
    public void connectionOpened() {
        PeerAddress address = this.getAddress();
        log.info("Announcing to {} as: {}", address == null ? "Peer" : address.toSocketAddress(), (Object)this.versionMessage.subVer);
        this.sendMessage(this.versionMessage);
        this.connectionOpenFuture.complete(this);
    }

    public ListenableCompletableFuture<Peer> getConnectionOpenFuture() {
        return ListenableCompletableFuture.of(this.connectionOpenFuture);
    }

    public ListenableCompletableFuture<Peer> getVersionHandshakeFuture() {
        return ListenableCompletableFuture.of(this.versionHandshakeFuture);
    }

    @Override
    protected void processMessage(Message m) throws Exception {
        for (ListenerRegistration<PreMessageReceivedEventListener> registration : this.preMessageReceivedEventListeners) {
            if (registration.executor != Threading.SAME_THREAD || (m = ((PreMessageReceivedEventListener)registration.listener).onPreMessageReceived(this, m)) != null) continue;
            break;
        }
        if (m == null) {
            return;
        }
        if (this.currentFilteredBlock != null && !(m instanceof Transaction)) {
            this.endFilteredBlock(this.currentFilteredBlock);
            this.currentFilteredBlock = null;
        }
        if (!(m instanceof VersionMessage || m instanceof VersionAck || m instanceof SendAddrV2Message || this.versionHandshakeFuture.isDone() && !this.versionHandshakeFuture.isCancelled())) {
            throw new ProtocolException("Received " + m.getClass().getSimpleName() + " before version handshake is complete.");
        }
        if (m instanceof Ping) {
            this.processPing((Ping)m);
        } else if (m instanceof Pong) {
            this.processPong((Pong)m);
        } else if (m instanceof NotFoundMessage) {
            this.processNotFoundMessage((NotFoundMessage)m);
        } else if (m instanceof InventoryMessage) {
            this.processInv((InventoryMessage)m);
        } else if (m instanceof Block) {
            this.processBlock((Block)m);
        } else if (m instanceof FilteredBlock) {
            this.startFilteredBlock((FilteredBlock)m);
        } else if (m instanceof Transaction) {
            this.processTransaction((Transaction)m);
        } else if (m instanceof GetDataMessage) {
            this.processGetData((GetDataMessage)m);
        } else if (m instanceof AddressMessage) {
            this.processAddressMessage((AddressMessage)m);
        } else if (m instanceof HeadersMessage) {
            this.processHeaders((HeadersMessage)m);
        } else if (m instanceof VersionMessage) {
            this.processVersionMessage((VersionMessage)m);
        } else if (m instanceof VersionAck) {
            this.processVersionAck((VersionAck)m);
        } else if (m instanceof RejectMessage) {
            log.error("{} {}: Received {}", this, this.getPeerVersionMessage().subVer, m);
        } else if (!(m instanceof SendHeadersMessage)) {
            if (m instanceof FeeFilterMessage) {
                this.processFeeFilter((FeeFilterMessage)m);
            } else {
                log.warn("{}: Received unhandled message: {}", (Object)this, (Object)m);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAddressMessage(AddressMessage message) {
        CompletableFuture<AddressMessage> future;
        for (ListenerRegistration<AddressEventListener> registration : this.addressEventListeners) {
            registration.executor.execute(() -> ((AddressEventListener)registration.listener).onAddr(this, message));
        }
        LinkedList<CompletableFuture<AddressMessage>> linkedList = this.getAddrFutures;
        synchronized (linkedList) {
            future = this.getAddrFutures.poll();
            if (future == null) {
                return;
            }
        }
        future.complete(message);
    }

    private void processVersionMessage(VersionMessage peerVersionMessage) throws ProtocolException {
        if (this.vPeerVersionMessage != null) {
            throw new ProtocolException("Got two version messages from peer");
        }
        this.vPeerVersionMessage = peerVersionMessage;
        log.info(this.toString());
        Services services = peerVersionMessage.services();
        if (!services.anyOf(1025L) || !this.params.allowEmptyPeerChain() && peerVersionMessage.bestHeight == 0L) {
            log.info("{}: Peer does not have at least a recent part of the block chain.", (Object)this);
            this.close();
            return;
        }
        if (!services.has(this.requiredServices)) {
            log.info("{}: Peer doesn't support these required services: {}", (Object)this, (Object)Services.of(this.requiredServices & (peerVersionMessage.localServices.bits() ^ 0xFFFFFFFFFFFFFFFFL)).toString());
            this.close();
            return;
        }
        if (services.has(32L)) {
            log.info("{}: Peer follows an incompatible block chain.", (Object)this);
            this.close();
            return;
        }
        if (peerVersionMessage.bestHeight < 0L) {
            throw new ProtocolException("Peer reports invalid best height: " + peerVersionMessage.bestHeight);
        }
        this.sendMessage(new SendAddrV2Message());
        this.sendMessage(new VersionAck());
        if (log.isDebugEnabled()) {
            log.debug("{}: Incoming version handshake complete.", (Object)this);
        }
        this.incomingVersionHandshakeFuture.complete(this);
    }

    private void processVersionAck(VersionAck m) throws ProtocolException {
        if (this.vPeerVersionMessage == null) {
            throw new ProtocolException("got a version ack before version");
        }
        if (this.outgoingVersionHandshakeFuture.isDone()) {
            throw new ProtocolException("got more than one version ack");
        }
        if (log.isDebugEnabled()) {
            log.debug("{}: Outgoing version handshake complete.", (Object)this);
        }
        this.outgoingVersionHandshakeFuture.complete(this);
    }

    private void versionHandshakeComplete() {
        if (log.isDebugEnabled()) {
            log.debug("{}: Handshake complete.", (Object)this);
        }
        this.setTimeoutEnabled(false);
        for (ListenerRegistration<PeerConnectedEventListener> registration : this.connectedEventListeners) {
            registration.executor.execute(() -> ((PeerConnectedEventListener)registration.listener).onPeerConnected(this, 1));
        }
        int version = this.vMinProtocolVersion;
        if (this.vPeerVersionMessage.clientVersion < version) {
            log.warn("Connected to a peer speaking protocol version {} but need {}, closing", (Object)this.vPeerVersionMessage.clientVersion, (Object)version);
            this.close();
        }
    }

    protected void startFilteredBlock(FilteredBlock m) {
        this.currentFilteredBlock = m;
    }

    protected void processNotFoundMessage(NotFoundMessage m) {
        block0: for (GetDataRequest getDataRequest : this.getDataFutures) {
            for (InventoryItem item : m.getItems()) {
                if (!item.hash.equals(getDataRequest.hash)) continue;
                log.info("{}: Bottomed out dep tree at {}", (Object)this, (Object)getDataRequest.hash);
                getDataRequest.cancel(true);
                this.getDataFutures.remove(getDataRequest);
                continue block0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processHeaders(HeadersMessage m) throws ProtocolException {
        block21: {
            boolean downloadBlockBodies;
            Instant fastCatchupTime;
            this.lock.lock();
            try {
                if (this.blockChain == null) {
                    log.warn("Received headers when Peer is not configured with a chain.");
                    return;
                }
                fastCatchupTime = this.fastCatchupTime;
                downloadBlockBodies = this.downloadBlockBodies;
            }
            finally {
                this.lock.unlock();
            }
            try {
                Preconditions.checkState(!downloadBlockBodies, () -> this.toString());
                for (int i2 = 0; i2 < m.getBlockHeaders().size(); ++i2) {
                    boolean reachedTop;
                    Block header = m.getBlockHeaders().get(i2);
                    boolean passedTime = header.time().compareTo(fastCatchupTime) >= 0;
                    boolean bl = reachedTop = (long)this.blockChain.getBestChainHeight() >= this.vPeerVersionMessage.bestHeight;
                    if (!passedTime && !reachedTop) {
                        if (!this.vDownloadData) {
                            log.info("Lost download peer status, throwing away downloaded headers.");
                            return;
                        }
                        if (!this.blockChain.add(header)) {
                            throw new ProtocolException("Got unconnected header from peer: " + header.getHashAsString());
                        }
                    } else {
                        this.lock.lock();
                        try {
                            log.info("Passed the fast catchup time ({}) at height {}, discarding {} headers and requesting full blocks", TimeUtils.dateTimeFormat(fastCatchupTime), this.blockChain.getBestChainHeight() + 1, m.getBlockHeaders().size() - i2);
                            this.downloadBlockBodies = true;
                            this.lastGetBlocksBegin = Sha256Hash.ZERO_HASH;
                            this.blockChainDownloadLocked(Sha256Hash.ZERO_HASH);
                        }
                        finally {
                            this.lock.unlock();
                        }
                        return;
                    }
                    this.invokeOnBlocksDownloaded(header, null);
                }
                if (m.getBlockHeaders().size() < 2000) break block21;
                this.lock.lock();
                try {
                    this.blockChainDownloadLocked(Sha256Hash.ZERO_HASH);
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (VerificationException e) {
                log.warn("Block header verification failed", e);
            }
            catch (PrunedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void processGetData(GetDataMessage getdata) {
        log.info("{}: Received getdata message: {}", (Object)this.getAddress(), (Object)getdata.toString());
        ArrayList<Message> items = new ArrayList<Message>();
        for (ListenerRegistration<GetDataEventListener> registration : this.getDataEventListeners) {
            List<Message> listenerItems;
            if (registration.executor != Threading.SAME_THREAD || (listenerItems = ((GetDataEventListener)registration.listener).getData(this, getdata)) == null) continue;
            items.addAll(listenerItems);
        }
        if (items.isEmpty()) {
            return;
        }
        log.info("{}: Sending {} items gathered from listeners to peer", (Object)this.getAddress(), (Object)items.size());
        for (Message item : items) {
            this.sendMessage(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processTransaction(Transaction tx) throws VerificationException {
        Transaction.verify(this.params.network(), tx);
        this.lock.lock();
        try {
            if (log.isDebugEnabled()) {
                log.debug("{}: Received tx {}", (Object)this.getAddress(), (Object)tx.getTxId());
            }
            TransactionConfidence confidence = tx.getConfidence();
            confidence.maybeSetSourceToNetwork();
            this.pendingTxDownloads.remove(confidence);
            if (this.maybeHandleRequestedData(tx, tx.getTxId())) {
                return;
            }
            if (this.currentFilteredBlock != null) {
                if (!this.currentFilteredBlock.provideTransaction(tx)) {
                    this.endFilteredBlock(this.currentFilteredBlock);
                    this.currentFilteredBlock = null;
                }
                return;
            }
            for (Wallet wallet : this.wallets) {
                try {
                    if (!wallet.isPendingTransactionRelevant(tx)) continue;
                    if (this.vDownloadTxDependencyDepth > 0) {
                        this.downloadDependencies(tx).whenComplete((dependencies, throwable) -> {
                            if (throwable == null) {
                                try {
                                    log.info("{}: Dependency download complete!", (Object)this.getAddress());
                                    wallet.receivePending(tx, (List<Transaction>)dependencies);
                                }
                                catch (VerificationException e) {
                                    log.error("{}: Wallet failed to process pending transaction {}", (Object)this.getAddress(), (Object)tx.getTxId());
                                    log.error("Error was: ", e);
                                }
                            } else {
                                log.error("Could not download dependencies of tx {}", (Object)tx.getTxId());
                                log.error("Error was: ", (Throwable)throwable);
                            }
                        });
                        continue;
                    }
                    wallet.receivePending(tx, null);
                }
                catch (VerificationException e) {
                    log.error("Wallet failed to verify tx", e);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        for (ListenerRegistration<OnTransactionBroadcastListener> registration : this.onTransactionEventListeners) {
            registration.executor.execute(() -> ((OnTransactionBroadcastListener)registration.listener).onTransaction(this, tx));
        }
    }

    public ListenableCompletableFuture<List<Transaction>> downloadDependencies(Transaction tx) {
        TransactionConfidence.ConfidenceType txConfidence = tx.getConfidence().getConfidenceType();
        Preconditions.checkArgument(txConfidence != TransactionConfidence.ConfidenceType.BUILDING);
        log.info("{}: Downloading dependencies of {}", (Object)this.getAddress(), (Object)tx.getTxId());
        return ListenableCompletableFuture.of(this.downloadDependenciesInternal(tx, this.vDownloadTxDependencyDepth, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<List<Transaction>> downloadDependenciesInternal(Transaction rootTx, int maxDepth, int depth) {
        CompletableFuture<List<Transaction>> resultFuture = new CompletableFuture<List<Transaction>>();
        Set<Sha256Hash> txIdsToRequest = rootTx.getInputs().stream().map(input -> input.getOutpoint().hash()).collect(Collectors.toSet());
        this.lock.lock();
        try {
            if (txIdsToRequest.size() > 1) {
                log.info("{}: Requesting {} transactions for depth {} dep resolution", this.getAddress(), txIdsToRequest.size(), depth + 1);
            }
            GetDataMessage getdata = this.buildMultiTransactionDataMessage(txIdsToRequest);
            List futures = txIdsToRequest.stream().map(GetDataRequest::new).collect(Collectors.toList());
            this.getDataFutures.addAll(futures);
            CompletableFuture successful = FutureUtils.successfulAsList(futures);
            successful.whenComplete((transactionsWithNulls, throwable) -> {
                if (throwable == null) {
                    List childFutures;
                    List transactions = transactionsWithNulls.stream().filter(Objects::nonNull).peek(tx -> log.info("{}: Downloaded dependency of {}: {}", this.getAddress(), rootTx.getTxId(), tx.getTxId())).collect(Collectors.toList());
                    List list = childFutures = depth + 1 >= maxDepth ? Collections.emptyList() : transactions.stream().map(tx -> this.downloadDependenciesInternal((Transaction)tx, maxDepth, depth + 1)).collect(Collectors.toList());
                    if (childFutures.size() == 0) {
                        resultFuture.complete(transactions);
                    } else {
                        CompletableFuture allSuccessfulChildren = FutureUtils.successfulAsList(childFutures);
                        allSuccessfulChildren.whenComplete((successfulChildrenWithNulls, nestedThrowable) -> {
                            if (nestedThrowable == null) {
                                resultFuture.complete(this.concatDependencies(transactions, (List<List<Transaction>>)successfulChildrenWithNulls));
                            } else {
                                resultFuture.completeExceptionally((Throwable)nestedThrowable);
                            }
                        });
                    }
                } else {
                    resultFuture.completeExceptionally((Throwable)throwable);
                }
            });
            this.sendMessage(getdata);
        }
        catch (Exception e) {
            log.error("{}: Couldn't send getdata in downloadDependencies({})", this, rootTx.getTxId(), e);
            resultFuture.completeExceptionally(e);
            CompletableFuture<List<Transaction>> completableFuture = resultFuture;
            return completableFuture;
        }
        finally {
            this.lock.unlock();
        }
        return resultFuture;
    }

    private GetDataMessage buildMultiTransactionDataMessage(Set<Sha256Hash> txIds) {
        InventoryItem.Type itemType = this.vPeerVersionMessage.services().has(8L) ? InventoryItem.Type.WITNESS_TRANSACTION : InventoryItem.Type.TRANSACTION;
        List<InventoryItem> items = txIds.stream().map(hash -> new InventoryItem(itemType, (Sha256Hash)hash)).collect(Collectors.toList());
        return new GetDataMessage(items);
    }

    private List<Transaction> concatDependencies(List<Transaction> results, List<List<Transaction>> children) {
        return Stream.concat(results.stream(), children.stream().filter(Objects::nonNull).flatMap(Collection::stream)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected void processBlock(Block m) {
        block16: {
            if (log.isDebugEnabled()) {
                log.debug("{}: Received broadcast block {}", (Object)this.getAddress(), (Object)m.getHashAsString());
            }
            if (m.getTransactions() != null) {
                m.getTransactions().forEach(tx -> tx.getConfidence().maybeSetSourceToNetwork());
            }
            if (this.maybeHandleRequestedData(m, m.getHash())) {
                return;
            }
            if (this.blockChain == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Received block but was not configured with an AbstractBlockChain");
                }
                return;
            }
            if (!this.vDownloadData) {
                if (log.isDebugEnabled()) {
                    log.debug("{}: Received block we did not ask for: {}", (Object)this.getAddress(), (Object)m.getHashAsString());
                }
                return;
            }
            this.pendingBlockDownloads.remove(m.getHash());
            try {
                if (this.blockChain.add(m)) {
                    this.invokeOnBlocksDownloaded(m, null);
                    break block16;
                }
                this.lock.lock();
                try {
                    if (this.downloadBlockBodies) {
                        Block orphanRoot = Objects.requireNonNull(this.blockChain.getOrphanRoot(m.getHash()));
                        this.blockChainDownloadLocked(orphanRoot.getHash());
                    } else {
                        log.info("Did not start chain download on solved block due to in-flight header download.");
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (VerificationException e) {
                log.warn("{}: Block verification failed", (Object)this.getAddress(), (Object)e);
            }
            catch (PrunedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void endFilteredBlock(FilteredBlock m) {
        block19: {
            if (log.isDebugEnabled()) {
                log.debug("{}: Received broadcast filtered block {}", (Object)this.getAddress(), (Object)m.getHash().toString());
            }
            if (!this.vDownloadData) {
                if (log.isDebugEnabled()) {
                    log.debug("{}: Received block we did not ask for: {}", (Object)this.getAddress(), (Object)m.getHash().toString());
                }
                return;
            }
            if (this.blockChain == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Received filtered block but was not configured with an AbstractBlockChain");
                }
                return;
            }
            this.pendingBlockDownloads.remove(m.getBlockHeader().getHash());
            try {
                this.lock.lock();
                try {
                    if (this.awaitingFreshFilter != null) {
                        log.info("Discarding block {} because we're still waiting for a fresh filter", (Object)m.getHash());
                        this.awaitingFreshFilter.add(m.getHash());
                        return;
                    }
                    if (this.checkForFilterExhaustion(m)) {
                        log.info("Bloom filter exhausted whilst processing block {}, discarding", (Object)m.getHash());
                        this.awaitingFreshFilter = new LinkedList<Sha256Hash>();
                        this.awaitingFreshFilter.add(m.getHash());
                        this.awaitingFreshFilter.addAll(this.blockChain.drainOrphanBlocks());
                        return;
                    }
                }
                finally {
                    this.lock.unlock();
                }
                if (this.blockChain.add(m)) {
                    this.invokeOnBlocksDownloaded(m.getBlockHeader(), m);
                    break block19;
                }
                this.lock.lock();
                try {
                    Block orphanRoot = Objects.requireNonNull(this.blockChain.getOrphanRoot(m.getHash()));
                    this.blockChainDownloadLocked(orphanRoot.getHash());
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (VerificationException e) {
                log.warn("{}: FilteredBlock verification failed", (Object)this.getAddress(), (Object)e);
            }
            catch (PrunedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private boolean checkForFilterExhaustion(FilteredBlock m) {
        boolean exhausted = false;
        for (Wallet wallet : this.wallets) {
            exhausted |= wallet.checkForFilterExhaustion(m);
        }
        return exhausted;
    }

    private boolean maybeHandleRequestedData(Message m, Sha256Hash hash) {
        boolean found = false;
        for (GetDataRequest getDataRequest : this.getDataFutures) {
            if (!hash.equals(getDataRequest.hash)) continue;
            getDataRequest.complete(m);
            this.getDataFutures.remove(getDataRequest);
            found = true;
        }
        return found;
    }

    private void invokeOnBlocksDownloaded(Block block, @Nullable FilteredBlock fb) {
        int blocksLeft = Math.max(0, (int)this.vPeerVersionMessage.bestHeight - Objects.requireNonNull(this.blockChain).getBestChainHeight());
        for (ListenerRegistration<BlocksDownloadedEventListener> registration : this.blocksDownloadedEventListeners) {
            registration.executor.execute(() -> ((BlocksDownloadedEventListener)registration.listener).onBlocksDownloaded(this, block, fb, blocksLeft));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processInv(InventoryMessage inv) {
        List<InventoryItem> items = inv.getItems();
        LinkedList<Sha256Hash> transactions = new LinkedList<Sha256Hash>();
        LinkedList<Sha256Hash> blocks = new LinkedList<Sha256Hash>();
        block7: for (InventoryItem item : items) {
            switch (item.type) {
                case TRANSACTION: {
                    transactions.add(item.hash);
                    continue block7;
                }
                case BLOCK: {
                    blocks.add(item.hash);
                    continue block7;
                }
            }
            throw new IllegalStateException("Not implemented: " + (Object)((Object)item.type));
        }
        if (log.isDebugEnabled()) {
            log.debug("{}: processing 'inv' with {} items: {} blocks, {} txns", this, items.size(), blocks.size(), transactions.size());
        }
        boolean downloadData = this.vDownloadData;
        if (transactions.isEmpty() && blocks.size() == 1) {
            if (downloadData && this.blockChain != null) {
                if (!this.blockChain.isOrphan((Sha256Hash)blocks.get(0))) {
                    this.blocksAnnounced.incrementAndGet();
                }
            } else {
                this.blocksAnnounced.incrementAndGet();
            }
        }
        InventoryItem.Type txItemType = this.vPeerVersionMessage.services().has(8L) ? InventoryItem.Type.WITNESS_TRANSACTION : InventoryItem.Type.TRANSACTION;
        ArrayList<InventoryItem> getDataItems = new ArrayList<InventoryItem>();
        Iterator it = transactions.iterator();
        while (it.hasNext()) {
            Sha256Hash item = (Sha256Hash)it.next();
            TransactionConfidence conf = this.context.getConfidenceTable().seen(item, this.getAddress());
            if (conf.numBroadcastPeers() > 1) {
                it.remove();
                continue;
            }
            if (conf.getSource().equals((Object)TransactionConfidence.Source.SELF)) {
                it.remove();
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug("{}: getdata on tx {}", (Object)this.getAddress(), (Object)item);
            }
            getDataItems.add(new InventoryItem(txItemType, item));
            if (this.pendingTxDownloads.size() > 100) {
                log.info("{}: Too many pending transactions, disconnecting", (Object)this);
                this.close();
                return;
            }
            this.pendingTxDownloads.add(conf);
        }
        boolean pingAfterGetData = false;
        this.lock.lock();
        try {
            if (blocks.size() > 0 && downloadData && this.blockChain != null) {
                for (Sha256Hash item : blocks) {
                    if (this.blockChain.isOrphan(item) && this.downloadBlockBodies) {
                        Block orphanRoot = Objects.requireNonNull(this.blockChain.getOrphanRoot(item));
                        this.blockChainDownloadLocked(orphanRoot.getHash());
                        continue;
                    }
                    if (this.pendingBlockDownloads.contains(item)) continue;
                    if (this.isBloomFilteringSupported(this.vPeerVersionMessage) && this.useFilteredBlocks) {
                        getDataItems.add(new InventoryItem(InventoryItem.Type.FILTERED_BLOCK, item));
                        pingAfterGetData = true;
                    } else {
                        getDataItems.add(new InventoryItem(InventoryItem.Type.BLOCK, item));
                    }
                    this.pendingBlockDownloads.add(item);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        if (!getDataItems.isEmpty()) {
            GetDataMessage getdata = new GetDataMessage(getDataItems);
            this.sendMessage(getdata);
        }
        if (pingAfterGetData) {
            this.sendMessage(Ping.random());
        }
    }

    public ListenableCompletableFuture<Block> getBlock(Sha256Hash blockHash) {
        log.info("Request to fetch block {}", (Object)blockHash);
        GetDataMessage getdata = GetDataMessage.ofBlock(blockHash, true);
        return ListenableCompletableFuture.of(this.sendSingleGetData(getdata));
    }

    public ListenableCompletableFuture<Transaction> getPeerMempoolTransaction(Sha256Hash hash) {
        log.info("Request to fetch peer mempool tx  {}", (Object)hash);
        GetDataMessage getdata = GetDataMessage.ofTransaction(hash, this.vPeerVersionMessage.services().has(8L));
        return ListenableCompletableFuture.of(this.sendSingleGetData(getdata));
    }

    private <T> CompletableFuture<T> sendSingleGetData(GetDataMessage getdata) {
        Preconditions.checkArgument(getdata.getItems().size() == 1);
        GetDataRequest req = new GetDataRequest(getdata.getItems().get((int)0).hash);
        this.getDataFutures.add(req);
        this.sendMessage(getdata);
        return req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableCompletableFuture<AddressMessage> getAddr() {
        ListenableCompletableFuture<AddressMessage> future = new ListenableCompletableFuture<AddressMessage>();
        LinkedList<CompletableFuture<AddressMessage>> linkedList = this.getAddrFutures;
        synchronized (linkedList) {
            this.getAddrFutures.add(future);
        }
        this.sendMessage(new GetAddrMessage());
        return future;
    }

    public void setFastDownloadParameters(boolean useFilteredBlocks, Instant fastCatchupTime) {
        this.lock.lock();
        try {
            this.fastCatchupTime = fastCatchupTime;
            if (this.blockChain != null && this.fastCatchupTime.isAfter(this.blockChain.getChainHead().getHeader().time())) {
                this.downloadBlockBodies = false;
            }
            this.useFilteredBlocks = useFilteredBlocks;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setDownloadParameters(boolean useFilteredBlocks) {
        this.lock.lock();
        try {
            this.fastCatchupTime = this.params.getGenesisBlock().time();
            this.downloadBlockBodies = true;
            this.useFilteredBlocks = useFilteredBlocks;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Deprecated
    public void setDownloadParameters(long fastCatchupTimeSecs, boolean useFilteredBlocks) {
        if (fastCatchupTimeSecs > 0L) {
            this.setFastDownloadParameters(useFilteredBlocks, Instant.ofEpochSecond(fastCatchupTimeSecs));
        } else {
            this.setDownloadParameters(useFilteredBlocks);
        }
    }

    public void addWallet(Wallet wallet) {
        this.wallets.add(wallet);
    }

    public void removeWallet(Wallet wallet) {
        this.wallets.remove(wallet);
    }

    @GuardedBy(value="lock")
    private void blockChainDownloadLocked(Sha256Hash toHash) {
        Preconditions.checkState(this.lock.isHeldByCurrentThread());
        Sha256Hash chainHeadHash = this.blockChain.getChainHead().getHeader().getHash();
        if (Objects.equals(this.lastGetBlocksBegin, chainHeadHash) && Objects.equals(this.lastGetBlocksEnd, toHash)) {
            log.info("blockChainDownloadLocked({}): ignoring duplicated request: {}", (Object)toHash, (Object)chainHeadHash);
            for (Sha256Hash hash : this.pendingBlockDownloads) {
                log.info("Pending block download: {}", (Object)hash);
            }
            log.info(Throwables.getStackTraceAsString((Throwable)new Throwable()));
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("{}: blockChainDownloadLocked({}) current head = {}", this, toHash, chainHeadHash.toString());
        }
        this.lastGetBlocksBegin = chainHeadHash;
        this.lastGetBlocksEnd = toHash;
        long protocolVersion = this.params.getSerializer().getProtocolVersion();
        BlockLocator blockLocator = Peer.buildBlockLocator(this.blockChain);
        GetBlocksMessage message = this.downloadBlockBodies ? new GetBlocksMessage(protocolVersion, blockLocator, toHash) : new GetHeadersMessage(protocolVersion, blockLocator, toHash);
        this.sendMessage(message);
    }

    private static BlockLocator buildBlockLocator(AbstractBlockChain blockChain) {
        BlockStore store = Objects.requireNonNull(blockChain).getBlockStore();
        StoredBlock chainHead = blockChain.getChainHead();
        ArrayList<Sha256Hash> hashList = new ArrayList<Sha256Hash>(100);
        StoredBlock cursor = chainHead;
        for (int i2 = 100; cursor != null && i2 > 0; cursor = cursor.getPrev(store), --i2) {
            hashList.add(cursor.getHeader().getHash());
            try {
                continue;
            }
            catch (BlockStoreException e) {
                log.error("Failed to walk the block chain whilst constructing a locator");
                throw new RuntimeException(e);
            }
        }
        if (cursor != null) {
            hashList.add(blockChain.params.getGenesisBlock().getHash());
        }
        return new BlockLocator(hashList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBlockChainDownload() {
        this.setDownloadData(true);
        int blocksLeft = this.getPeerBlockHeightDifference();
        if (blocksLeft >= 0) {
            for (ListenerRegistration<ChainDownloadStartedEventListener> registration : this.chainDownloadStartedEventListeners) {
                registration.executor.execute(() -> ((ChainDownloadStartedEventListener)registration.listener).onChainDownloadStarted(this, blocksLeft));
            }
            this.lock.lock();
            try {
                this.blockChainDownloadLocked(Sha256Hash.ZERO_HASH);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void addPingInterval(Duration sample) {
        this.pingIntervalsLock.lock();
        try {
            if (this.pingIntervals.size() >= 20) {
                this.pingIntervals.remove();
            }
            this.pingIntervals.add(sample);
            this.lastPing = sample;
            this.averagePing = this.pingIntervals.stream().reduce(Duration::plus).map(d -> d.dividedBy(this.pingIntervals.size())).orElse(null);
        }
        finally {
            this.pingIntervalsLock.unlock();
        }
    }

    public CompletableFuture<Duration> sendPing() {
        return this.sendPing((long)(Math.random() * 9.223372036854776E18));
    }

    protected CompletableFuture<Duration> sendPing(long nonce) {
        VersionMessage ver = this.vPeerVersionMessage;
        if (this.pendingPings.size() > 50) {
            log.info("{}: Too many pending pings, disconnecting", (Object)this);
            this.close();
        }
        PendingPing pendingPing = new PendingPing(nonce);
        this.pendingPings.add(pendingPing);
        this.sendMessage(Ping.of(pendingPing.nonce));
        return pendingPing.future;
    }

    @Deprecated
    public ListenableCompletableFuture<Long> ping() {
        return ListenableCompletableFuture.of(this.sendPing().thenApply(Duration::toMillis));
    }

    public Optional<Duration> lastPingInterval() {
        return Optional.ofNullable(this.lastPing);
    }

    @Deprecated
    public long getLastPingTime() {
        return this.lastPingInterval().map(Duration::toMillis).orElse(Long.MAX_VALUE);
    }

    public Optional<Duration> pingInterval() {
        return Optional.ofNullable(this.averagePing);
    }

    @Deprecated
    public long getPingTime() {
        return this.pingInterval().map(Duration::toMillis).orElse(Long.MAX_VALUE);
    }

    private void processPing(Ping m) {
        this.sendMessage(m.pong());
    }

    protected void processPong(Pong m) {
        for (PendingPing ping : this.pendingPings) {
            if (m.nonce() != ping.nonce) continue;
            this.pendingPings.remove(ping);
            ping.complete();
            return;
        }
    }

    private void processFeeFilter(FeeFilterMessage m) {
        if (log.isDebugEnabled()) {
            log.debug("{}: Announced fee filter: {}/kB", (Object)this, (Object)m.feeRate().toFriendlyString());
        }
        this.vFeeFilter = m.feeRate();
    }

    public int getPeerBlockHeightDifference() {
        Objects.requireNonNull(this.blockChain, "No block chain configured");
        int chainHeight = (int)this.getBestHeight();
        Preconditions.checkState(this.params.allowEmptyPeerChain() || chainHeight > 0, () -> "connected to peer with zero/negative chain height: " + chainHeight);
        return chainHeight - this.blockChain.getBestChainHeight();
    }

    public boolean isDownloadData() {
        return this.vDownloadData;
    }

    public void setDownloadData(boolean downloadData) {
        this.vDownloadData = downloadData;
    }

    public VersionMessage getPeerVersionMessage() {
        return this.vPeerVersionMessage;
    }

    public Coin getFeeFilter() {
        return this.vFeeFilter;
    }

    public VersionMessage getVersionMessage() {
        return this.versionMessage;
    }

    public long getBestHeight() {
        return this.vPeerVersionMessage.bestHeight + (long)this.blocksAnnounced.get();
    }

    public boolean setMinProtocolVersion(int minProtocolVersion) {
        this.vMinProtocolVersion = minProtocolVersion;
        VersionMessage ver = this.getPeerVersionMessage();
        if (ver != null && ver.clientVersion < minProtocolVersion) {
            log.warn("{}: Disconnecting due to new min protocol version {}, got: {}", this, minProtocolVersion, ver.clientVersion);
            this.close();
            return true;
        }
        return false;
    }

    public void setBloomFilter(BloomFilter filter2) {
        this.setBloomFilter(filter2, true);
    }

    public void setBloomFilter(BloomFilter filter2, boolean andQueryMemPool) {
        Objects.requireNonNull(filter2, "Clearing filters is not currently supported");
        VersionMessage version = this.vPeerVersionMessage;
        Objects.requireNonNull(version, "Cannot set filter before version handshake is complete");
        if (this.isBloomFilteringSupported(version)) {
            this.vBloomFilter = filter2;
            log.info("{}: Sending Bloom filter{}", (Object)this, (Object)(andQueryMemPool ? " and querying mempool" : ""));
            this.sendMessage(filter2);
            if (andQueryMemPool) {
                this.sendMessage(new MemoryPoolMessage());
            }
            this.maybeRestartChainDownload();
        } else {
            log.info("{}: Peer does not support bloom filtering.", (Object)this);
            this.close();
        }
    }

    private void maybeRestartChainDownload() {
        this.lock.lock();
        try {
            if (this.awaitingFreshFilter == null) {
                return;
            }
            if (!this.vDownloadData) {
                log.warn("Lost download peer status whilst awaiting fresh filter.");
                return;
            }
            this.sendPing().thenRunAsync(() -> {
                this.lock.lock();
                Objects.requireNonNull(this.awaitingFreshFilter);
                List<InventoryItem> items = this.awaitingFreshFilter.stream().map(hash -> new InventoryItem(InventoryItem.Type.FILTERED_BLOCK, (Sha256Hash)hash)).collect(Collectors.toList());
                GetDataMessage getdata = new GetDataMessage(items);
                this.awaitingFreshFilter = null;
                this.lock.unlock();
                log.info("Restarting chain download");
                this.sendMessage(getdata);
                this.sendMessage(Ping.random());
            }, Threading.SAME_THREAD);
        }
        finally {
            this.lock.unlock();
        }
    }

    public BloomFilter getBloomFilter() {
        return this.vBloomFilter;
    }

    public boolean isDownloadTxDependencies() {
        return this.vDownloadTxDependencyDepth > 0;
    }

    public void setDownloadTxDependencies(boolean enable) {
        this.vDownloadTxDependencyDepth = enable ? Integer.MAX_VALUE : 0;
    }

    public void setDownloadTxDependencies(int depth) {
        this.vDownloadTxDependencyDepth = depth;
    }

    private boolean isBloomFilteringSupported(VersionMessage version) {
        int clientVersion = version.clientVersion();
        if (clientVersion >= ProtocolVersion.BLOOM_FILTER.intValue() && clientVersion < ProtocolVersion.BLOOM_FILTER_BIP111.intValue()) {
            return true;
        }
        return version.services().has(4L);
    }

    private static class GetDataRequest<T>
    extends CompletableFuture<T> {
        final Sha256Hash hash;

        public GetDataRequest(Sha256Hash hash) {
            this.hash = hash;
        }
    }

    private class PendingPing {
        public final CompletableFuture<Duration> future = new CompletableFuture();
        public final long nonce;
        public final Instant startTime;

        public PendingPing(long nonce) {
            this.nonce = nonce;
            this.startTime = TimeUtils.currentTime();
        }

        public void complete() {
            if (!this.future.isDone()) {
                Duration elapsed = TimeUtils.elapsedTime(this.startTime);
                Peer.this.addPingInterval(elapsed);
                if (log.isDebugEnabled()) {
                    log.debug("{}: ping time is {} ms", (Object)Peer.this.toString(), (Object)elapsed.toMillis());
                }
                this.future.complete(elapsed);
            }
        }
    }
}

