/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.Runnables;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketAddress;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import net.jcip.annotations.GuardedBy;
import org.bitcoinj.base.Network;
import org.bitcoinj.base.internal.InternalUtils;
import org.bitcoinj.base.internal.PlatformUtils;
import org.bitcoinj.base.internal.Preconditions;
import org.bitcoinj.base.internal.Stopwatch;
import org.bitcoinj.base.internal.TimeUtils;
import org.bitcoinj.core.AbstractBlockChain;
import org.bitcoinj.core.AddressMessage;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.BloomFilter;
import org.bitcoinj.core.Context;
import org.bitcoinj.core.FilteredBlock;
import org.bitcoinj.core.GetAddrMessage;
import org.bitcoinj.core.GetDataMessage;
import org.bitcoinj.core.InventoryItem;
import org.bitcoinj.core.Message;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Peer;
import org.bitcoinj.core.PeerAddress;
import org.bitcoinj.core.PeerFilterProvider;
import org.bitcoinj.core.ProtocolVersion;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionBroadcast;
import org.bitcoinj.core.TransactionBroadcaster;
import org.bitcoinj.core.TransactionConfidence;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.core.TxConfidenceTable;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.core.VersionMessage;
import org.bitcoinj.core.listeners.AddressEventListener;
import org.bitcoinj.core.listeners.BlockchainDownloadEventListener;
import org.bitcoinj.core.listeners.BlocksDownloadedEventListener;
import org.bitcoinj.core.listeners.ChainDownloadStartedEventListener;
import org.bitcoinj.core.listeners.DownloadProgressTracker;
import org.bitcoinj.core.listeners.GetDataEventListener;
import org.bitcoinj.core.listeners.OnTransactionBroadcastListener;
import org.bitcoinj.core.listeners.PeerConnectedEventListener;
import org.bitcoinj.core.listeners.PeerDisconnectedEventListener;
import org.bitcoinj.core.listeners.PeerDiscoveredEventListener;
import org.bitcoinj.core.listeners.PreMessageReceivedEventListener;
import org.bitcoinj.net.ClientConnectionManager;
import org.bitcoinj.net.FilterMerger;
import org.bitcoinj.net.NioClientManager;
import org.bitcoinj.net.discovery.MultiplexingDiscovery;
import org.bitcoinj.net.discovery.PeerDiscovery;
import org.bitcoinj.net.discovery.PeerDiscoveryException;
import org.bitcoinj.script.Script;
import org.bitcoinj.script.ScriptPattern;
import org.bitcoinj.utils.ContextPropagatingThreadFactory;
import org.bitcoinj.utils.ExponentialBackoff;
import org.bitcoinj.utils.ListenableCompletableFuture;
import org.bitcoinj.utils.ListenerRegistration;
import org.bitcoinj.utils.Threading;
import org.bitcoinj.wallet.Wallet;
import org.bitcoinj.wallet.listeners.KeyChainEventListener;
import org.bitcoinj.wallet.listeners.ScriptsChangeEventListener;
import org.bitcoinj.wallet.listeners.WalletCoinsReceivedEventListener;
import org.bitcoinj.wallet.listeners.WalletCoinsSentEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerGroup
implements TransactionBroadcaster {
    private static final Logger log = LoggerFactory.getLogger(PeerGroup.class);
    protected final ReentrantLock lock = Threading.lock(PeerGroup.class);
    private long requiredServices = 0L;
    public static final int DEFAULT_CONNECTIONS = 12;
    private volatile int vMaxPeersToDiscoverCount = 100;
    private static final Duration DEFAULT_PEER_DISCOVERY_TIMEOUT = Duration.ofSeconds(5L);
    private volatile Duration vPeerDiscoveryTimeout = DEFAULT_PEER_DISCOVERY_TIMEOUT;
    protected final NetworkParameters params;
    @Nullable
    protected final AbstractBlockChain chain;
    protected final ScheduledExecutorService executor;
    private volatile boolean vRunning;
    private volatile boolean vUsedUp;
    @GuardedBy(value="lock")
    private final PriorityQueue<PeerAddress> inactives;
    @GuardedBy(value="lock")
    private final Map<PeerAddress, ExponentialBackoff> backoffMap;
    @GuardedBy(value="lock")
    private final Map<PeerAddress, Integer> priorityMap;
    private final CopyOnWriteArrayList<Peer> peers;
    private final CopyOnWriteArrayList<Peer> pendingPeers;
    private final ClientConnectionManager channels;
    @GuardedBy(value="lock")
    private Peer downloadPeer;
    @Nullable
    @GuardedBy(value="lock")
    private BlockchainDownloadEventListener downloadListener;
    private final CopyOnWriteArrayList<ListenerRegistration<BlocksDownloadedEventListener>> peersBlocksDownloadedEventListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ListenerRegistration<ChainDownloadStartedEventListener>> peersChainDownloadStartedEventListeners = new CopyOnWriteArrayList();
    protected final CopyOnWriteArrayList<ListenerRegistration<PeerConnectedEventListener>> peerConnectedEventListeners = new CopyOnWriteArrayList();
    protected final CopyOnWriteArrayList<ListenerRegistration<PeerDiscoveredEventListener>> peerDiscoveredEventListeners = new CopyOnWriteArrayList();
    protected final CopyOnWriteArrayList<ListenerRegistration<PeerDisconnectedEventListener>> peerDisconnectedEventListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ListenerRegistration<GetDataEventListener>> peerGetDataEventListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ListenerRegistration<PreMessageReceivedEventListener>> peersPreMessageReceivedEventListeners = new CopyOnWriteArrayList();
    protected final CopyOnWriteArrayList<ListenerRegistration<OnTransactionBroadcastListener>> peersTransactionBroadastEventListeners = new CopyOnWriteArrayList();
    private volatile boolean vDiscoverPeersViaP2P = false;
    private final CopyOnWriteArraySet<PeerDiscovery> peerDiscoverers;
    @GuardedBy(value="lock")
    private VersionMessage versionMessage;
    @GuardedBy(value="lock")
    private int downloadTxDependencyDepth;
    @GuardedBy(value="lock")
    private int maxConnections;
    private volatile int vMinRequiredProtocolVersion;
    public static final long DEFAULT_PING_INTERVAL_MSEC = 2000L;
    @GuardedBy(value="lock")
    private long pingIntervalMsec = 2000L;
    @GuardedBy(value="lock")
    private boolean useLocalhostPeerWhenPossible = true;
    @GuardedBy(value="lock")
    private boolean ipv6Unreachable = false;
    @GuardedBy(value="lock")
    private Instant fastCatchupTime;
    private final CopyOnWriteArrayList<Wallet> wallets;
    private final CopyOnWriteArrayList<PeerFilterProvider> peerFilterProviders;
    private final PeerListener peerListener = new PeerListener();
    private int minBroadcastConnections = 0;
    private final ScriptsChangeEventListener walletScriptsEventListener = (wallet, scripts, isAddingScripts) -> this.recalculateFastCatchupAndFilter(FilterRecalculateMode.SEND_IF_CHANGED);
    private final KeyChainEventListener walletKeyEventListener = keys2 -> this.recalculateFastCatchupAndFilter(FilterRecalculateMode.SEND_IF_CHANGED);
    private final WalletCoinsReceivedEventListener walletCoinsReceivedEventListener = (wallet, tx, prevBalance, newBalance) -> this.onCoinsReceivedOrSent(wallet, tx);
    private final WalletCoinsSentEventListener walletCoinsSentEventListener = (wallet, tx, prevBalance, newBalance) -> this.onCoinsReceivedOrSent(wallet, tx);
    public static final int MAX_ADDRESSES_PER_ADDR_MESSAGE = 16;
    private final ExponentialBackoff.Params peerBackoffParams = new ExponentialBackoff.Params(Duration.ofSeconds(1L), 1.5f, Duration.ofMinutes(10L));
    @GuardedBy(value="lock")
    private ExponentialBackoff groupBackoff = new ExponentialBackoff(new ExponentialBackoff.Params(Duration.ofSeconds(1L), 1.5f, Duration.ofSeconds(10L)));
    private final Set<TransactionBroadcast> runningBroadcasts;
    private final PeerStartupListener startupListener = new PeerStartupListener();
    public static final double DEFAULT_BLOOM_FILTER_FP_RATE = 1.0E-5;
    public static final double MAX_FP_RATE_INCREASE = 10.0;
    private final FilterMerger bloomFilterMerger;
    public static final Duration DEFAULT_CONNECT_TIMEOUT = Duration.ofSeconds(5L);
    private volatile Duration vConnectTimeout = DEFAULT_CONNECT_TIMEOUT;
    private volatile boolean vBloomFilteringEnabled = true;
    private CountDownLatch executorStartupLatch = new CountDownLatch(1);
    private Runnable triggerConnectionsJob = new Runnable(){
        private boolean firstRun = true;
        private final Duration MIN_PEER_DISCOVERY_INTERVAL = Duration.ofSeconds(1L);

        @Override
        public void run() {
            try {
                this.go();
            }
            catch (Throwable e) {
                log.error("Exception when trying to build connections", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void go() {
            if (!PeerGroup.this.vRunning) {
                return;
            }
            boolean doDiscovery = false;
            Instant now = TimeUtils.currentTime();
            PeerGroup.this.lock.lock();
            try {
                if (!PlatformUtils.isAndroidRuntime() && PeerGroup.this.useLocalhostPeerWhenPossible && PeerGroup.this.maybeCheckForLocalhostPeer() && this.firstRun) {
                    log.info("Localhost peer detected, trying to use it instead of P2P discovery");
                    PeerGroup.this.maxConnections = 0;
                    PeerGroup.this.connectToLocalHost();
                    return;
                }
                boolean havePeerWeCanTry = !PeerGroup.this.inactives.isEmpty() && ((ExponentialBackoff)PeerGroup.this.backoffMap.get(PeerGroup.this.inactives.peek())).retryTime().isBefore(now);
                doDiscovery = !havePeerWeCanTry;
            }
            finally {
                this.firstRun = false;
                PeerGroup.this.lock.unlock();
            }
            boolean discoverySuccess = false;
            if (doDiscovery) {
                discoverySuccess = PeerGroup.this.discoverPeers() > 0;
            }
            PeerGroup.this.lock.lock();
            try {
                PeerAddress addrToTry;
                if (doDiscovery) {
                    if (discoverySuccess && PeerGroup.this.countConnectedAndPendingPeers() >= PeerGroup.this.getMaxConnections()) {
                        PeerGroup.this.groupBackoff.trackSuccess();
                    } else {
                        PeerGroup.this.groupBackoff.trackFailure();
                    }
                }
                if (PeerGroup.this.inactives.isEmpty()) {
                    if (PeerGroup.this.countConnectedAndPendingPeers() < PeerGroup.this.getMaxConnections()) {
                        Duration interval = TimeUtils.longest(Duration.between(now, PeerGroup.this.groupBackoff.retryTime()), this.MIN_PEER_DISCOVERY_INTERVAL);
                        log.info("Peer discovery didn't provide us any more peers, will try again in " + interval.toMillis() + " ms.");
                        PeerGroup.this.executor.schedule(this, interval.toMillis(), TimeUnit.MILLISECONDS);
                    }
                    return;
                }
                do {
                    addrToTry = (PeerAddress)PeerGroup.this.inactives.poll();
                } while (PeerGroup.this.ipv6Unreachable && addrToTry.getAddr() instanceof Inet6Address);
                if (addrToTry == null) {
                    return;
                }
                Instant retryTime = ((ExponentialBackoff)PeerGroup.this.backoffMap.get(addrToTry)).retryTime();
                if ((retryTime = TimeUtils.later(retryTime, PeerGroup.this.groupBackoff.retryTime())).isAfter(now)) {
                    Duration delay = Duration.between(now, retryTime);
                    log.info("Waiting {} ms before next connect attempt to {}", (Object)delay.toMillis(), (Object)addrToTry);
                    PeerGroup.this.inactives.add(addrToTry);
                    PeerGroup.this.executor.schedule(this, delay.toMillis(), TimeUnit.MILLISECONDS);
                    return;
                }
                PeerGroup.this.connectTo(addrToTry, false, PeerGroup.this.vConnectTimeout);
            }
            finally {
                PeerGroup.this.lock.unlock();
            }
            if (PeerGroup.this.countConnectedAndPendingPeers() < PeerGroup.this.getMaxConnections()) {
                PeerGroup.this.executor.execute(this);
            }
        }
    };
    private LocalhostCheckState localhostCheckState = LocalhostCheckState.NOT_TRIED;
    private final Map<FilterRecalculateMode, ListenableCompletableFuture<BloomFilter>> inFlightRecalculations = Maps.newHashMap();
    @Nullable
    private volatile ScheduledFuture<?> vPingTask;
    @GuardedBy(value="lock")
    private int stallPeriodSeconds = 10;
    @GuardedBy(value="lock")
    private int stallMinSpeedBytesSec = 800;
    @Nullable
    private ChainDownloadSpeedCalculator chainDownloadSpeedCalculator;

    private void onCoinsReceivedOrSent(Wallet wallet, Transaction tx) {
        for (TransactionOutput output : tx.getOutputs()) {
            Script scriptPubKey = output.getScriptPubKey();
            if (!ScriptPattern.isP2PK(scriptPubKey) && !ScriptPattern.isP2WPKH(scriptPubKey) || !output.isMine(wallet)) continue;
            if (tx.getConfidence().getConfidenceType() == TransactionConfidence.ConfidenceType.BUILDING) {
                this.recalculateFastCatchupAndFilter(FilterRecalculateMode.SEND_IF_CHANGED);
            } else {
                this.recalculateFastCatchupAndFilter(FilterRecalculateMode.DONT_SEND);
            }
            return;
        }
    }

    public PeerGroup(Network network) {
        this(network, null);
    }

    @Deprecated
    public PeerGroup(NetworkParameters params) {
        this(params.network());
    }

    public PeerGroup(Network network, @Nullable AbstractBlockChain chain) {
        this(network, chain, new NioClientManager());
    }

    @Deprecated
    public PeerGroup(NetworkParameters params, @Nullable AbstractBlockChain chain) {
        this(params.network(), chain);
    }

    protected PeerGroup(Network network, @Nullable AbstractBlockChain chain, ClientConnectionManager connectionManager) {
        this(NetworkParameters.of(Objects.requireNonNull(network)), chain, connectionManager, 1.0E-5);
    }

    protected PeerGroup(Network network, @Nullable AbstractBlockChain chain, ClientConnectionManager connectionManager, double bloomFilterFpRate) {
        this(NetworkParameters.of(Objects.requireNonNull(network)), chain, connectionManager, bloomFilterFpRate);
    }

    protected PeerGroup(NetworkParameters params, @Nullable AbstractBlockChain chain, ClientConnectionManager connectionManager, double bloomFilterFpRate) {
        Objects.requireNonNull(params);
        Context.getOrCreate();
        this.params = params;
        this.chain = chain;
        this.fastCatchupTime = params.getGenesisBlock().time();
        this.wallets = new CopyOnWriteArrayList();
        this.peerFilterProviders = new CopyOnWriteArrayList();
        this.executor = this.createPrivateExecutor();
        this.maxConnections = 0;
        int height = chain == null ? 0 : chain.getBestChainHeight();
        this.versionMessage = new VersionMessage(params, height);
        this.versionMessage.relayTxesBeforeFilter = true;
        this.downloadTxDependencyDepth = Integer.MAX_VALUE;
        this.inactives = new PriorityQueue<PeerAddress>(1, new Comparator<PeerAddress>(){

            @Override
            public int compare(PeerAddress a, PeerAddress b) {
                Preconditions.checkState(PeerGroup.this.lock.isHeldByCurrentThread());
                int result = ((ExponentialBackoff)PeerGroup.this.backoffMap.get(a)).compareTo((ExponentialBackoff)PeerGroup.this.backoffMap.get(b));
                if (result != 0) {
                    return result;
                }
                result = Integer.compare(PeerGroup.this.getPriority(a), PeerGroup.this.getPriority(b));
                if (result != 0) {
                    return result;
                }
                result = Integer.compare(a.getPort(), b.getPort());
                return result;
            }
        });
        this.backoffMap = new HashMap<PeerAddress, ExponentialBackoff>();
        this.priorityMap = new ConcurrentHashMap<PeerAddress, Integer>();
        this.peers = new CopyOnWriteArrayList();
        this.pendingPeers = new CopyOnWriteArrayList();
        this.channels = connectionManager;
        this.peerDiscoverers = new CopyOnWriteArraySet();
        this.runningBroadcasts = Collections.synchronizedSet(new HashSet());
        this.bloomFilterMerger = new FilterMerger(bloomFilterFpRate);
        this.vMinRequiredProtocolVersion = ProtocolVersion.BLOOM_FILTER.intValue();
    }

    protected ScheduledExecutorService createPrivateExecutor() {
        ScheduledThreadPoolExecutor result = new ScheduledThreadPoolExecutor(1, new ContextPropagatingThreadFactory("PeerGroup Thread"));
        result.execute(() -> Uninterruptibles.awaitUninterruptibly((CountDownLatch)this.executorStartupLatch));
        return result;
    }

    public void setPeerDiscoveryTimeout(Duration peerDiscoveryTimeout) {
        this.vPeerDiscoveryTimeout = peerDiscoveryTimeout;
    }

    @Deprecated
    public void setPeerDiscoveryTimeoutMillis(long peerDiscoveryTimeoutMillis) {
        this.setPeerDiscoveryTimeout(Duration.ofMillis(peerDiscoveryTimeoutMillis));
    }

    public void setMaxConnections(int maxConnections) {
        this.lock.lock();
        try {
            this.maxConnections = maxConnections;
            if (!this.isRunning()) {
                return;
            }
        }
        finally {
            this.lock.unlock();
        }
        int adjustment = maxConnections - this.channels.getConnectedClientCount();
        if (adjustment > 0) {
            this.triggerConnections();
        }
        if (adjustment < 0) {
            this.channels.closeConnections(-adjustment);
        }
    }

    public void setDownloadTxDependencies(int depth) {
        this.lock.lock();
        try {
            this.downloadTxDependencyDepth = depth;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void triggerConnections() {
        if (!this.executor.isShutdown()) {
            this.executor.execute(this.triggerConnectionsJob);
        }
    }

    public int getMaxConnections() {
        this.lock.lock();
        try {
            int n = this.maxConnections;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Message> handleGetData(GetDataMessage m) {
        this.lock.lock();
        try {
            LinkedList<Message> transactions = new LinkedList<Message>();
            LinkedList<InventoryItem> items = new LinkedList<InventoryItem>(m.getItems());
            Iterator it = items.iterator();
            block3: while (it.hasNext()) {
                InventoryItem item = (InventoryItem)it.next();
                for (Wallet w : this.wallets) {
                    Transaction tx = w.getTransaction(item.hash);
                    if (tx == null) continue;
                    transactions.add(tx);
                    it.remove();
                    continue block3;
                }
            }
            LinkedList<Message> linkedList = transactions;
            return linkedList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setVersionMessage(VersionMessage ver) {
        this.lock.lock();
        try {
            this.versionMessage = ver;
        }
        finally {
            this.lock.unlock();
        }
    }

    public VersionMessage getVersionMessage() {
        this.lock.lock();
        try {
            VersionMessage versionMessage = this.versionMessage;
            return versionMessage;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setUserAgent(String name, String version, @Nullable String comments) {
        int height = this.chain == null ? 0 : this.chain.getBestChainHeight();
        VersionMessage ver = new VersionMessage(this.params, height);
        ver.relayTxesBeforeFilter = false;
        this.updateVersionMessageRelayTxesBeforeFilter(ver);
        ver.appendToSubVer(name, version, comments);
        this.setVersionMessage(ver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateVersionMessageRelayTxesBeforeFilter(VersionMessage ver) {
        this.lock.lock();
        try {
            boolean spvMode = this.chain != null && !this.chain.shouldVerifyTransactions();
            boolean willSendFilter = spvMode && this.peerFilterProviders.size() > 0 && this.vBloomFilteringEnabled;
            ver.relayTxesBeforeFilter = !willSendFilter;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setUserAgent(String name, String version) {
        this.setUserAgent(name, version, null);
    }

    public void addBlocksDownloadedEventListener(BlocksDownloadedEventListener listener) {
        this.addBlocksDownloadedEventListener(Threading.USER_THREAD, listener);
    }

    public void addBlocksDownloadedEventListener(Executor executor, BlocksDownloadedEventListener listener) {
        this.peersBlocksDownloadedEventListeners.add(new ListenerRegistration<BlocksDownloadedEventListener>(Objects.requireNonNull(listener), executor));
        for (Peer peer : this.getConnectedPeers()) {
            peer.addBlocksDownloadedEventListener(executor, listener);
        }
        for (Peer peer : this.getPendingPeers()) {
            peer.addBlocksDownloadedEventListener(executor, listener);
        }
    }

    public void addChainDownloadStartedEventListener(ChainDownloadStartedEventListener listener) {
        this.addChainDownloadStartedEventListener(Threading.USER_THREAD, listener);
    }

    public void addChainDownloadStartedEventListener(Executor executor, ChainDownloadStartedEventListener listener) {
        this.peersChainDownloadStartedEventListeners.add(new ListenerRegistration<ChainDownloadStartedEventListener>(Objects.requireNonNull(listener), executor));
        for (Peer peer : this.getConnectedPeers()) {
            peer.addChainDownloadStartedEventListener(executor, listener);
        }
        for (Peer peer : this.getPendingPeers()) {
            peer.addChainDownloadStartedEventListener(executor, listener);
        }
    }

    public void addConnectedEventListener(PeerConnectedEventListener listener) {
        this.addConnectedEventListener(Threading.USER_THREAD, listener);
    }

    public void addConnectedEventListener(Executor executor, PeerConnectedEventListener listener) {
        this.peerConnectedEventListeners.add(new ListenerRegistration<PeerConnectedEventListener>(Objects.requireNonNull(listener), executor));
        for (Peer peer : this.getConnectedPeers()) {
            peer.addConnectedEventListener(executor, listener);
        }
        for (Peer peer : this.getPendingPeers()) {
            peer.addConnectedEventListener(executor, listener);
        }
    }

    public void addDisconnectedEventListener(PeerDisconnectedEventListener listener) {
        this.addDisconnectedEventListener(Threading.USER_THREAD, listener);
    }

    public void addDisconnectedEventListener(Executor executor, PeerDisconnectedEventListener listener) {
        this.peerDisconnectedEventListeners.add(new ListenerRegistration<PeerDisconnectedEventListener>(Objects.requireNonNull(listener), executor));
        for (Peer peer : this.getConnectedPeers()) {
            peer.addDisconnectedEventListener(executor, listener);
        }
        for (Peer peer : this.getPendingPeers()) {
            peer.addDisconnectedEventListener(executor, listener);
        }
    }

    public void addDiscoveredEventListener(PeerDiscoveredEventListener listener) {
        this.addDiscoveredEventListener(Threading.USER_THREAD, listener);
    }

    public void addDiscoveredEventListener(Executor executor, PeerDiscoveredEventListener listener) {
        this.peerDiscoveredEventListeners.add(new ListenerRegistration<PeerDiscoveredEventListener>(Objects.requireNonNull(listener), executor));
    }

    public void addGetDataEventListener(GetDataEventListener listener) {
        this.addGetDataEventListener(Threading.USER_THREAD, listener);
    }

    public void addGetDataEventListener(Executor executor, GetDataEventListener listener) {
        this.peerGetDataEventListeners.add(new ListenerRegistration<GetDataEventListener>(Objects.requireNonNull(listener), executor));
        for (Peer peer : this.getConnectedPeers()) {
            peer.addGetDataEventListener(executor, listener);
        }
        for (Peer peer : this.getPendingPeers()) {
            peer.addGetDataEventListener(executor, listener);
        }
    }

    public void addOnTransactionBroadcastListener(OnTransactionBroadcastListener listener) {
        this.addOnTransactionBroadcastListener(Threading.USER_THREAD, listener);
    }

    public void addOnTransactionBroadcastListener(Executor executor, OnTransactionBroadcastListener listener) {
        this.peersTransactionBroadastEventListeners.add(new ListenerRegistration<OnTransactionBroadcastListener>(Objects.requireNonNull(listener), executor));
        for (Peer peer : this.getConnectedPeers()) {
            peer.addOnTransactionBroadcastListener(executor, listener);
        }
        for (Peer peer : this.getPendingPeers()) {
            peer.addOnTransactionBroadcastListener(executor, listener);
        }
    }

    public void addPreMessageReceivedEventListener(PreMessageReceivedEventListener listener) {
        this.addPreMessageReceivedEventListener(Threading.USER_THREAD, listener);
    }

    public void addPreMessageReceivedEventListener(Executor executor, PreMessageReceivedEventListener listener) {
        this.peersPreMessageReceivedEventListeners.add(new ListenerRegistration<PreMessageReceivedEventListener>(Objects.requireNonNull(listener), executor));
        for (Peer peer : this.getConnectedPeers()) {
            peer.addPreMessageReceivedEventListener(executor, listener);
        }
        for (Peer peer : this.getPendingPeers()) {
            peer.addPreMessageReceivedEventListener(executor, listener);
        }
    }

    public boolean removeBlocksDownloadedEventListener(BlocksDownloadedEventListener listener) {
        boolean result = ListenerRegistration.removeFromList(listener, this.peersBlocksDownloadedEventListeners);
        for (Peer peer : this.getConnectedPeers()) {
            peer.removeBlocksDownloadedEventListener(listener);
        }
        for (Peer peer : this.getPendingPeers()) {
            peer.removeBlocksDownloadedEventListener(listener);
        }
        return result;
    }

    public boolean removeChainDownloadStartedEventListener(ChainDownloadStartedEventListener listener) {
        boolean result = ListenerRegistration.removeFromList(listener, this.peersChainDownloadStartedEventListeners);
        for (Peer peer : this.getConnectedPeers()) {
            peer.removeChainDownloadStartedEventListener(listener);
        }
        for (Peer peer : this.getPendingPeers()) {
            peer.removeChainDownloadStartedEventListener(listener);
        }
        return result;
    }

    public boolean removeConnectedEventListener(PeerConnectedEventListener listener) {
        boolean result = ListenerRegistration.removeFromList(listener, this.peerConnectedEventListeners);
        for (Peer peer : this.getConnectedPeers()) {
            peer.removeConnectedEventListener(listener);
        }
        for (Peer peer : this.getPendingPeers()) {
            peer.removeConnectedEventListener(listener);
        }
        return result;
    }

    public boolean removeDisconnectedEventListener(PeerDisconnectedEventListener listener) {
        boolean result = ListenerRegistration.removeFromList(listener, this.peerDisconnectedEventListeners);
        for (Peer peer : this.getConnectedPeers()) {
            peer.removeDisconnectedEventListener(listener);
        }
        for (Peer peer : this.getPendingPeers()) {
            peer.removeDisconnectedEventListener(listener);
        }
        return result;
    }

    public boolean removeDiscoveredEventListener(PeerDiscoveredEventListener listener) {
        boolean result = ListenerRegistration.removeFromList(listener, this.peerDiscoveredEventListeners);
        return result;
    }

    public boolean removeGetDataEventListener(GetDataEventListener listener) {
        boolean result = ListenerRegistration.removeFromList(listener, this.peerGetDataEventListeners);
        for (Peer peer : this.getConnectedPeers()) {
            peer.removeGetDataEventListener(listener);
        }
        for (Peer peer : this.getPendingPeers()) {
            peer.removeGetDataEventListener(listener);
        }
        return result;
    }

    public boolean removeOnTransactionBroadcastListener(OnTransactionBroadcastListener listener) {
        boolean result = ListenerRegistration.removeFromList(listener, this.peersTransactionBroadastEventListeners);
        for (Peer peer : this.getConnectedPeers()) {
            peer.removeOnTransactionBroadcastListener(listener);
        }
        for (Peer peer : this.getPendingPeers()) {
            peer.removeOnTransactionBroadcastListener(listener);
        }
        return result;
    }

    public boolean removePreMessageReceivedEventListener(PreMessageReceivedEventListener listener) {
        boolean result = ListenerRegistration.removeFromList(listener, this.peersPreMessageReceivedEventListeners);
        for (Peer peer : this.getConnectedPeers()) {
            peer.removePreMessageReceivedEventListener(listener);
        }
        for (Peer peer : this.getPendingPeers()) {
            peer.removePreMessageReceivedEventListener(listener);
        }
        return result;
    }

    public List<Peer> getConnectedPeers() {
        this.lock.lock();
        try {
            ArrayList<Peer> arrayList = new ArrayList<Peer>(this.peers);
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<Peer> getPendingPeers() {
        this.lock.lock();
        try {
            ArrayList<Peer> arrayList = new ArrayList<Peer>(this.pendingPeers);
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addAddress(PeerAddress peerAddress) {
        this.addAddress(peerAddress, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAddress(PeerAddress peerAddress, int priority) {
        this.lock.lock();
        try {
            if (this.addInactive(peerAddress, priority)) {
                int newMax = this.getMaxConnections() + 1;
                this.setMaxConnections(newMax);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addInactive(PeerAddress peerAddress, int priority) {
        this.lock.lock();
        try {
            if (this.backoffMap.containsKey(peerAddress)) {
                boolean bl = false;
                return bl;
            }
            this.backoffMap.put(peerAddress, new ExponentialBackoff(this.peerBackoffParams));
            if (priority != 0) {
                this.priorityMap.put(peerAddress, priority);
            }
            this.inactives.offer(peerAddress);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private int getPriority(PeerAddress peerAddress) {
        Integer priority = this.priorityMap.get(peerAddress);
        return priority != null ? priority : 0;
    }

    public void setRequiredServices(long requiredServices) {
        this.lock.lock();
        try {
            this.requiredServices = requiredServices;
            this.peerDiscoverers.clear();
            this.addPeerDiscovery(MultiplexingDiscovery.forServices(this.params.network(), requiredServices));
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addAddress(InetAddress address) {
        this.addAddress(PeerAddress.simple(address, this.params.getPort()));
    }

    public void addAddress(InetAddress address, int priority) {
        this.addAddress(PeerAddress.simple(address, this.params.getPort()), priority);
    }

    public void setDiscoverPeersViaP2P(boolean discoverPeersViaP2P) {
        this.vDiscoverPeersViaP2P = discoverPeersViaP2P;
    }

    public void addPeerDiscovery(PeerDiscovery peerDiscovery) {
        this.lock.lock();
        try {
            if (this.getMaxConnections() == 0) {
                this.setMaxConnections(12);
            }
            this.peerDiscoverers.add(peerDiscovery);
        }
        finally {
            this.lock.unlock();
        }
        this.setDiscoverPeersViaP2P(true);
    }

    protected int discoverPeers() {
        Preconditions.checkState(!this.lock.isHeldByCurrentThread());
        int maxPeersToDiscoverCount = this.vMaxPeersToDiscoverCount;
        Duration peerDiscoveryTimeout = this.vPeerDiscoveryTimeout;
        Stopwatch watch = Stopwatch.start();
        LinkedList<PeerAddress> addressList = new LinkedList<PeerAddress>();
        for (PeerDiscovery peerDiscovery : this.peerDiscoverers) {
            List<InetSocketAddress> addresses;
            try {
                addresses = peerDiscovery.getPeers(this.requiredServices, peerDiscoveryTimeout);
            }
            catch (PeerDiscoveryException e) {
                log.warn(e.getMessage());
                continue;
            }
            for (InetSocketAddress address : addresses) {
                addressList.add(PeerAddress.simple(address));
            }
            if (addressList.size() < maxPeersToDiscoverCount) continue;
            break;
        }
        if (!addressList.isEmpty()) {
            for (PeerAddress address : addressList) {
                this.addInactive(address, 0);
            }
            Set peersDiscoveredSet = Collections.unmodifiableSet(new HashSet(addressList));
            for (ListenerRegistration<PeerDiscoveredEventListener> registration : this.peerDiscoveredEventListeners) {
                registration.executor.execute(() -> ((PeerDiscoveredEventListener)registration.listener).onPeersDiscovered(peersDiscoveredSet));
            }
        }
        log.info("Peer discovery took {} and returned {} items from {} discoverers", watch, addressList.size(), this.peerDiscoverers.size());
        return addressList.size();
    }

    void waitForJobQueue() {
        Futures.getUnchecked(this.executor.submit(Runnables.doNothing()));
    }

    private int countConnectedAndPendingPeers() {
        this.lock.lock();
        try {
            int n = this.peers.size() + this.pendingPeers.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean maybeCheckForLocalhostPeer() {
        Preconditions.checkState(this.lock.isHeldByCurrentThread());
        if (this.localhostCheckState == LocalhostCheckState.NOT_TRIED) {
            boolean bl;
            Socket socket = new Socket();
            try {
                socket.connect(new InetSocketAddress(InetAddress.getLoopbackAddress(), this.params.getPort()), Math.toIntExact(this.vConnectTimeout.toMillis()));
                this.localhostCheckState = LocalhostCheckState.FOUND;
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.info("Localhost peer not detected.");
                    this.localhostCheckState = LocalhostCheckState.NOT_THERE;
                }
            }
            socket.close();
            return bl;
        }
        return false;
    }

    public ListenableCompletableFuture<Void> startAsync() {
        if (this.chain == null) {
            log.warn("Starting up with no attached block chain. Did you forget to pass one to the constructor?");
        }
        Preconditions.checkState(!this.vUsedUp, () -> "cannot start a peer group twice");
        this.vRunning = true;
        this.vUsedUp = true;
        this.executorStartupLatch.countDown();
        CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
            try {
                log.info("Starting ...");
                this.channels.startAsync();
                this.channels.awaitRunning();
                this.triggerConnections();
                this.setupPinging();
            }
            catch (Throwable e) {
                log.error("Exception when starting up", e);
            }
        }, this.executor);
        return ListenableCompletableFuture.of(future);
    }

    public void start() {
        this.startAsync().join();
    }

    public ListenableCompletableFuture<Void> stopAsync() {
        Preconditions.checkState(this.vRunning);
        this.vRunning = false;
        CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
            try {
                log.info("Stopping ...");
                Stopwatch watch = Stopwatch.start();
                this.setDownloadPeer(null);
                this.channels.stopAsync();
                this.channels.awaitTerminated();
                for (PeerDiscovery peerDiscovery : this.peerDiscoverers) {
                    peerDiscovery.shutdown();
                }
                this.vRunning = false;
                log.info("Stopped, took {}.", (Object)watch);
            }
            catch (Throwable e) {
                log.error("Exception when shutting down", e);
            }
        }, this.executor);
        this.executor.shutdown();
        return ListenableCompletableFuture.of(future);
    }

    public void stop() {
        try {
            Stopwatch watch = Stopwatch.start();
            this.stopAsync();
            log.info("Awaiting PeerGroup shutdown ...");
            this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
            log.info("... took {}", (Object)watch);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void dropAllPeers() {
        this.lock.lock();
        try {
            for (Peer peer : this.peers) {
                peer.close();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWallet(Wallet wallet) {
        this.lock.lock();
        try {
            Objects.requireNonNull(wallet);
            Preconditions.checkState(!this.wallets.contains(wallet));
            this.wallets.add(wallet);
            wallet.setTransactionBroadcaster(this);
            wallet.addCoinsReceivedEventListener(Threading.SAME_THREAD, this.walletCoinsReceivedEventListener);
            wallet.addCoinsSentEventListener(Threading.SAME_THREAD, this.walletCoinsSentEventListener);
            wallet.addKeyChainEventListener(Threading.SAME_THREAD, this.walletKeyEventListener);
            wallet.addScriptsChangeEventListener(Threading.SAME_THREAD, this.walletScriptsEventListener);
            this.addPeerFilterProvider(wallet);
            for (Peer peer : this.peers) {
                peer.addWallet(wallet);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableCompletableFuture<BloomFilter> addPeerFilterProvider(PeerFilterProvider provider) {
        this.lock.lock();
        try {
            Objects.requireNonNull(provider);
            Preconditions.checkState(!this.peerFilterProviders.contains(provider));
            this.peerFilterProviders.add(0, provider);
            ListenableCompletableFuture<BloomFilter> future = this.recalculateFastCatchupAndFilter(FilterRecalculateMode.SEND_IF_CHANGED);
            this.updateVersionMessageRelayTxesBeforeFilter(this.getVersionMessage());
            ListenableCompletableFuture<BloomFilter> listenableCompletableFuture = future;
            return listenableCompletableFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removePeerFilterProvider(PeerFilterProvider provider) {
        this.lock.lock();
        try {
            Objects.requireNonNull(provider);
            Preconditions.checkArgument(this.peerFilterProviders.remove(provider));
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeWallet(Wallet wallet) {
        this.wallets.remove(Objects.requireNonNull(wallet));
        this.peerFilterProviders.remove(wallet);
        wallet.removeCoinsReceivedEventListener(this.walletCoinsReceivedEventListener);
        wallet.removeCoinsSentEventListener(this.walletCoinsSentEventListener);
        wallet.removeKeyChainEventListener(this.walletKeyEventListener);
        wallet.removeScriptsChangeEventListener(this.walletScriptsEventListener);
        wallet.setTransactionBroadcaster(null);
        for (Peer peer : this.peers) {
            peer.removeWallet(wallet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableCompletableFuture<BloomFilter> recalculateFastCatchupAndFilter(final FilterRecalculateMode mode) {
        final ListenableCompletableFuture<BloomFilter> future = new ListenableCompletableFuture<BloomFilter>();
        Map<FilterRecalculateMode, ListenableCompletableFuture<BloomFilter>> map = this.inFlightRecalculations;
        synchronized (map) {
            if (this.inFlightRecalculations.get((Object)mode) != null) {
                return this.inFlightRecalculations.get((Object)mode);
            }
            this.inFlightRecalculations.put(mode, future);
        }
        Runnable command = new Runnable(){

            @Override
            public void run() {
                try {
                    this.go();
                }
                catch (Throwable e) {
                    log.error("Exception when trying to recalculate Bloom filter", e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void go() {
                boolean send;
                Preconditions.checkState(!PeerGroup.this.lock.isHeldByCurrentThread());
                if (PeerGroup.this.chain != null && PeerGroup.this.chain.shouldVerifyTransactions() || !PeerGroup.this.vBloomFilteringEnabled) {
                    return;
                }
                FilterMerger.Result result = PeerGroup.this.bloomFilterMerger.calculate(Collections.unmodifiableList(PeerGroup.this.peerFilterProviders));
                switch (mode) {
                    case SEND_IF_CHANGED: {
                        send = result.changed;
                        break;
                    }
                    case DONT_SEND: {
                        send = false;
                        break;
                    }
                    case FORCE_SEND_FOR_REFRESH: {
                        send = true;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
                if (send) {
                    for (Peer peer : PeerGroup.this.peers) {
                        peer.setBloomFilter(result.filter, mode != FilterRecalculateMode.FORCE_SEND_FOR_REFRESH);
                    }
                    if (PeerGroup.this.chain != null) {
                        PeerGroup.this.chain.resetFalsePositiveEstimate();
                    }
                }
                PeerGroup.this.setFastCatchupTime(result.earliestKeyTime);
                Map map = PeerGroup.this.inFlightRecalculations;
                synchronized (map) {
                    PeerGroup.this.inFlightRecalculations.put(mode, null);
                }
                future.complete(result.filter);
            }
        };
        try {
            this.executor.execute(command);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        return future;
    }

    @Deprecated
    public void setBloomFilterFalsePositiveRate(double bloomFilterFPRate) {
        this.lock.lock();
        try {
            this.bloomFilterMerger.setBloomFilterFPRate(bloomFilterFPRate);
            this.recalculateFastCatchupAndFilter(FilterRecalculateMode.SEND_IF_CHANGED);
        }
        finally {
            this.lock.unlock();
        }
    }

    public int numConnectedPeers() {
        return this.peers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Peer connectTo(InetSocketAddress address) {
        this.lock.lock();
        try {
            PeerAddress peerAddress = PeerAddress.simple(address);
            this.backoffMap.put(peerAddress, new ExponentialBackoff(this.peerBackoffParams));
            Peer peer = this.connectTo(peerAddress, true, this.vConnectTimeout);
            return peer;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Nullable
    public Peer connectToLocalHost() {
        this.lock.lock();
        try {
            PeerAddress localhost = PeerAddress.localhost(this.params);
            this.backoffMap.put(localhost, new ExponentialBackoff(this.peerBackoffParams));
            Peer peer = this.connectTo(localhost, true, this.vConnectTimeout);
            return peer;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Nullable
    @GuardedBy(value="lock")
    protected Peer connectTo(PeerAddress address, boolean incrementMaxConnections, Duration connectTimeout) {
        Preconditions.checkState(this.lock.isHeldByCurrentThread());
        VersionMessage ver = this.getVersionMessage().duplicate();
        ver.bestHeight = this.chain == null ? 0L : (long)this.chain.getBestChainHeight();
        ver.time = TimeUtils.currentTime().truncatedTo(ChronoUnit.SECONDS);
        ver.receivingAddr = new InetSocketAddress(address.getAddr(), address.getPort());
        Peer peer = this.createPeer(address, ver);
        peer.addConnectedEventListener(Threading.SAME_THREAD, this.startupListener);
        peer.addDisconnectedEventListener(Threading.SAME_THREAD, this.startupListener);
        peer.setMinProtocolVersion(this.vMinRequiredProtocolVersion);
        this.pendingPeers.add(peer);
        try {
            log.info("Attempting connection to {}     ({} connected, {} pending, {} max)", address, this.peers.size(), this.pendingPeers.size(), this.maxConnections);
            ListenableCompletableFuture<SocketAddress> future = this.channels.openConnection(address.toSocketAddress(), peer);
            if (future.isDone()) {
                InternalUtils.getUninterruptibly(future);
            }
        }
        catch (ExecutionException e) {
            Throwable cause = Throwables.getRootCause((Throwable)e);
            log.warn("Failed to connect to " + address + ": " + cause.getMessage());
            this.handlePeerDeath(peer, cause);
            return null;
        }
        peer.setSocketTimeout(connectTimeout);
        if (incrementMaxConnections) {
            ++this.maxConnections;
        }
        return peer;
    }

    @GuardedBy(value="lock")
    protected Peer createPeer(PeerAddress address, VersionMessage ver) {
        return new Peer(this.params, ver, address, this.chain, this.requiredServices, this.downloadTxDependencyDepth);
    }

    public void setConnectTimeout(Duration connectTimeout) {
        this.vConnectTimeout = connectTimeout;
    }

    @Deprecated
    public void setConnectTimeoutMillis(int connectTimeoutMillis) {
        this.setConnectTimeout(Duration.ofMillis(connectTimeoutMillis));
    }

    public void startBlockChainDownload(BlockchainDownloadEventListener listener) {
        this.lock.lock();
        try {
            if (this.downloadPeer != null) {
                if (this.downloadListener != null) {
                    PeerGroup.removeDataEventListenerFromPeer(this.downloadPeer, this.downloadListener);
                }
                if (listener != null) {
                    PeerGroup.addDataEventListenerToPeer(Threading.USER_THREAD, this.downloadPeer, listener);
                }
            }
            this.downloadListener = listener;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static void addDataEventListenerToPeer(Executor executor, Peer peer, BlockchainDownloadEventListener downloadListener) {
        peer.addBlocksDownloadedEventListener(executor, downloadListener);
        peer.addChainDownloadStartedEventListener(executor, downloadListener);
    }

    private static void removeDataEventListenerFromPeer(Peer peer, BlockchainDownloadEventListener listener) {
        peer.removeBlocksDownloadedEventListener(listener);
        peer.removeChainDownloadStartedEventListener(listener);
    }

    public void downloadBlockChain() {
        DownloadProgressTracker listener = new DownloadProgressTracker();
        this.startBlockChainDownload(listener);
        try {
            listener.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleNewPeer(Peer peer) {
        int newSize = -1;
        this.lock.lock();
        try {
            this.groupBackoff.trackSuccess();
            this.backoffMap.get(peer.getAddress()).trackSuccess();
            this.pendingPeers.remove(peer);
            this.peers.add(peer);
            newSize = this.peers.size();
            log.info("{}: New peer      ({} connected, {} pending, {} max)", peer, newSize, this.pendingPeers.size(), this.maxConnections);
            if (this.bloomFilterMerger.getLastFilter() != null) {
                peer.setBloomFilter(this.bloomFilterMerger.getLastFilter());
            }
            peer.setDownloadData(false);
            for (Wallet wallet : this.wallets) {
                peer.addWallet(wallet);
            }
            if (this.downloadPeer == null && newSize > this.maxConnections / 2) {
                Peer newDownloadPeer = this.selectDownloadPeer(this.peers);
                if (newDownloadPeer != null) {
                    boolean bl;
                    this.setDownloadPeer(newDownloadPeer);
                    boolean bl2 = bl = this.downloadListener != null && this.chain != null;
                    if (bl) {
                        this.startBlockChainDownloadFromPeer(this.downloadPeer);
                    }
                } else {
                    log.info("Not yet setting download peer because there is no clear candidate.");
                }
            }
            peer.addBlocksDownloadedEventListener(Threading.SAME_THREAD, this.peerListener);
            peer.addGetDataEventListener(Threading.SAME_THREAD, this.peerListener);
            peer.addAddressEventListener(Threading.SAME_THREAD, this.peerListener);
            for (ListenerRegistration listenerRegistration : this.peersBlocksDownloadedEventListeners) {
                peer.addBlocksDownloadedEventListener(listenerRegistration.executor, (BlocksDownloadedEventListener)listenerRegistration.listener);
            }
            for (ListenerRegistration<ChainDownloadStartedEventListener> listenerRegistration : this.peersChainDownloadStartedEventListeners) {
                peer.addChainDownloadStartedEventListener(listenerRegistration.executor, (ChainDownloadStartedEventListener)listenerRegistration.listener);
            }
            for (ListenerRegistration<Object> listenerRegistration : this.peerConnectedEventListeners) {
                peer.addConnectedEventListener(listenerRegistration.executor, (PeerConnectedEventListener)listenerRegistration.listener);
            }
            for (ListenerRegistration<Object> listenerRegistration : this.peerGetDataEventListeners) {
                peer.addGetDataEventListener(listenerRegistration.executor, (GetDataEventListener)listenerRegistration.listener);
            }
            for (ListenerRegistration<Object> listenerRegistration : this.peersTransactionBroadastEventListeners) {
                peer.addOnTransactionBroadcastListener(listenerRegistration.executor, (OnTransactionBroadcastListener)listenerRegistration.listener);
            }
            for (ListenerRegistration<Object> listenerRegistration : this.peersPreMessageReceivedEventListeners) {
                peer.addPreMessageReceivedEventListener(listenerRegistration.executor, (PreMessageReceivedEventListener)listenerRegistration.listener);
            }
        }
        finally {
            this.lock.unlock();
        }
        int fNewSize = newSize;
        for (ListenerRegistration<PeerConnectedEventListener> registration : this.peerConnectedEventListeners) {
            registration.executor.execute(() -> ((PeerConnectedEventListener)registration.listener).onPeerConnected(peer, fNewSize));
        }
        if (this.vDiscoverPeersViaP2P) {
            peer.sendMessage(new GetAddrMessage());
        }
    }

    private void setupPinging() {
        if (this.getPingIntervalMsec() <= 0L) {
            return;
        }
        this.vPingTask = this.executor.scheduleAtFixedRate(() -> {
            try {
                if (this.getPingIntervalMsec() <= 0L) {
                    ScheduledFuture<?> task = this.vPingTask;
                    if (task != null) {
                        task.cancel(false);
                        this.vPingTask = null;
                    }
                    return;
                }
                for (Peer peer : this.getConnectedPeers()) {
                    peer.sendPing();
                }
            }
            catch (Throwable e) {
                log.error("Exception in ping loop", e);
            }
        }, this.getPingIntervalMsec(), this.getPingIntervalMsec(), TimeUnit.MILLISECONDS);
    }

    private void setDownloadPeer(@Nullable Peer peer) {
        this.lock.lock();
        try {
            if (this.downloadPeer == peer) {
                return;
            }
            if (this.downloadPeer != null) {
                log.info("Unsetting download peer: {}", (Object)this.downloadPeer);
                if (this.downloadListener != null) {
                    PeerGroup.removeDataEventListenerFromPeer(this.downloadPeer, this.downloadListener);
                }
                this.downloadPeer.setDownloadData(false);
            }
            this.downloadPeer = peer;
            if (this.downloadPeer != null) {
                log.info("Setting download peer: {}", (Object)this.downloadPeer);
                if (this.downloadListener != null) {
                    PeerGroup.addDataEventListenerToPeer(Threading.SAME_THREAD, peer, this.downloadListener);
                }
                this.downloadPeer.setDownloadData(true);
                if (this.chain != null) {
                    this.downloadPeer.setFastDownloadParameters(this.bloomFilterMerger.getLastFilter() != null, this.fastCatchupTime);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Deprecated
    @Nullable
    public TxConfidenceTable getMemoryPool() {
        return Context.get().getConfidenceTable();
    }

    public void setFastCatchupTime(Instant fastCatchupTime) {
        this.lock.lock();
        try {
            Preconditions.checkState(this.chain == null || !this.chain.shouldVerifyTransactions(), () -> "fast catchup is incompatible with fully verifying");
            this.fastCatchupTime = fastCatchupTime;
            if (this.downloadPeer != null) {
                this.downloadPeer.setFastDownloadParameters(this.bloomFilterMerger.getLastFilter() != null, fastCatchupTime);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Deprecated
    public void setFastCatchupTimeSecs(long fastCatchupTimeSecs) {
        this.setFastCatchupTime(Instant.ofEpochSecond(fastCatchupTimeSecs));
    }

    public Instant getFastCatchupTime() {
        this.lock.lock();
        try {
            Instant instant = this.fastCatchupTime;
            return instant;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Deprecated
    public long getFastCatchupTimeSecs() {
        return this.getFastCatchupTime().getEpochSecond();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handlePeerDeath(Peer peer, @Nullable Throwable exception) {
        if (!this.isRunning()) {
            return;
        }
        int numConnectedPeers = 0;
        this.lock.lock();
        try {
            this.pendingPeers.remove(peer);
            this.peers.remove(peer);
            PeerAddress address = peer.getAddress();
            log.info("{}: Peer died      ({} connected, {} pending, {} max)", address, this.peers.size(), this.pendingPeers.size(), this.maxConnections);
            if (peer == this.downloadPeer) {
                this.setDownloadPeer(null);
                Peer newDownloadPeer = this.selectDownloadPeer(this.peers);
                if (newDownloadPeer != null) {
                    this.setDownloadPeer(newDownloadPeer);
                    if (this.downloadListener != null) {
                        this.startBlockChainDownloadFromPeer(newDownloadPeer);
                    }
                }
            }
            int numPeers = this.peers.size() + this.pendingPeers.size();
            numConnectedPeers = this.peers.size();
            this.groupBackoff.trackFailure();
            if (exception instanceof NoRouteToHostException) {
                if (address.getAddr() instanceof Inet6Address && !this.ipv6Unreachable) {
                    this.ipv6Unreachable = true;
                    log.warn("IPv6 peer connect failed due to routing failure, ignoring IPv6 addresses from now on");
                }
            } else {
                this.backoffMap.get(address).trackFailure();
                this.inactives.offer(address);
            }
            if (numPeers < this.getMaxConnections()) {
                this.triggerConnections();
            }
        }
        finally {
            this.lock.unlock();
        }
        peer.removeAddressEventListener(this.peerListener);
        peer.removeBlocksDownloadedEventListener(this.peerListener);
        peer.removeGetDataEventListener(this.peerListener);
        for (Wallet wallet : this.wallets) {
            peer.removeWallet(wallet);
        }
        int fNumConnectedPeers = numConnectedPeers;
        for (ListenerRegistration<BlocksDownloadedEventListener> listenerRegistration : this.peersBlocksDownloadedEventListeners) {
            peer.removeBlocksDownloadedEventListener((BlocksDownloadedEventListener)listenerRegistration.listener);
        }
        for (ListenerRegistration<Object> listenerRegistration : this.peersChainDownloadStartedEventListeners) {
            peer.removeChainDownloadStartedEventListener((ChainDownloadStartedEventListener)listenerRegistration.listener);
        }
        for (ListenerRegistration<Object> listenerRegistration : this.peerGetDataEventListeners) {
            peer.removeGetDataEventListener((GetDataEventListener)listenerRegistration.listener);
        }
        for (ListenerRegistration<Object> listenerRegistration : this.peersPreMessageReceivedEventListeners) {
            peer.removePreMessageReceivedEventListener((PreMessageReceivedEventListener)listenerRegistration.listener);
        }
        for (ListenerRegistration<Object> listenerRegistration : this.peersTransactionBroadastEventListeners) {
            peer.removeOnTransactionBroadcastListener((OnTransactionBroadcastListener)listenerRegistration.listener);
        }
        for (ListenerRegistration<Object> listenerRegistration : this.peerDisconnectedEventListeners) {
            listenerRegistration.executor.execute(() -> ((PeerDisconnectedEventListener)registration.listener).onPeerDisconnected(peer, fNumConnectedPeers));
            peer.removeDisconnectedEventListener((PeerDisconnectedEventListener)listenerRegistration.listener);
        }
    }

    public void setStallThreshold(int periodSecs, int bytesPerSecond) {
        this.lock.lock();
        try {
            this.stallPeriodSeconds = periodSecs;
            this.stallMinSpeedBytesSec = bytesPerSecond;
        }
        finally {
            this.lock.unlock();
        }
    }

    void startBlockChainDownloadFromPeer(Peer peer) {
        this.lock.lock();
        try {
            this.setDownloadPeer(peer);
            if (this.chainDownloadSpeedCalculator == null) {
                this.chainDownloadSpeedCalculator = new ChainDownloadSpeedCalculator();
                this.executor.scheduleAtFixedRate(this.chainDownloadSpeedCalculator, 1L, 1L, TimeUnit.SECONDS);
            }
            peer.addBlocksDownloadedEventListener(Threading.SAME_THREAD, this.chainDownloadSpeedCalculator);
            peer.startBlockChainDownload();
        }
        finally {
            this.lock.unlock();
        }
    }

    public ListenableCompletableFuture<List<Peer>> waitForPeers(int numPeers) {
        return this.waitForPeersOfVersion(numPeers, 0L);
    }

    public ListenableCompletableFuture<List<Peer>> waitForPeersOfVersion(final int numPeers, final long protocolVersion) {
        List<Peer> foundPeers = this.findPeersOfAtLeastVersion(protocolVersion);
        if (foundPeers.size() >= numPeers) {
            ListenableCompletableFuture<List<Peer>> f = new ListenableCompletableFuture<List<Peer>>();
            f.complete(foundPeers);
            return f;
        }
        final ListenableCompletableFuture<List<Peer>> future = new ListenableCompletableFuture<List<Peer>>();
        this.addConnectedEventListener(new PeerConnectedEventListener(){

            @Override
            public void onPeerConnected(Peer peer, int peerCount) {
                List<Peer> peers = PeerGroup.this.findPeersOfAtLeastVersion(protocolVersion);
                if (peers.size() >= numPeers) {
                    future.complete(peers);
                    PeerGroup.this.removeConnectedEventListener(this);
                }
            }
        });
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Peer> findPeersOfAtLeastVersion(long protocolVersion) {
        this.lock.lock();
        try {
            ArrayList<Peer> results = new ArrayList<Peer>(this.peers.size());
            for (Peer peer : this.peers) {
                if ((long)peer.getPeerVersionMessage().clientVersion < protocolVersion) continue;
                results.add(peer);
            }
            ArrayList<Peer> arrayList = results;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableCompletableFuture<List<Peer>> waitForPeersWithServiceMask(final int numPeers, final int mask) {
        this.lock.lock();
        try {
            List<Peer> foundPeers = this.findPeersWithServiceMask(mask);
            if (foundPeers.size() >= numPeers) {
                ListenableCompletableFuture<List<Peer>> f = new ListenableCompletableFuture<List<Peer>>();
                f.complete(foundPeers);
                ListenableCompletableFuture<List<Peer>> listenableCompletableFuture = f;
                return listenableCompletableFuture;
            }
            final ListenableCompletableFuture<List<Peer>> future = new ListenableCompletableFuture<List<Peer>>();
            this.addConnectedEventListener(new PeerConnectedEventListener(){

                @Override
                public void onPeerConnected(Peer peer, int peerCount) {
                    List<Peer> peers = PeerGroup.this.findPeersWithServiceMask(mask);
                    if (peers.size() >= numPeers) {
                        future.complete(peers);
                        PeerGroup.this.removeConnectedEventListener(this);
                    }
                }
            });
            ListenableCompletableFuture<List<Peer>> listenableCompletableFuture = future;
            return listenableCompletableFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Peer> findPeersWithServiceMask(int mask) {
        this.lock.lock();
        try {
            ArrayList<Peer> results = new ArrayList<Peer>(this.peers.size());
            for (Peer peer : this.peers) {
                if (!peer.getPeerVersionMessage().localServices.has(mask)) continue;
                results.add(peer);
            }
            ArrayList<Peer> arrayList = results;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getMinBroadcastConnections() {
        this.lock.lock();
        try {
            if (this.minBroadcastConnections == 0) {
                int max = this.getMaxConnections();
                if (max <= 1) {
                    int n = max;
                    return n;
                }
                int n = (int)Math.round((double)this.getMaxConnections() * 0.8);
                return n;
            }
            int n = this.minBroadcastConnections;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setMinBroadcastConnections(int value) {
        this.lock.lock();
        try {
            this.minBroadcastConnections = value;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public TransactionBroadcast broadcastTransaction(Transaction tx) {
        return this.broadcastTransaction(tx, Math.max(1, this.getMinBroadcastConnections()), true);
    }

    public TransactionBroadcast broadcastTransaction(Transaction tx, int minConnections, boolean dropPeersAfterBroadcast) {
        if (tx.getConfidence().getSource().equals((Object)TransactionConfidence.Source.UNKNOWN)) {
            log.info("Transaction source unknown, setting to SELF: {}", (Object)tx.getTxId());
            tx.getConfidence().setSource(TransactionConfidence.Source.SELF);
        }
        TransactionBroadcast broadcast = new TransactionBroadcast(this, tx);
        broadcast.setMinConnections(minConnections);
        broadcast.setDropPeersAfterBroadcast(dropPeersAfterBroadcast && tx.getConfidence().numBroadcastPeers() == 0);
        broadcast.awaitRelayed().whenComplete((bcast, throwable) -> {
            if (bcast != null) {
                this.runningBroadcasts.remove(bcast);
                for (Wallet wallet : this.wallets) {
                    try {
                        wallet.receivePending(bcast.transaction(), null);
                    }
                    catch (VerificationException e) {
                        throw new RuntimeException(e);
                    }
                }
            } else {
                this.runningBroadcasts.remove(bcast);
            }
        });
        this.runningBroadcasts.add(broadcast);
        broadcast.broadcastOnly();
        return broadcast;
    }

    public long getPingIntervalMsec() {
        this.lock.lock();
        try {
            long l = this.pingIntervalMsec;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPingIntervalMsec(long pingIntervalMsec) {
        this.lock.lock();
        try {
            this.pingIntervalMsec = pingIntervalMsec;
            ScheduledFuture<?> task = this.vPingTask;
            if (task != null) {
                task.cancel(false);
            }
            this.setupPinging();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setMinRequiredProtocolVersion(int minRequiredProtocolVersion) {
        this.vMinRequiredProtocolVersion = minRequiredProtocolVersion;
    }

    public int getMinRequiredProtocolVersion() {
        return this.vMinRequiredProtocolVersion;
    }

    public int getMostCommonChainHeight() {
        this.lock.lock();
        try {
            int n = PeerGroup.getMostCommonChainHeight(this.peers);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public static int getMostCommonChainHeight(List<Peer> peers) {
        if (peers.isEmpty()) {
            return 0;
        }
        ArrayList<Integer> heights = new ArrayList<Integer>(peers.size());
        for (Peer peer : peers) {
            heights.add((int)peer.getBestHeight());
        }
        return PeerGroup.maxOfMostFreq(heights);
    }

    static int maxOfMostFreq(List<Integer> items) {
        if (items.isEmpty()) {
            return 0;
        }
        items = Ordering.natural().reverse().sortedCopy(items);
        LinkedList<Pair> pairs = new LinkedList<Pair>();
        pairs.add(new Pair((Integer)items.get(0)));
        Iterator iterator2 = items.iterator();
        while (iterator2.hasNext()) {
            int item = (Integer)iterator2.next();
            Pair pair = (Pair)pairs.getLast();
            if (pair.item != item) {
                pair = new Pair(item);
                pairs.add(pair);
            }
            ++pair.count;
        }
        Collections.sort(pairs);
        Pair firstPair = (Pair)pairs.get(0);
        if (pairs.size() == 1) {
            return firstPair.item;
        }
        Pair secondPair = (Pair)pairs.get(1);
        if (firstPair.count > secondPair.count) {
            return firstPair.item;
        }
        Preconditions.checkState(firstPair.count == secondPair.count);
        return 0;
    }

    @Nullable
    protected Peer selectDownloadPeer(List<Peer> peers) {
        if (peers.isEmpty()) {
            return null;
        }
        int mostCommonChainHeight = PeerGroup.getMostCommonChainHeight(peers);
        if (mostCommonChainHeight == 0) {
            return null;
        }
        LinkedList<Peer> candidates = new LinkedList<Peer>();
        int highestPriority = Integer.MIN_VALUE;
        int MINIMUM_VERSION = ProtocolVersion.WITNESS_VERSION.intValue();
        for (Peer peer : peers) {
            long peerHeight;
            VersionMessage versionMessage = peer.getPeerVersionMessage();
            if (versionMessage.clientVersion < MINIMUM_VERSION || !versionMessage.services().has(1L) || !versionMessage.services().has(8L) || (peerHeight = peer.getBestHeight()) < (long)mostCommonChainHeight || peerHeight > (long)(mostCommonChainHeight + 1)) continue;
            candidates.add(peer);
            highestPriority = Math.max(highestPriority, this.getPriority(peer.peerAddress));
        }
        if (candidates.isEmpty()) {
            return null;
        }
        Iterator i2 = candidates.iterator();
        while (i2.hasNext()) {
            Peer peer;
            peer = (Peer)i2.next();
            if (this.getPriority(peer.peerAddress) >= highestPriority) continue;
            i2.remove();
        }
        int index = (int)(Math.random() * (double)candidates.size());
        return (Peer)candidates.get(index);
    }

    public Peer getDownloadPeer() {
        this.lock.lock();
        try {
            Peer peer = this.downloadPeer;
            return peer;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getMaxPeersToDiscoverCount() {
        return this.vMaxPeersToDiscoverCount;
    }

    public void setMaxPeersToDiscoverCount(int maxPeersToDiscoverCount) {
        this.vMaxPeersToDiscoverCount = maxPeersToDiscoverCount;
    }

    public boolean getUseLocalhostPeerWhenPossible() {
        this.lock.lock();
        try {
            boolean bl = this.useLocalhostPeerWhenPossible;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setUseLocalhostPeerWhenPossible(boolean useLocalhostPeerWhenPossible) {
        this.lock.lock();
        try {
            this.useLocalhostPeerWhenPossible = useLocalhostPeerWhenPossible;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isRunning() {
        return this.vRunning;
    }

    public void setBloomFilteringEnabled(boolean bloomFilteringEnabled) {
        this.vBloomFilteringEnabled = bloomFilteringEnabled;
    }

    public boolean isBloomFilteringEnabled() {
        return this.vBloomFilteringEnabled;
    }

    public static enum FilterRecalculateMode {
        SEND_IF_CHANGED,
        FORCE_SEND_FOR_REFRESH,
        DONT_SEND;

    }

    private class PeerListener
    implements GetDataEventListener,
    BlocksDownloadedEventListener,
    AddressEventListener {
        @Override
        public List<Message> getData(Peer peer, GetDataMessage m) {
            return PeerGroup.this.handleGetData(m);
        }

        @Override
        public void onBlocksDownloaded(Peer peer, Block block, @Nullable FilteredBlock filteredBlock, int blocksLeft) {
            double target;
            if (PeerGroup.this.chain == null) {
                return;
            }
            double rate = PeerGroup.this.chain.getFalsePositiveRate();
            if (rate > (target = PeerGroup.this.bloomFilterMerger.getBloomFilterFPRate() * 10.0)) {
                log.info("Force update Bloom filter due to high false positive rate ({} vs {})", (Object)rate, (Object)target);
                PeerGroup.this.recalculateFastCatchupAndFilter(FilterRecalculateMode.FORCE_SEND_FOR_REFRESH);
            }
        }

        @Override
        public void onAddr(Peer peer, AddressMessage message) {
            if (!PeerGroup.this.vDiscoverPeersViaP2P) {
                return;
            }
            LinkedList<PeerAddress> addresses = new LinkedList<PeerAddress>(message.getAddresses());
            Collections.shuffle(addresses);
            int numAdded = 0;
            for (PeerAddress address : addresses) {
                if (!address.getServices().has(PeerGroup.this.requiredServices)) continue;
                boolean added = PeerGroup.this.addInactive(address, 1);
                if (added) {
                    ++numAdded;
                }
                if (numAdded < 16) continue;
                break;
            }
            log.info("{} gossiped {} addresses, added {} of them to the inactive pool", peer.getAddress(), addresses.size(), numAdded);
        }
    }

    private class PeerStartupListener
    implements PeerConnectedEventListener,
    PeerDisconnectedEventListener {
        private PeerStartupListener() {
        }

        @Override
        public void onPeerConnected(Peer peer, int peerCount) {
            PeerGroup.this.handleNewPeer(peer);
        }

        @Override
        public void onPeerDisconnected(Peer peer, int peerCount) {
            PeerGroup.this.handlePeerDeath(peer, null);
        }
    }

    private static enum LocalhostCheckState {
        NOT_TRIED,
        FOUND,
        FOUND_AND_CONNECTED,
        NOT_THERE;

    }

    private class ChainDownloadSpeedCalculator
    implements BlocksDownloadedEventListener,
    Runnable {
        private int blocksInLastSecond;
        private int txnsInLastSecond;
        private int origTxnsInLastSecond;
        private long bytesInLastSecond;
        private int maxStalls = 3;
        private int warmupSeconds = -1;
        private long[] samples;
        private int cursor;
        private boolean syncDone;
        private final Logger log = LoggerFactory.getLogger(ChainDownloadSpeedCalculator.class);

        private ChainDownloadSpeedCalculator() {
        }

        @Override
        public synchronized void onBlocksDownloaded(Peer peer, Block block, @Nullable FilteredBlock filteredBlock, int blocksLeft) {
            ++this.blocksInLastSecond;
            this.bytesInLastSecond += 80L;
            List<Transaction> blockTransactions = block.getTransactions();
            int txCount = (blockTransactions != null ? this.countAndMeasureSize(blockTransactions) : 0) + (filteredBlock != null ? this.countAndMeasureSize(filteredBlock.getAssociatedTransactions().values()) : 0);
            this.txnsInLastSecond += txCount;
            if (filteredBlock != null) {
                this.origTxnsInLastSecond += filteredBlock.getTransactionCount();
            }
        }

        private int countAndMeasureSize(Collection<Transaction> transactions) {
            for (Transaction transaction : transactions) {
                this.bytesInLastSecond += (long)transaction.messageSize();
            }
            return transactions.size();
        }

        @Override
        public void run() {
            try {
                this.calculate();
            }
            catch (Throwable e) {
                this.log.error("Error in speed calculator", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void calculate() {
            int period;
            int minSpeedBytesPerSec;
            PeerGroup.this.lock.lock();
            try {
                minSpeedBytesPerSec = PeerGroup.this.stallMinSpeedBytesSec;
                period = PeerGroup.this.stallPeriodSeconds;
            }
            finally {
                PeerGroup.this.lock.unlock();
            }
            ChainDownloadSpeedCalculator chainDownloadSpeedCalculator = this;
            synchronized (chainDownloadSpeedCalculator) {
                if (this.samples == null || this.samples.length != period) {
                    this.samples = new long[period];
                    Arrays.fill(this.samples, (long)(minSpeedBytesPerSec * 2));
                    this.warmupSeconds = 15;
                }
                int chainHeight = PeerGroup.this.chain != null ? PeerGroup.this.chain.getBestChainHeight() : -1;
                int mostCommonChainHeight = PeerGroup.this.getMostCommonChainHeight();
                if (!this.syncDone && mostCommonChainHeight > 0 && chainHeight >= mostCommonChainHeight) {
                    this.log.info("End of sync detected at height {}.", (Object)chainHeight);
                    this.syncDone = true;
                }
                if (!this.syncDone) {
                    this.samples[this.cursor++] = this.bytesInLastSecond;
                    if (this.cursor == this.samples.length) {
                        this.cursor = 0;
                    }
                    long sampleSum = 0L;
                    for (long sample : this.samples) {
                        sampleSum += sample;
                    }
                    float average = (float)sampleSum / (float)this.samples.length;
                    String statsString = String.format(Locale.US, "%d blocks/sec, %d tx/sec, %d pre-filtered tx/sec, avg/last %.2f/%.2f kilobytes per sec, chain/common height %d/%d", this.blocksInLastSecond, this.txnsInLastSecond, this.origTxnsInLastSecond, (double)average / 1024.0, (double)this.bytesInLastSecond / 1024.0, chainHeight, mostCommonChainHeight);
                    String thresholdString = String.format(Locale.US, "(threshold <%.2f KB/sec for %d seconds)", (double)minSpeedBytesPerSec / 1024.0, this.samples.length);
                    if (this.maxStalls <= 0) {
                        this.log.info(statsString + ", stall disabled " + thresholdString);
                    } else if (this.warmupSeconds > 0) {
                        --this.warmupSeconds;
                        if (this.bytesInLastSecond > 0L) {
                            this.log.info(statsString + String.format(Locale.US, " (warming up %d more seconds)", this.warmupSeconds));
                        }
                    } else if (average < (float)minSpeedBytesPerSec) {
                        this.log.info(statsString + ", STALLED " + thresholdString);
                        --this.maxStalls;
                        if (this.maxStalls == 0) {
                            this.log.warn("This network seems to be slower than the requested stall threshold - won't do stall disconnects any more.");
                        } else {
                            Peer peer = PeerGroup.this.getDownloadPeer();
                            this.log.warn(String.format(Locale.US, "Chain download stalled: received %.2f KB/sec for %d seconds, require average of %.2f KB/sec, disconnecting %s, %d stalls left", (double)average / 1024.0, this.samples.length, (double)minSpeedBytesPerSec / 1024.0, peer, this.maxStalls));
                            peer.close();
                            this.samples = null;
                            this.warmupSeconds = period;
                        }
                    } else {
                        this.log.info(statsString + ", not stalled " + thresholdString);
                    }
                }
                this.blocksInLastSecond = 0;
                this.txnsInLastSecond = 0;
                this.origTxnsInLastSecond = 0;
                this.bytesInLastSecond = 0L;
            }
        }
    }

    private static class Pair
    implements Comparable<Pair> {
        final int item;
        int count = 0;

        public Pair(int item) {
            this.item = item;
        }

        @Override
        public int compareTo(Pair o) {
            return -Integer.compare(this.count, o.count);
        }
    }
}

