/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.nio.Buffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.NotYetConnectedException;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import org.bitcoinj.base.internal.Preconditions;
import org.bitcoinj.core.BitcoinSerializer;
import org.bitcoinj.core.Message;
import org.bitcoinj.core.MessageSerializer;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.PeerAddress;
import org.bitcoinj.core.ProtocolException;
import org.bitcoinj.net.MessageWriteTarget;
import org.bitcoinj.net.SocketTimeoutTask;
import org.bitcoinj.net.StreamConnection;
import org.bitcoinj.net.TimeoutHandler;
import org.bitcoinj.utils.ListenableCompletableFuture;
import org.bitcoinj.utils.Threading;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PeerSocketHandler
implements TimeoutHandler,
StreamConnection {
    private static final Logger log = LoggerFactory.getLogger(PeerSocketHandler.class);
    private final Lock lock = Threading.lock(PeerSocketHandler.class);
    private final SocketTimeoutTask timeoutTask;
    private final MessageSerializer serializer;
    protected final PeerAddress peerAddress;
    private boolean closePending = false;
    @VisibleForTesting
    protected MessageWriteTarget writeTarget = null;
    private byte[] largeReadBuffer;
    private int largeReadBufferPos;
    private BitcoinSerializer.BitcoinPacketHeader header;

    public PeerSocketHandler(NetworkParameters params, InetSocketAddress remoteIp) {
        this(params, PeerAddress.simple(remoteIp));
    }

    public PeerSocketHandler(NetworkParameters params, PeerAddress peerAddress) {
        Objects.requireNonNull(params);
        this.serializer = params.getDefaultSerializer();
        this.peerAddress = Objects.requireNonNull(peerAddress);
        this.timeoutTask = new SocketTimeoutTask(this::timeoutOccurred);
    }

    @Override
    public void setTimeoutEnabled(boolean timeoutEnabled) {
        this.timeoutTask.setTimeoutEnabled(timeoutEnabled);
    }

    @Override
    public void setSocketTimeout(Duration timeout2) {
        this.timeoutTask.setSocketTimeout(timeout2);
    }

    public ListenableCompletableFuture<Void> sendMessage(Message message) throws NotYetConnectedException {
        this.lock.lock();
        try {
            if (this.writeTarget == null) {
                throw new NotYetConnectedException();
            }
        }
        finally {
            this.lock.unlock();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.serializer.serialize(message, out);
            return this.writeTarget.writeBytes(out.toByteArray());
        }
        catch (IOException e) {
            this.exceptionCaught(e);
            return ListenableCompletableFuture.failedFuture(e);
        }
    }

    public void close() {
        this.lock.lock();
        try {
            if (this.writeTarget == null) {
                this.closePending = true;
                return;
            }
        }
        finally {
            this.lock.unlock();
        }
        this.writeTarget.closeConnection();
    }

    protected void timeoutOccurred() {
        log.info("{}: Timed out", (Object)this.getAddress());
        this.close();
    }

    protected abstract void processMessage(Message var1) throws Exception;

    @Override
    public int receiveBytes(ByteBuffer buff) {
        Preconditions.checkArgument(buff.position() == 0 && buff.capacity() >= 24);
        try {
            boolean firstMessage = true;
            while (true) {
                Message message;
                if (this.largeReadBuffer != null) {
                    Preconditions.checkState(firstMessage);
                    int bytesToGet = Math.min(buff.remaining(), this.largeReadBuffer.length - this.largeReadBufferPos);
                    buff.get(this.largeReadBuffer, this.largeReadBufferPos, bytesToGet);
                    this.largeReadBufferPos += bytesToGet;
                    if (this.largeReadBufferPos == this.largeReadBuffer.length) {
                        this.processMessage(this.serializer.deserializePayload(this.header, ByteBuffer.wrap(this.largeReadBuffer)));
                        this.largeReadBuffer = null;
                        this.header = null;
                        firstMessage = false;
                    } else {
                        return buff.position();
                    }
                }
                int preSerializePosition = buff.position();
                try {
                    message = this.serializer.deserialize(buff);
                }
                catch (BufferUnderflowException e) {
                    if (firstMessage && buff.limit() == buff.capacity()) {
                        ((Buffer)buff).position(0);
                        try {
                            this.serializer.seekPastMagicBytes(buff);
                            this.header = this.serializer.deserializeHeader(buff);
                            this.largeReadBuffer = new byte[this.header.size];
                            this.largeReadBufferPos = buff.remaining();
                            buff.get(this.largeReadBuffer, 0, this.largeReadBufferPos);
                        }
                        catch (BufferUnderflowException e1) {
                            throw new ProtocolException("No magic bytes+header after reading " + buff.capacity() + " bytes");
                        }
                    } else {
                        ((Buffer)buff).position(preSerializePosition);
                    }
                    return buff.position();
                }
                this.processMessage(message);
                firstMessage = false;
            }
        }
        catch (Exception e) {
            this.exceptionCaught(e);
            return -1;
        }
    }

    @Override
    public void setWriteTarget(MessageWriteTarget writeTarget) {
        Preconditions.checkArgument(writeTarget != null);
        this.lock.lock();
        boolean closeNow = false;
        try {
            Preconditions.checkArgument(this.writeTarget == null);
            closeNow = this.closePending;
            this.writeTarget = writeTarget;
        }
        finally {
            this.lock.unlock();
        }
        if (closeNow) {
            writeTarget.closeConnection();
        }
    }

    @Override
    public int getMaxMessageSize() {
        return 0x2000000;
    }

    public PeerAddress getAddress() {
        return this.peerAddress;
    }

    private void exceptionCaught(Exception e) {
        String s;
        PeerAddress addr = this.getAddress();
        String string = s = addr == null ? "?" : addr.toString();
        if (e instanceof ConnectException || e instanceof IOException) {
            log.info(s + " - " + e.getMessage());
        } else {
            log.warn(s + " - ", e);
            Thread.UncaughtExceptionHandler handler = Threading.uncaughtExceptionHandler;
            if (handler != null) {
                handler.uncaughtException(Thread.currentThread(), e);
            }
        }
        this.close();
    }
}

