/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Random;
import org.bitcoinj.base.internal.ByteUtils;
import org.bitcoinj.core.BaseMessage;
import org.bitcoinj.core.Pong;
import org.bitcoinj.core.ProtocolException;

public class Ping
extends BaseMessage {
    private final long nonce;

    public static Ping read(ByteBuffer payload) throws BufferUnderflowException, ProtocolException {
        return new Ping(ByteUtils.readInt64(payload));
    }

    public static Ping of(long nonce) {
        return new Ping(nonce);
    }

    public static Ping random() {
        long nonce = new Random().nextLong();
        return new Ping(nonce);
    }

    private Ping(long nonce) {
        this.nonce = nonce;
    }

    @Override
    public void bitcoinSerializeToStream(OutputStream stream) throws IOException {
        ByteUtils.writeInt64LE(this.nonce, stream);
    }

    @Deprecated
    public boolean hasNonce() {
        return true;
    }

    public long nonce() {
        return this.nonce;
    }

    public Pong pong() {
        return Pong.of(this.nonce);
    }
}

