/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.bitcoinj.base.internal.ByteUtils;
import org.bitcoinj.core.BaseMessage;
import org.bitcoinj.core.ProtocolException;

public class Pong
extends BaseMessage {
    private final long nonce;

    public static Pong read(ByteBuffer payload) throws BufferUnderflowException, ProtocolException {
        return new Pong(ByteUtils.readInt64(payload));
    }

    public static Pong of(long nonce) {
        return new Pong(nonce);
    }

    private Pong(long nonce) {
        this.nonce = nonce;
    }

    @Override
    public void bitcoinSerializeToStream(OutputStream stream) throws IOException {
        ByteUtils.writeInt64LE(this.nonce, stream);
    }

    public long nonce() {
        return this.nonce;
    }
}

