/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.bitcoinj.base.Sha256Hash;
import org.bitcoinj.base.VarInt;
import org.bitcoinj.base.internal.Buffers;
import org.bitcoinj.core.BaseMessage;
import org.bitcoinj.core.ProtocolException;

public class RejectMessage
extends BaseMessage {
    private final String rejectedMessage;
    private final RejectCode code;
    private final String reason;
    @Nullable
    private final Sha256Hash rejectedMessageHash;

    public static RejectMessage read(ByteBuffer payload) throws BufferUnderflowException, ProtocolException {
        String message = Buffers.readLengthPrefixedString(payload);
        RejectCode code = RejectCode.fromCode(payload.get());
        String reason = Buffers.readLengthPrefixedString(payload);
        Sha256Hash messageHash = message.equals("block") || message.equals("tx") ? Sha256Hash.read(payload) : null;
        return new RejectMessage(code, messageHash, message, reason);
    }

    public RejectMessage(RejectCode code, @Nullable Sha256Hash rejectedMessageHash, String rejectedMessage, String reason) {
        this.rejectedMessage = Objects.requireNonNull(rejectedMessage);
        this.code = Objects.requireNonNull(code);
        this.reason = Objects.requireNonNull(reason);
        this.rejectedMessageHash = rejectedMessageHash;
    }

    @Override
    public void bitcoinSerializeToStream(OutputStream stream) throws IOException {
        byte[] messageBytes = this.rejectedMessage.getBytes(StandardCharsets.UTF_8);
        stream.write(VarInt.of(messageBytes.length).serialize());
        stream.write(messageBytes);
        stream.write(this.code.code);
        byte[] reasonBytes = this.reason.getBytes(StandardCharsets.UTF_8);
        stream.write(VarInt.of(reasonBytes.length).serialize());
        stream.write(reasonBytes);
        if ("block".equals(this.rejectedMessage) || "tx".equals(this.rejectedMessage)) {
            stream.write(this.rejectedMessageHash.serialize());
        }
    }

    public String rejectedMessage() {
        return this.rejectedMessage;
    }

    @Deprecated
    public String getRejectedMessage() {
        return this.rejectedMessage();
    }

    public Sha256Hash rejectedMessageHash() {
        return this.rejectedMessageHash;
    }

    @Deprecated
    public Sha256Hash getRejectedObjectHash() {
        return this.rejectedMessageHash();
    }

    public RejectCode code() {
        return this.code;
    }

    @Deprecated
    public RejectCode getReasonCode() {
        return this.code();
    }

    public String reason() {
        return this.reason;
    }

    @Deprecated
    public String getReasonString() {
        return this.reason();
    }

    public String toString() {
        return String.format(Locale.US, "Reject: %s %s for reason '%s' (%d)", this.rejectedMessage, this.rejectedMessageHash != null ? this.rejectedMessageHash : "", this.reason, this.code.code);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RejectMessage other = (RejectMessage)o;
        return this.rejectedMessage.equals(other.rejectedMessage) && this.code.equals((Object)other.code) && this.reason.equals(other.reason) && this.rejectedMessageHash.equals(other.rejectedMessageHash);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.rejectedMessage, this.code, this.reason, this.rejectedMessageHash});
    }

    public static enum RejectCode {
        MALFORMED(1),
        INVALID(16),
        OBSOLETE(17),
        DUPLICATE(18),
        NONSTANDARD(64),
        DUST(65),
        INSUFFICIENTFEE(66),
        CHECKPOINT(67),
        OTHER(-1);

        final byte code;

        private RejectCode(byte code) {
            this.code = code;
        }

        static RejectCode fromCode(byte code) {
            return Stream.of(RejectCode.values()).filter(r -> r.code == code).findFirst().orElse(OTHER);
        }
    }
}

