/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.LinkedList;
import java.util.Objects;
import org.bitcoinj.base.internal.InternalUtils;

public class Services {
    public static final int NODE_NETWORK = 1;
    public static final int NODE_BLOOM = 4;
    public static final int NODE_WITNESS = 8;
    public static final int NODE_COMPACT_FILTERS = 64;
    public static final int NODE_NETWORK_LIMITED = 1024;
    public static final int NODE_P2P_V2 = 2048;
    public static final int NODE_BITCOIN_CASH = 32;
    public static final int BYTES = 8;
    private final long bits;

    public static Services of(long bits) {
        return new Services(bits);
    }

    public static Services none() {
        return new Services(0L);
    }

    public static Services read(ByteBuffer buf) throws BufferUnderflowException {
        return new Services(buf.order(ByteOrder.LITTLE_ENDIAN).getLong());
    }

    private Services(long bits) {
        this.bits = bits;
    }

    public long bits() {
        return this.bits;
    }

    public boolean hasAny() {
        return this.bits != 0L;
    }

    public boolean has(long bitmask) {
        return (this.bits & bitmask) == bitmask;
    }

    public boolean anyOf(long bitmask) {
        return (this.bits & bitmask) != 0L;
    }

    public ByteBuffer write(ByteBuffer buf) throws BufferOverflowException {
        buf.order(ByteOrder.LITTLE_ENDIAN).putLong(this.bits);
        return buf;
    }

    public byte[] serialize() {
        return this.write(ByteBuffer.allocate(8)).array();
    }

    public String toString() {
        long bits = this.bits;
        LinkedList<String> strings = new LinkedList<String>();
        if ((bits & 1L) == 1L) {
            strings.add("NETWORK");
            bits &= 0xFFFFFFFFFFFFFFFEL;
        }
        if ((bits & 4L) == 4L) {
            strings.add("BLOOM");
            bits &= 0xFFFFFFFFFFFFFFFBL;
        }
        if ((bits & 8L) == 8L) {
            strings.add("WITNESS");
            bits &= 0xFFFFFFFFFFFFFFF7L;
        }
        if ((bits & 0x40L) == 64L) {
            strings.add("COMPACT_FILTERS");
            bits &= 0xFFFFFFFFFFFFFFBFL;
        }
        if ((bits & 0x400L) == 1024L) {
            strings.add("NETWORK_LIMITED");
            bits &= 0xFFFFFFFFFFFFFBFFL;
        }
        if ((bits & 0x800L) == 2048L) {
            strings.add("P2P_V2");
            bits &= 0xFFFFFFFFFFFFF7FFL;
        }
        if (bits != 0L) {
            strings.add("remaining: " + Long.toBinaryString(bits));
        }
        return InternalUtils.joiner(", ").join(strings);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.bits == ((Services)o).bits;
    }

    public int hashCode() {
        return Objects.hash(this.bits);
    }
}

