/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import com.google.common.annotations.VisibleForTesting;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.bitcoinj.base.internal.FutureUtils;
import org.bitcoinj.base.internal.InternalUtils;
import org.bitcoinj.base.internal.Preconditions;
import org.bitcoinj.base.internal.StreamUtils;
import org.bitcoinj.core.Context;
import org.bitcoinj.core.Message;
import org.bitcoinj.core.Peer;
import org.bitcoinj.core.PeerGroup;
import org.bitcoinj.core.RejectMessage;
import org.bitcoinj.core.RejectedTransactionException;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionConfidence;
import org.bitcoinj.core.listeners.PreMessageReceivedEventListener;
import org.bitcoinj.utils.ListenableCompletableFuture;
import org.bitcoinj.utils.Threading;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionBroadcast {
    private static final Logger log = LoggerFactory.getLogger(TransactionBroadcast.class);
    private final CompletableFuture<TransactionBroadcast> sentFuture = new CompletableFuture();
    private final CompletableFuture<TransactionBroadcast> seenFuture = new CompletableFuture();
    private final PeerGroup peerGroup;
    private final Transaction tx;
    private int minConnections;
    private boolean dropPeersAfterBroadcast = false;
    private int numWaitingFor;
    @VisibleForTesting
    public static Random random = new Random();
    private final Map<Peer, RejectMessage> rejects = Collections.synchronizedMap(new HashMap());
    private final PreMessageReceivedEventListener rejectionListener = new PreMessageReceivedEventListener(){

        @Override
        public Message onPreMessageReceived(Peer peer, Message m) {
            if (m instanceof RejectMessage) {
                RejectMessage rejectMessage = (RejectMessage)m;
                if (TransactionBroadcast.this.tx.getTxId().equals(rejectMessage.getRejectedObjectHash())) {
                    TransactionBroadcast.this.rejects.put(peer, rejectMessage);
                    int size = TransactionBroadcast.this.rejects.size();
                    long threshold = Math.round((double)TransactionBroadcast.this.numWaitingFor / 2.0);
                    if ((long)size > threshold) {
                        log.warn("Threshold for considering broadcast rejected has been reached ({}/{})", (Object)size, (Object)threshold);
                        TransactionBroadcast.this.seenFuture.completeExceptionally(new RejectedTransactionException(TransactionBroadcast.this.tx, rejectMessage));
                        TransactionBroadcast.this.peerGroup.removePreMessageReceivedEventListener(this);
                    }
                }
            }
            return m;
        }
    };
    private int numSeemPeers;
    private boolean mined;
    @Nullable
    private ProgressCallback callback;
    @Nullable
    private Executor progressCallbackExecutor;

    TransactionBroadcast(PeerGroup peerGroup, Transaction tx) {
        this.peerGroup = peerGroup;
        this.tx = tx;
        this.minConnections = Math.max(1, peerGroup.getMinBroadcastConnections());
    }

    private TransactionBroadcast(Transaction tx) {
        this.peerGroup = null;
        this.tx = tx;
    }

    public Transaction transaction() {
        return this.tx;
    }

    @VisibleForTesting
    public static TransactionBroadcast createMockBroadcast(Transaction tx, final CompletableFuture<Transaction> future) {
        return new TransactionBroadcast(tx){

            @Override
            public ListenableCompletableFuture<Transaction> broadcast() {
                return ListenableCompletableFuture.of(future);
            }

            @Override
            public ListenableCompletableFuture<Transaction> future() {
                return ListenableCompletableFuture.of(future);
            }
        };
    }

    @Deprecated
    public ListenableCompletableFuture<Transaction> future() {
        return ListenableCompletableFuture.of(this.awaitRelayed().thenApply(TransactionBroadcast::transaction));
    }

    public void setMinConnections(int minConnections) {
        this.minConnections = minConnections;
    }

    public void setDropPeersAfterBroadcast(boolean dropPeersAfterBroadcast) {
        this.dropPeersAfterBroadcast = dropPeersAfterBroadcast;
    }

    public CompletableFuture<TransactionBroadcast> broadcastOnly() {
        this.peerGroup.addPreMessageReceivedEventListener(Threading.SAME_THREAD, this.rejectionListener);
        log.info("Waiting for {} peers required for broadcast, we have {} ...", (Object)this.minConnections, (Object)this.peerGroup.getConnectedPeers().size());
        Context context = Context.get();
        return ((CompletableFuture)((CompletableFuture)this.peerGroup.waitForPeers(this.minConnections).thenComposeAsync(peerList -> {
            Context.propagate(context);
            List<Peer> peers = this.peerGroup.getConnectedPeers();
            this.tx.getConfidence().addEventListener(new ConfidenceChange());
            List<Peer> broadcastPeers = this.chooseBroadcastPeers(peers);
            int numToBroadcastTo = broadcastPeers.size();
            this.numWaitingFor = (int)Math.ceil((double)(peers.size() - numToBroadcastTo) / 2.0);
            log.info("broadcastTransaction: We have {} peers, adding {} to the memory pool", (Object)peers.size(), (Object)this.tx.getTxId());
            log.info("Sending to {} peers, will wait for {}, sending to: {}", numToBroadcastTo, this.numWaitingFor, InternalUtils.joiner(",").join(peers));
            List<CompletableFuture> sentFutures = broadcastPeers.stream().map(this::broadcastOne).collect(StreamUtils.toUnmodifiableList());
            return CompletableFuture.allOf(sentFutures.toArray(new CompletableFuture[0]));
        }, Threading.SAME_THREAD)).whenComplete((v, err) -> {
            if (err == null) {
                log.info("broadcast has been written to correct number of peers with peer.sendMessage(tx)");
                this.sentFuture.complete(this);
            } else {
                log.error("broadcast - one ore more peers failed to send", (Throwable)err);
                this.sentFuture.completeExceptionally((Throwable)err);
            }
        })).thenCompose(v -> this.sentFuture);
    }

    public CompletableFuture<TransactionBroadcast> broadcastAndAwaitRelay() {
        return this.broadcastOnly().thenCompose(broadcast -> this.seenFuture);
    }

    public CompletableFuture<TransactionBroadcast> awaitRelayed() {
        return this.seenFuture;
    }

    public CompletableFuture<TransactionBroadcast> awaitSent() {
        return this.sentFuture;
    }

    @Deprecated
    public ListenableCompletableFuture<Transaction> broadcast() {
        return ListenableCompletableFuture.of(this.broadcastAndAwaitRelay().thenApply(TransactionBroadcast::transaction));
    }

    private CompletableFuture<Void> broadcastOne(Peer peer) {
        try {
            ListenableCompletableFuture<Void> future = peer.sendMessage(this.tx);
            if (this.dropPeersAfterBroadcast) {
                future.thenRunAsync(TransactionBroadcast.dropPeerAfterBroadcastHandler(peer), Threading.THREAD_POOL);
            }
            return future;
        }
        catch (Exception e) {
            log.error("Caught exception sending to {}", (Object)peer, (Object)e);
            return FutureUtils.failedFuture(e);
        }
    }

    private static Runnable dropPeerAfterBroadcastHandler(Peer peer) {
        return () -> {
            try {
                Thread.sleep(Duration.ofSeconds(1L).toMillis());
            }
            catch (InterruptedException e) {
                log.warn("Sleep before drop-peer-after-broadcast interrupted. Peer will be closed now.");
            }
            peer.close();
        };
    }

    private List<Peer> chooseBroadcastPeers(List<Peer> connectedPeers) {
        int numToBroadcastTo = (int)Math.max(1L, Math.round(Math.ceil((double)connectedPeers.size() / 2.0)));
        ArrayList<Peer> peerListCopy = new ArrayList<Peer>(connectedPeers);
        Collections.shuffle(peerListCopy, random);
        return peerListCopy.subList(0, numToBroadcastTo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeAndRecord(int numSeenPeers, boolean mined) {
        TransactionBroadcast transactionBroadcast = this;
        synchronized (transactionBroadcast) {
            this.numSeemPeers = numSeenPeers;
            this.mined = mined;
        }
        this.invokeProgressCallback(numSeenPeers, mined);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeProgressCallback(int numSeenPeers, boolean mined) {
        Executor executor;
        ProgressCallback callback;
        TransactionBroadcast transactionBroadcast = this;
        synchronized (transactionBroadcast) {
            callback = this.callback;
            executor = this.progressCallbackExecutor;
        }
        if (callback != null) {
            double progress = Math.min(1.0, mined ? 1.0 : (double)numSeenPeers / (double)this.numWaitingFor);
            Preconditions.checkState(progress >= 0.0 && progress <= 1.0, () -> "" + progress);
            try {
                if (executor == null) {
                    callback.onBroadcastProgress(progress);
                } else {
                    executor.execute(() -> callback.onBroadcastProgress(progress));
                }
            }
            catch (Throwable e) {
                log.error("Exception during progress callback", e);
            }
        }
    }

    public void setProgressCallback(ProgressCallback callback) {
        this.setProgressCallback(callback, Threading.USER_THREAD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProgressCallback(ProgressCallback callback, @Nullable Executor executor) {
        boolean shouldInvoke;
        boolean mined;
        int num;
        TransactionBroadcast transactionBroadcast = this;
        synchronized (transactionBroadcast) {
            this.callback = callback;
            this.progressCallbackExecutor = executor;
            num = this.numSeemPeers;
            mined = this.mined;
            shouldInvoke = this.numWaitingFor > 0;
        }
        if (shouldInvoke) {
            this.invokeProgressCallback(num, mined);
        }
    }

    public static interface ProgressCallback {
        public void onBroadcastProgress(double var1);
    }

    private class ConfidenceChange
    implements TransactionConfidence.Listener {
        private ConfidenceChange() {
        }

        @Override
        public void onConfidenceChanged(TransactionConfidence conf, TransactionConfidence.Listener.ChangeReason reason) {
            int numSeenPeers = conf.numBroadcastPeers() + TransactionBroadcast.this.rejects.size();
            boolean mined = TransactionBroadcast.this.tx.getAppearsInHashes() != null;
            log.info("broadcastTransaction: {}:  TX {} seen by {} peers{}", new Object[]{reason, TransactionBroadcast.this.tx.getTxId(), numSeenPeers, mined ? " and mined" : ""});
            TransactionBroadcast.this.invokeAndRecord(numSeenPeers, mined);
            if (numSeenPeers >= TransactionBroadcast.this.numWaitingFor || mined) {
                log.info("broadcastTransaction: {} complete", (Object)TransactionBroadcast.this.tx.getTxId());
                TransactionBroadcast.this.peerGroup.removePreMessageReceivedEventListener(TransactionBroadcast.this.rejectionListener);
                conf.removeEventListener(this);
                TransactionBroadcast.this.seenFuture.complete(TransactionBroadcast.this);
            }
        }
    }
}

