/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.bitcoinj.base.Sha256Hash;
import org.bitcoinj.base.internal.Preconditions;
import org.bitcoinj.base.internal.TimeUtils;
import org.bitcoinj.core.PeerAddress;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.utils.ListenableCompletableFuture;
import org.bitcoinj.utils.ListenerRegistration;
import org.bitcoinj.utils.Threading;

public class TransactionConfidence {
    private final CopyOnWriteArrayList<PeerAddress> broadcastBy;
    @Nullable
    private Instant lastBroadcastTime = null;
    private final Sha256Hash hash;
    private final CopyOnWriteArrayList<ListenerRegistration<Listener>> listeners;
    private int depth;
    private ConfidenceType confidenceType = ConfidenceType.UNKNOWN;
    private int appearedAtChainHeight = -1;
    private Sha256Hash overridingTxId;
    private Source source = Source.UNKNOWN;
    private static final Set<TransactionConfidence> pinnedConfidenceObjects = Collections.synchronizedSet(new HashSet());

    public TransactionConfidence(Sha256Hash hash) {
        this.broadcastBy = new CopyOnWriteArrayList();
        this.listeners = new CopyOnWriteArrayList();
        this.hash = hash;
    }

    public void addEventListener(Executor executor, Listener listener) {
        Objects.requireNonNull(listener);
        this.listeners.addIfAbsent(new ListenerRegistration<Listener>(listener, executor));
        pinnedConfidenceObjects.add(this);
    }

    public void addEventListener(Listener listener) {
        this.addEventListener(Threading.USER_THREAD, listener);
    }

    public boolean removeEventListener(Listener listener) {
        Objects.requireNonNull(listener);
        boolean removed = ListenerRegistration.removeFromList(listener, this.listeners);
        if (this.listeners.isEmpty()) {
            pinnedConfidenceObjects.remove(this);
        }
        return removed;
    }

    public synchronized int getAppearedAtChainHeight() {
        if (this.getConfidenceType() != ConfidenceType.BUILDING) {
            throw new IllegalStateException("Confidence type is " + (Object)((Object)this.getConfidenceType()) + ", not BUILDING");
        }
        return this.appearedAtChainHeight;
    }

    public synchronized void setAppearedAtChainHeight(int appearedAtChainHeight) {
        if (appearedAtChainHeight < 0) {
            throw new IllegalArgumentException("appearedAtChainHeight out of range");
        }
        this.appearedAtChainHeight = appearedAtChainHeight;
        this.depth = 1;
        this.setConfidenceType(ConfidenceType.BUILDING);
    }

    public synchronized ConfidenceType getConfidenceType() {
        return this.confidenceType;
    }

    public synchronized void setConfidenceType(ConfidenceType confidenceType) {
        if (confidenceType == this.confidenceType) {
            return;
        }
        this.confidenceType = confidenceType;
        if (confidenceType != ConfidenceType.DEAD) {
            this.overridingTxId = null;
        }
        if (confidenceType == ConfidenceType.PENDING || confidenceType == ConfidenceType.IN_CONFLICT) {
            this.depth = 0;
            this.appearedAtChainHeight = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean markBroadcastBy(PeerAddress address) {
        this.lastBroadcastTime = TimeUtils.currentTime();
        if (!this.broadcastBy.addIfAbsent(address)) {
            return false;
        }
        TransactionConfidence transactionConfidence = this;
        synchronized (transactionConfidence) {
            if (this.getConfidenceType() == ConfidenceType.UNKNOWN) {
                this.confidenceType = ConfidenceType.PENDING;
            }
        }
        return true;
    }

    public int numBroadcastPeers() {
        return this.broadcastBy.size();
    }

    public Set<PeerAddress> getBroadcastBy() {
        HashSet<PeerAddress> broadcastBySet = new HashSet<PeerAddress>();
        Iterators.addAll(broadcastBySet, this.broadcastBy.listIterator());
        return broadcastBySet;
    }

    public boolean wasBroadcastBy(PeerAddress address) {
        return this.broadcastBy.contains(address);
    }

    public Optional<Instant> getLastBroadcastTime() {
        return Optional.ofNullable(this.lastBroadcastTime);
    }

    @Deprecated
    @Nullable
    public Date getLastBroadcastedAt() {
        return this.lastBroadcastTime != null ? Date.from(this.lastBroadcastTime) : null;
    }

    public void setLastBroadcastTime(Instant lastBroadcastTime) {
        this.lastBroadcastTime = Objects.requireNonNull(lastBroadcastTime);
    }

    @Deprecated
    public void setLastBroadcastedAt(Date lastBroadcastedAt) {
        this.setLastBroadcastTime(lastBroadcastedAt.toInstant());
    }

    public synchronized String toString() {
        StringBuilder builder = new StringBuilder();
        int peers = this.numBroadcastPeers();
        if (peers > 0) {
            builder.append("Seen by ").append(peers).append(peers > 1 ? " peers" : " peer");
            if (this.lastBroadcastTime != null) {
                builder.append(" (most recently: ").append(TimeUtils.dateTimeFormat(this.lastBroadcastTime)).append(")");
            }
            builder.append(". ");
        }
        switch (this.getConfidenceType()) {
            case UNKNOWN: {
                builder.append("Unknown confidence level.");
                break;
            }
            case DEAD: {
                builder.append("Dead: overridden by double spend and will not confirm.");
                break;
            }
            case PENDING: {
                builder.append("Pending/unconfirmed.");
                break;
            }
            case IN_CONFLICT: {
                builder.append("In conflict.");
                break;
            }
            case BUILDING: {
                builder.append(String.format(Locale.US, "Appeared in best chain at height %d, depth %d.", this.getAppearedAtChainHeight(), this.getDepthInBlocks()));
            }
        }
        if (this.source != Source.UNKNOWN) {
            builder.append(" Source: ").append((Object)this.source);
        }
        return builder.toString();
    }

    public synchronized int incrementDepthInBlocks() {
        return ++this.depth;
    }

    public synchronized int getDepthInBlocks() {
        return this.depth;
    }

    public synchronized void setDepthInBlocks(int depth) {
        this.depth = depth;
    }

    public void clearBroadcastBy() {
        Preconditions.checkState(this.getConfidenceType() != ConfidenceType.PENDING);
        this.broadcastBy.clear();
        this.lastBroadcastTime = null;
    }

    @Nullable
    public synchronized Sha256Hash getOverridingTxId() {
        if (this.getConfidenceType() != ConfidenceType.DEAD) {
            throw new IllegalStateException("Confidence type is " + (Object)((Object)this.getConfidenceType()) + ", not DEAD");
        }
        return this.overridingTxId;
    }

    @Deprecated
    public synchronized void setOverridingTransaction(Transaction overridingTransaction) {
        Objects.requireNonNull(overridingTransaction);
        this.overridingTxId = overridingTransaction.getTxId();
        this.setConfidenceType(ConfidenceType.DEAD);
    }

    public synchronized void setOverridingTxId(@Nullable Sha256Hash overridingTxId) {
        this.overridingTxId = overridingTxId;
        this.setConfidenceType(ConfidenceType.DEAD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionConfidence duplicate() {
        TransactionConfidence c = new TransactionConfidence(this.hash);
        c.broadcastBy.addAll(this.broadcastBy);
        c.lastBroadcastTime = this.lastBroadcastTime;
        TransactionConfidence transactionConfidence = this;
        synchronized (transactionConfidence) {
            c.confidenceType = this.confidenceType;
            c.overridingTxId = this.overridingTxId;
            c.appearedAtChainHeight = this.appearedAtChainHeight;
        }
        return c;
    }

    public void queueListeners(Listener.ChangeReason reason) {
        for (ListenerRegistration<Listener> registration : this.listeners) {
            registration.executor.execute(() -> ((Listener)registration.listener).onConfidenceChanged(this, reason));
        }
    }

    public synchronized Source getSource() {
        return this.source;
    }

    public synchronized void setSource(Source source2) {
        Preconditions.checkState(this.source == Source.UNKNOWN || source2 == this.source, () -> "source cannot be set again: from " + (Object)((Object)this.source) + " to " + (Object)((Object)source2));
        this.source = source2;
    }

    @VisibleForTesting
    public synchronized void maybeSetSourceToNetwork() {
        if (this.source == Source.UNKNOWN) {
            this.source = Source.NETWORK;
        }
    }

    private synchronized ListenableCompletableFuture<TransactionConfidence> getDepthFuture(final int depth, Executor executor) {
        final ListenableCompletableFuture<TransactionConfidence> result = new ListenableCompletableFuture<TransactionConfidence>();
        if (this.getDepthInBlocks() >= depth) {
            result.complete(this);
        }
        this.addEventListener(executor, new Listener(){

            @Override
            public void onConfidenceChanged(TransactionConfidence confidence, Listener.ChangeReason reason) {
                if (TransactionConfidence.this.getDepthInBlocks() >= depth) {
                    TransactionConfidence.this.removeEventListener(this);
                    result.complete(confidence);
                }
            }
        });
        return result;
    }

    public synchronized ListenableCompletableFuture<TransactionConfidence> getDepthFuture(int depth) {
        return this.getDepthFuture(depth, Threading.USER_THREAD);
    }

    public Sha256Hash getTransactionHash() {
        return this.hash;
    }

    public static enum ConfidenceType {
        BUILDING(1),
        PENDING(2),
        DEAD(4),
        IN_CONFLICT(5),
        UNKNOWN(0);

        private final int value;

        private ConfidenceType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum Source {
        UNKNOWN,
        NETWORK,
        SELF;

    }

    public static interface Listener {
        public void onConfidenceChanged(TransactionConfidence var1, ChangeReason var2);

        public static enum ChangeReason {
            TYPE,
            DEPTH,
            SEEN_PEERS;

        }
    }

    static interface Factory {
        public TransactionConfidence createConfidence(Sha256Hash var1);
    }
}

