/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import java.lang.ref.WeakReference;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.bitcoinj.base.Coin;
import org.bitcoinj.base.Sha256Hash;
import org.bitcoinj.base.VarInt;
import org.bitcoinj.base.internal.Buffers;
import org.bitcoinj.base.internal.ByteUtils;
import org.bitcoinj.base.internal.InternalUtils;
import org.bitcoinj.base.internal.Preconditions;
import org.bitcoinj.core.ProtocolException;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionOutPoint;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.core.TransactionWitness;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.script.Script;
import org.bitcoinj.script.ScriptException;
import org.bitcoinj.wallet.DefaultRiskAnalysis;
import org.bitcoinj.wallet.KeyBag;
import org.bitcoinj.wallet.RedeemData;

public class TransactionInput {
    public static final long NO_SEQUENCE = 0xFFFFFFFFL;
    public static final long SEQUENCE_LOCKTIME_DISABLE_FLAG = 0x80000000L;
    public static final long SEQUENCE_LOCKTIME_TYPE_FLAG = 0x400000L;
    public static final long SEQUENCE_LOCKTIME_MASK = 65535L;
    private static final byte[] EMPTY_ARRAY = new byte[0];
    private static final long UNCONNECTED = 0xFFFFFFFFL;
    @Nullable
    private Transaction parent;
    private final long sequence;
    private TransactionOutPoint outpoint;
    private final byte[] scriptBytes;
    private WeakReference<Script> scriptSig;
    @Nullable
    private Coin value;
    private final TransactionWitness witness;

    public static TransactionInput coinbaseInput(Transaction parentTransaction, byte[] scriptBytes) {
        Objects.requireNonNull(parentTransaction);
        Preconditions.checkArgument(scriptBytes.length >= 2 && scriptBytes.length <= 100, () -> "script must be between 2 and 100 bytes: " + scriptBytes.length);
        return new TransactionInput(parentTransaction, scriptBytes, TransactionOutPoint.UNCONNECTED);
    }

    public static TransactionInput read(ByteBuffer payload, Transaction parentTransaction) throws BufferUnderflowException, ProtocolException {
        Objects.requireNonNull(parentTransaction);
        TransactionOutPoint outpoint = TransactionOutPoint.read(payload);
        byte[] scriptBytes = Buffers.readLengthPrefixedBytes(payload);
        long sequence2 = ByteUtils.readUint32(payload);
        return new TransactionInput(parentTransaction, scriptBytes, outpoint, sequence2, null);
    }

    public TransactionInput(@Nullable Transaction parentTransaction, byte[] scriptBytes, TransactionOutPoint outpoint) {
        this(parentTransaction, scriptBytes, outpoint, 0xFFFFFFFFL, null);
    }

    public TransactionInput(@Nullable Transaction parentTransaction, byte[] scriptBytes, TransactionOutPoint outpoint, long sequence2) {
        this(parentTransaction, scriptBytes, outpoint, sequence2, null);
    }

    public TransactionInput(@Nullable Transaction parentTransaction, byte[] scriptBytes, TransactionOutPoint outpoint, @Nullable Coin value) {
        this(parentTransaction, scriptBytes, outpoint, 0xFFFFFFFFL, value);
    }

    private TransactionInput(@Nullable Transaction parentTransaction, byte[] scriptBytes, TransactionOutPoint outpoint, long sequence2, @Nullable Coin value) {
        this(parentTransaction, null, scriptBytes, outpoint, sequence2, value, null);
    }

    public TransactionInput(@Nullable Transaction parentTransaction, byte[] scriptBytes, TransactionOutPoint outpoint, long sequence2, @Nullable Coin value, @Nullable TransactionWitness witness) {
        this(parentTransaction, null, scriptBytes, outpoint, sequence2, value, witness);
    }

    private TransactionInput(@Nullable Transaction parentTransaction, @Nullable Script scriptSig, byte[] scriptBytes, TransactionOutPoint outpoint, long sequence2, @Nullable Coin value, @Nullable TransactionWitness witness) {
        Preconditions.checkArgument(value == null || value.signum() >= 0, () -> "value out of range: " + value);
        this.parent = parentTransaction;
        this.scriptSig = scriptSig != null ? new WeakReference<Script>(scriptSig) : null;
        this.scriptBytes = Objects.requireNonNull(scriptBytes);
        this.outpoint = Objects.requireNonNull(outpoint);
        this.sequence = sequence2;
        this.value = value;
        this.witness = witness;
    }

    TransactionInput(Transaction parentTransaction, TransactionOutput output) {
        this(parentTransaction, null, EMPTY_ARRAY, output.getParentTransaction() != null ? new TransactionOutPoint((long)output.getIndex(), output.getParentTransaction()) : new TransactionOutPoint(output), 0xFFFFFFFFL, output.getValue(), null);
    }

    public int getIndex() {
        int myIndex = this.getParentTransaction().getInputs().indexOf(this);
        if (myIndex < 0) {
            throw new IllegalStateException("Input linked to wrong parent transaction?");
        }
        return myIndex;
    }

    public ByteBuffer write(ByteBuffer buf) throws BufferOverflowException {
        this.outpoint.write(buf);
        Buffers.writeLengthPrefixedBytes(buf, this.scriptBytes);
        ByteUtils.writeInt32LE(this.sequence, buf);
        return buf;
    }

    public byte[] serialize() {
        return this.write(ByteBuffer.allocate(this.messageSize())).array();
    }

    @Deprecated
    public byte[] bitcoinSerialize() {
        return this.serialize();
    }

    public int messageSize() {
        int size = 36;
        size += VarInt.sizeOf(this.scriptBytes.length) + this.scriptBytes.length;
        return size += 4;
    }

    @Deprecated
    public int getMessageSize() {
        return this.messageSize();
    }

    public boolean isCoinBase() {
        return this.outpoint.hash().equals(Sha256Hash.ZERO_HASH) && (this.outpoint.index() & 0xFFFFFFFFL) == 0xFFFFFFFFL;
    }

    public Script getScriptSig() throws ScriptException {
        Script script;
        Script script2 = script = this.scriptSig == null ? null : (Script)this.scriptSig.get();
        if (script == null) {
            script = Script.parse(this.scriptBytes);
            this.scriptSig = new WeakReference<Script>(script);
        }
        return script;
    }

    public TransactionInput withScriptSig(Script scriptSig) {
        Objects.requireNonNull(scriptSig);
        return new TransactionInput(this.parent, scriptSig, scriptSig.program(), this.outpoint, this.sequence, this.value, this.witness);
    }

    public long getSequenceNumber() {
        return this.sequence;
    }

    public TransactionInput withSequence(long sequence2) {
        Preconditions.checkArgument(sequence2 >= 0L && sequence2 <= ByteUtils.MAX_UNSIGNED_INTEGER, () -> "sequence out of range: " + sequence2);
        Script scriptSig = this.scriptSig != null ? (Script)this.scriptSig.get() : null;
        return new TransactionInput(this.parent, scriptSig, this.scriptBytes, this.outpoint, sequence2, this.value, this.witness);
    }

    public TransactionOutPoint getOutpoint() {
        return this.outpoint;
    }

    public byte[] getScriptBytes() {
        return Arrays.copyOf(this.scriptBytes, this.scriptBytes.length);
    }

    public TransactionInput withoutScriptBytes() {
        return new TransactionInput(this.parent, null, EMPTY_ARRAY, this.outpoint, this.sequence, this.value, this.witness);
    }

    public TransactionInput withScriptBytes(byte[] scriptBytes) {
        Objects.requireNonNull(scriptBytes);
        return new TransactionInput(this.parent, null, scriptBytes, this.outpoint, this.sequence, this.value, this.witness);
    }

    public Transaction getParentTransaction() {
        return this.parent;
    }

    @Nullable
    public Coin getValue() {
        return this.value;
    }

    public TransactionWitness getWitness() {
        return this.witness != null ? this.witness : TransactionWitness.EMPTY;
    }

    public TransactionInput withWitness(TransactionWitness witness) {
        Objects.requireNonNull(witness);
        Script scriptSig = this.scriptSig != null ? (Script)this.scriptSig.get() : null;
        return new TransactionInput(this.parent, scriptSig, this.scriptBytes, this.outpoint, this.sequence, this.value, witness);
    }

    public TransactionInput withoutWitness() {
        Script scriptSig = this.scriptSig != null ? (Script)this.scriptSig.get() : null;
        return new TransactionInput(this.parent, scriptSig, this.scriptBytes, this.outpoint, this.sequence, this.value, null);
    }

    public boolean hasWitness() {
        return this.witness != null && this.witness.getPushCount() != 0;
    }

    @Nullable
    TransactionOutput getConnectedOutput(Map<Sha256Hash, Transaction> transactions) {
        Transaction tx = transactions.get(this.outpoint.hash());
        if (tx == null) {
            return null;
        }
        return tx.getOutput(this.outpoint);
    }

    @Nullable
    public RedeemData getConnectedRedeemData(KeyBag keyBag) throws ScriptException {
        return this.getOutpoint().getConnectedRedeemData(keyBag);
    }

    public ConnectionResult connect(Map<Sha256Hash, Transaction> transactions, ConnectMode mode) {
        Transaction tx = transactions.get(this.outpoint.hash());
        if (tx == null) {
            return ConnectionResult.NO_SUCH_TX;
        }
        return this.connect(tx, mode);
    }

    public ConnectionResult connect(Transaction transaction, ConnectMode mode) {
        if (!transaction.getTxId().equals(this.outpoint.hash())) {
            return ConnectionResult.NO_SUCH_TX;
        }
        TransactionOutput out = transaction.getOutput(this.outpoint);
        if (!out.isAvailableForSpending()) {
            if (this.getParentTransaction().equals(this.outpoint.fromTx)) {
                return ConnectionResult.SUCCESS;
            }
            if (mode == ConnectMode.DISCONNECT_ON_CONFLICT) {
                out.markAsUnspent();
            } else if (mode == ConnectMode.ABORT_ON_CONFLICT) {
                this.outpoint = this.outpoint.connectTransaction(out.getParentTransaction());
                return ConnectionResult.ALREADY_SPENT;
            }
        }
        this.connect(out);
        return ConnectionResult.SUCCESS;
    }

    public void connect(TransactionOutput out) {
        this.outpoint = this.outpoint.connectTransaction(out.getParentTransaction());
        out.markAsSpent(this);
        this.value = out.getValue();
    }

    public boolean disconnect() {
        TransactionOutput connectedOutput;
        if (this.outpoint.fromTx != null) {
            connectedOutput = this.outpoint.fromTx.getOutput(this.outpoint);
            this.outpoint = this.outpoint.disconnectTransaction();
        } else if (this.outpoint.connectedOutput != null) {
            connectedOutput = this.outpoint.connectedOutput;
            this.outpoint = this.outpoint.disconnectOutput();
        } else {
            return false;
        }
        if (connectedOutput != null && connectedOutput.getSpentBy() == this) {
            connectedOutput.markAsUnspent();
            return true;
        }
        return false;
    }

    public boolean hasSequence() {
        return this.sequence != 0xFFFFFFFFL;
    }

    public boolean isOptInFullRBF() {
        return this.sequence < 0xFFFFFFFEL;
    }

    public boolean hasRelativeLockTime() {
        return (this.sequence & 0x80000000L) == 0L;
    }

    public void verify() throws VerificationException {
        Transaction fromTx = this.getOutpoint().fromTx;
        Objects.requireNonNull(fromTx, "Not connected");
        TransactionOutput output = fromTx.getOutput(this.outpoint);
        this.verify(output);
    }

    public void verify(TransactionOutput output) throws VerificationException {
        if (output.parent != null) {
            if (!this.getOutpoint().hash().equals(output.getParentTransaction().getTxId())) {
                throw new VerificationException("This input does not refer to the tx containing the output.");
            }
            if (this.getOutpoint().index() != (long)output.getIndex()) {
                throw new VerificationException("This input refers to a different output on the given tx.");
            }
        }
        Script pubKey = output.getScriptPubKey();
        this.getScriptSig().correctlySpends(this.getParentTransaction(), this.getIndex(), this.getWitness(), this.getValue(), pubKey, Script.ALL_VERIFY_FLAGS);
    }

    @Nullable
    public TransactionOutput getConnectedOutput() {
        return this.getOutpoint().getConnectedOutput();
    }

    @Nullable
    public Transaction getConnectedTransaction() {
        return this.getOutpoint().fromTx;
    }

    public DefaultRiskAnalysis.RuleViolation isStandard() {
        return DefaultRiskAnalysis.isInputStandard(this);
    }

    protected final void setParent(@Nullable Transaction parent) {
        this.parent = parent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionInput other = (TransactionInput)o;
        return this.sequence == other.sequence && this.parent != null && this.parent.equals(other.parent) && this.outpoint.equals(other.outpoint) && Arrays.equals(this.scriptBytes, other.scriptBytes);
    }

    public int hashCode() {
        return Objects.hash(this.sequence, this.outpoint, Arrays.hashCode(this.scriptBytes));
    }

    public String toString() {
        StringBuilder s = new StringBuilder("TxIn");
        if (this.isCoinBase()) {
            s.append(": COINBASE");
        } else {
            s.append(" for [").append(this.outpoint).append("]: ");
            try {
                s.append(this.getScriptSig());
                String flags = InternalUtils.commaJoin(this.hasWitness() ? "witness" : null, this.hasSequence() ? "sequence: " + Long.toHexString(this.sequence) : null, this.isOptInFullRBF() ? "opts into full RBF" : null);
                if (!flags.isEmpty()) {
                    s.append(" (").append(flags).append(')');
                }
            }
            catch (ScriptException e) {
                s.append(" [exception: ").append(e.getMessage()).append("]");
            }
        }
        return s.toString();
    }

    public static enum ConnectionResult {
        NO_SUCH_TX,
        ALREADY_SPENT,
        SUCCESS;

    }

    public static enum ConnectMode {
        DISCONNECT_ON_CONFLICT,
        ABORT_ON_CONFLICT;

    }
}

