/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Objects;
import javax.annotation.Nullable;
import org.bitcoinj.base.ScriptType;
import org.bitcoinj.base.Sha256Hash;
import org.bitcoinj.base.internal.ByteUtils;
import org.bitcoinj.base.internal.Preconditions;
import org.bitcoinj.core.ProtocolException;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.crypto.ECKey;
import org.bitcoinj.script.Script;
import org.bitcoinj.script.ScriptError;
import org.bitcoinj.script.ScriptException;
import org.bitcoinj.script.ScriptPattern;
import org.bitcoinj.wallet.KeyBag;
import org.bitcoinj.wallet.RedeemData;

public class TransactionOutPoint {
    public static final int BYTES = 36;
    public static final TransactionOutPoint UNCONNECTED = new TransactionOutPoint(ByteUtils.MAX_UNSIGNED_INTEGER, Sha256Hash.ZERO_HASH);
    private final Sha256Hash hash;
    private final long index;
    final Transaction fromTx;
    final TransactionOutput connectedOutput;

    public static TransactionOutPoint read(ByteBuffer payload) throws BufferUnderflowException, ProtocolException {
        Sha256Hash hash = Sha256Hash.read(payload);
        long index = ByteUtils.readUint32(payload);
        return new TransactionOutPoint(index, hash);
    }

    public TransactionOutPoint(long index, Transaction fromTx) {
        this(fromTx.getTxId(), index, fromTx, null);
    }

    public TransactionOutPoint(long index, Sha256Hash hash) {
        this(hash, index, null, null);
    }

    public TransactionOutPoint(TransactionOutput connectedOutput) {
        this(connectedOutput.getParentTransactionHash(), connectedOutput.getIndex(), null, connectedOutput);
    }

    private TransactionOutPoint(Sha256Hash hash, long index, @Nullable Transaction fromTx, @Nullable TransactionOutput connectedOutput) {
        this.hash = Objects.requireNonNull(hash);
        Preconditions.checkArgument(index >= 0L && index <= ByteUtils.MAX_UNSIGNED_INTEGER, () -> "index out of range: " + index);
        this.index = index;
        this.fromTx = fromTx;
        this.connectedOutput = connectedOutput;
    }

    public ByteBuffer write(ByteBuffer buf) throws BufferOverflowException {
        this.hash.write(buf);
        ByteUtils.writeInt32LE(this.index, buf);
        return buf;
    }

    public byte[] serialize() {
        return this.write(ByteBuffer.allocate(36)).array();
    }

    @Deprecated
    public byte[] bitcoinSerialize() {
        return this.serialize();
    }

    @Deprecated
    public int getMessageSize() {
        return 36;
    }

    @Nullable
    public TransactionOutput getConnectedOutput() {
        if (this.fromTx != null) {
            return this.fromTx.getOutput(this.index);
        }
        if (this.connectedOutput != null) {
            return this.connectedOutput;
        }
        return null;
    }

    public byte[] getConnectedPubKeyScript() {
        byte[] result = Objects.requireNonNull(this.getConnectedOutput()).getScriptBytes();
        Preconditions.checkState(result.length > 0);
        return result;
    }

    @Nullable
    public ECKey getConnectedKey(KeyBag keyBag) throws ScriptException {
        TransactionOutput connectedOutput = this.getConnectedOutput();
        Objects.requireNonNull(connectedOutput, "Input is not connected so cannot retrieve key");
        Script connectedScript = connectedOutput.getScriptPubKey();
        if (ScriptPattern.isP2PKH(connectedScript)) {
            byte[] addressBytes = ScriptPattern.extractHashFromP2PKH(connectedScript);
            return keyBag.findKeyFromPubKeyHash(addressBytes, ScriptType.P2PKH);
        }
        if (ScriptPattern.isP2WPKH(connectedScript)) {
            byte[] addressBytes = ScriptPattern.extractHashFromP2WH(connectedScript);
            return keyBag.findKeyFromPubKeyHash(addressBytes, ScriptType.P2WPKH);
        }
        if (ScriptPattern.isP2PK(connectedScript)) {
            byte[] pubkeyBytes = ScriptPattern.extractKeyFromP2PK(connectedScript);
            return keyBag.findKeyFromPubKey(pubkeyBytes);
        }
        throw new ScriptException(ScriptError.SCRIPT_ERR_UNKNOWN_ERROR, "Could not understand form of connected output script: " + connectedScript);
    }

    @Nullable
    public RedeemData getConnectedRedeemData(KeyBag keyBag) throws ScriptException {
        TransactionOutput connectedOutput = this.getConnectedOutput();
        Objects.requireNonNull(connectedOutput, "Input is not connected so cannot retrieve key");
        Script connectedScript = connectedOutput.getScriptPubKey();
        if (ScriptPattern.isP2PKH(connectedScript)) {
            byte[] addressBytes = ScriptPattern.extractHashFromP2PKH(connectedScript);
            return RedeemData.of(keyBag.findKeyFromPubKeyHash(addressBytes, ScriptType.P2PKH), connectedScript);
        }
        if (ScriptPattern.isP2WPKH(connectedScript)) {
            byte[] addressBytes = ScriptPattern.extractHashFromP2WH(connectedScript);
            return RedeemData.of(keyBag.findKeyFromPubKeyHash(addressBytes, ScriptType.P2WPKH), connectedScript);
        }
        if (ScriptPattern.isP2PK(connectedScript)) {
            byte[] pubkeyBytes = ScriptPattern.extractKeyFromP2PK(connectedScript);
            return RedeemData.of(keyBag.findKeyFromPubKey(pubkeyBytes), connectedScript);
        }
        if (ScriptPattern.isP2SH(connectedScript)) {
            byte[] scriptHash = ScriptPattern.extractHashFromP2SH(connectedScript);
            return keyBag.findRedeemDataFromScriptHash(scriptHash);
        }
        throw new ScriptException(ScriptError.SCRIPT_ERR_UNKNOWN_ERROR, "Could not understand form of connected output script: " + connectedScript);
    }

    public TransactionOutPoint disconnectOutput() {
        return new TransactionOutPoint(this.hash, this.index, this.fromTx, null);
    }

    public TransactionOutPoint connectTransaction(Transaction transaction) {
        return new TransactionOutPoint(this.hash, this.index, Objects.requireNonNull(transaction), this.connectedOutput);
    }

    public TransactionOutPoint disconnectTransaction() {
        return new TransactionOutPoint(this.hash, this.index, null, this.connectedOutput);
    }

    public String toString() {
        return this.hash + ":" + this.index;
    }

    public Sha256Hash hash() {
        return this.hash;
    }

    public long index() {
        return this.index;
    }

    @Deprecated
    public Sha256Hash getHash() {
        return this.hash();
    }

    @Deprecated
    public long getIndex() {
        return this.index();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionOutPoint other = (TransactionOutPoint)o;
        return this.index == other.index && this.hash.equals(other.hash);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.hash);
    }
}

