/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.bitcoinj.base.Address;
import org.bitcoinj.base.Coin;
import org.bitcoinj.base.Network;
import org.bitcoinj.base.ScriptType;
import org.bitcoinj.base.Sha256Hash;
import org.bitcoinj.base.VarInt;
import org.bitcoinj.base.internal.Buffers;
import org.bitcoinj.base.internal.ByteUtils;
import org.bitcoinj.base.internal.Preconditions;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.ProtocolException;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionBag;
import org.bitcoinj.core.TransactionConfidence;
import org.bitcoinj.core.TransactionInput;
import org.bitcoinj.core.TransactionOutPoint;
import org.bitcoinj.crypto.ECKey;
import org.bitcoinj.script.Script;
import org.bitcoinj.script.ScriptBuilder;
import org.bitcoinj.script.ScriptException;
import org.bitcoinj.script.ScriptPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionOutput {
    private static final Logger log = LoggerFactory.getLogger(TransactionOutput.class);
    @Nullable
    protected Transaction parent;
    private final long value;
    private final byte[] scriptBytes;
    private Script scriptPubKey;
    private boolean availableForSpending;
    @Nullable
    private TransactionInput spentBy;

    public static TransactionOutput read(ByteBuffer payload, Transaction parentTransaction) throws BufferUnderflowException, ProtocolException {
        Objects.requireNonNull(parentTransaction);
        Coin value = Coin.read(payload);
        byte[] scriptBytes = Buffers.readLengthPrefixedBytes(payload);
        return new TransactionOutput(parentTransaction, value, scriptBytes);
    }

    public TransactionOutput(@Nullable Transaction parent, Coin value, Address to) {
        this(parent, value, ScriptBuilder.createOutputScript(to).program());
    }

    public TransactionOutput(@Nullable Transaction parent, Coin value, ECKey to) {
        this(parent, value, ScriptBuilder.createP2PKOutputScript(to).program());
    }

    public TransactionOutput(@Nullable Transaction parent, Coin value, byte[] scriptBytes) {
        Preconditions.checkArgument(value.signum() >= 0 || value.equals(Coin.NEGATIVE_SATOSHI), () -> "negative values not allowed");
        Objects.requireNonNull(scriptBytes);
        this.value = value.value;
        this.scriptBytes = scriptBytes;
        this.setParent(parent);
        this.availableForSpending = true;
    }

    @Deprecated
    public TransactionOutput(NetworkParameters params, @Nullable Transaction parent, Coin value, byte[] scriptBytes) {
        this(parent, value, scriptBytes);
    }

    public Script getScriptPubKey() throws ScriptException {
        if (this.scriptPubKey == null) {
            this.scriptPubKey = Script.parse(this.scriptBytes);
        }
        return this.scriptPubKey;
    }

    public ByteBuffer write(ByteBuffer buf) throws BufferOverflowException {
        Coin.valueOf(this.value).write(buf);
        Buffers.writeLengthPrefixedBytes(buf, this.scriptBytes);
        return buf;
    }

    public byte[] serialize() {
        return this.write(ByteBuffer.allocate(this.messageSize())).array();
    }

    @Deprecated
    public byte[] bitcoinSerialize() {
        return this.serialize();
    }

    public int messageSize() {
        int size = 8;
        return size += VarInt.sizeOf(this.scriptBytes.length) + this.scriptBytes.length;
    }

    @Deprecated
    public int getMessageSize() {
        return this.messageSize();
    }

    public Coin getValue() {
        return Coin.valueOf(this.value);
    }

    public TransactionOutput withValue(Coin value) {
        Objects.requireNonNull(value);
        return new TransactionOutput(this.parent, value, this.scriptBytes);
    }

    public int getIndex() {
        List<TransactionOutput> outputs = this.getParentTransaction().getOutputs();
        for (int i2 = 0; i2 < outputs.size(); ++i2) {
            if (outputs.get(i2) != this) continue;
            return i2;
        }
        throw new IllegalStateException("Output linked to wrong parent transaction?");
    }

    public boolean isDust() {
        return !ScriptPattern.isOpReturn(this.getScriptPubKey()) && this.getValue().isLessThan(this.getMinNonDustValue());
    }

    public Coin getMinNonDustValue(Coin feePerKb) {
        long size = this.messageSize();
        Script script = this.getScriptPubKey();
        if (ScriptPattern.isP2PKH(script) || ScriptPattern.isP2PK(script) || ScriptPattern.isP2SH(script) || ScriptPattern.isSentToMultisig(script)) {
            size += 148L;
        } else if (ScriptPattern.isP2WH(script)) {
            size += 67L;
        } else {
            return Coin.ZERO;
        }
        return feePerKb.multiply(size).divide(1000L);
    }

    public Coin getMinNonDustValue() {
        return this.getMinNonDustValue(Transaction.REFERENCE_DEFAULT_MIN_TX_FEE.multiply(3L));
    }

    public void markAsSpent(TransactionInput input) {
        Preconditions.checkState(this.availableForSpending);
        this.availableForSpending = false;
        this.spentBy = input;
        if (this.parent != null) {
            if (log.isDebugEnabled()) {
                log.debug("Marked {}:{} as spent by {}", this.getParentTransactionHash(), this.getIndex(), input);
            } else if (log.isDebugEnabled()) {
                log.debug("Marked floating output as spent by {}", (Object)input);
            }
        }
    }

    public void markAsUnspent() {
        if (this.parent != null) {
            if (log.isDebugEnabled()) {
                log.debug("Un-marked {}:{} as spent by {}", this.getParentTransactionHash(), this.getIndex(), this.spentBy);
            } else if (log.isDebugEnabled()) {
                log.debug("Un-marked floating output as spent by {}", (Object)this.spentBy);
            }
        }
        this.availableForSpending = true;
        this.spentBy = null;
    }

    public boolean isAvailableForSpending() {
        return this.availableForSpending;
    }

    public byte[] getScriptBytes() {
        return Arrays.copyOf(this.scriptBytes, this.scriptBytes.length);
    }

    public boolean isMineOrWatched(TransactionBag transactionBag) {
        return this.isMine(transactionBag) || this.isWatched(transactionBag);
    }

    public boolean isWatched(TransactionBag transactionBag) {
        try {
            Script script = this.getScriptPubKey();
            return transactionBag.isWatchedScript(script);
        }
        catch (ScriptException e) {
            log.debug("Could not parse tx output script: {}", (Object)e.toString());
            return false;
        }
    }

    public boolean isMine(TransactionBag transactionBag) {
        try {
            Script script = this.getScriptPubKey();
            if (ScriptPattern.isP2PK(script)) {
                return transactionBag.isPubKeyMine(ScriptPattern.extractKeyFromP2PK(script));
            }
            if (ScriptPattern.isP2SH(script)) {
                return transactionBag.isPayToScriptHashMine(ScriptPattern.extractHashFromP2SH(script));
            }
            if (ScriptPattern.isP2PKH(script)) {
                return transactionBag.isPubKeyHashMine(ScriptPattern.extractHashFromP2PKH(script), ScriptType.P2PKH);
            }
            if (ScriptPattern.isP2WPKH(script)) {
                return transactionBag.isPubKeyHashMine(ScriptPattern.extractHashFromP2WH(script), ScriptType.P2WPKH);
            }
            return false;
        }
        catch (ScriptException e) {
            log.debug("Could not parse tx {} output script: {}", this.parent != null ? this.parent.getTxId() : "(no parent)", (Object)e.toString());
            return false;
        }
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(@Nullable Network network) {
        StringBuilder buf = new StringBuilder("TxOut of ");
        buf.append(Coin.valueOf(this.value).toFriendlyString());
        try {
            Script script = this.getScriptPubKey();
            if (ScriptPattern.isP2PKH(script) || ScriptPattern.isP2WPKH(script) || ScriptPattern.isP2TR(script) || ScriptPattern.isP2SH(script)) {
                buf.append(" to ").append(script.getScriptType().name());
                if (network != null) {
                    buf.append(" ").append(script.getToAddress(network));
                }
            } else if (ScriptPattern.isP2PK(script)) {
                buf.append(" to pubkey ").append(ByteUtils.formatHex(ScriptPattern.extractKeyFromP2PK(script)));
            } else if (ScriptPattern.isSentToMultisig(script)) {
                buf.append(" to multisig");
            } else {
                buf.append(" (unknown type)");
            }
            buf.append(" script:").append(script);
        }
        catch (ScriptException e) {
            buf.append(" [exception: ").append(e.getMessage()).append("]");
        }
        return buf.toString();
    }

    @Nullable
    public TransactionInput getSpentBy() {
        return this.spentBy;
    }

    @Nullable
    public Transaction getParentTransaction() {
        return this.parent;
    }

    @Nullable
    public Sha256Hash getParentTransactionHash() {
        return this.parent == null ? null : this.parent.getTxId();
    }

    public int getParentTransactionDepthInBlocks() {
        TransactionConfidence confidence;
        if (this.getParentTransaction() != null && (confidence = this.getParentTransaction().getConfidence()).getConfidenceType() == TransactionConfidence.ConfidenceType.BUILDING) {
            return confidence.getDepthInBlocks();
        }
        return -1;
    }

    public TransactionOutPoint getOutPointFor() {
        return new TransactionOutPoint((long)this.getIndex(), this.getParentTransaction());
    }

    public TransactionOutput duplicateDetached() {
        return new TransactionOutput(null, Coin.valueOf(this.value), Arrays.copyOf(this.scriptBytes, this.scriptBytes.length));
    }

    protected final void setParent(@Nullable Transaction parent) {
        this.parent = parent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionOutput other = (TransactionOutput)o;
        return this.value == other.value && (this.parent == null || this.parent.equals(other.parent) && this.getIndex() == other.getIndex()) && Arrays.equals(this.scriptBytes, other.scriptBytes);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.parent, Arrays.hashCode(this.scriptBytes));
    }
}

