/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.bitcoinj.base.VarInt;
import org.bitcoinj.base.internal.Buffers;
import org.bitcoinj.base.internal.ByteUtils;
import org.bitcoinj.base.internal.InternalUtils;
import org.bitcoinj.base.internal.Preconditions;
import org.bitcoinj.crypto.ECKey;
import org.bitcoinj.crypto.TransactionSignature;
import org.bitcoinj.script.Script;

public class TransactionWitness {
    public static final TransactionWitness EMPTY = TransactionWitness.of(Collections.emptyList());
    private final List<byte[]> pushes;

    public static TransactionWitness redeemP2WPKH(@Nullable TransactionSignature signature, ECKey pubKey) {
        Preconditions.checkArgument(pubKey.isCompressed(), () -> "only compressed keys allowed");
        ArrayList<byte[]> pushes = new ArrayList<byte[]>(2);
        pushes.add(signature != null ? signature.encodeToBitcoin() : new byte[]{});
        pushes.add(pubKey.getPubKey());
        return TransactionWitness.of(pushes);
    }

    public static TransactionWitness redeemP2WSH(Script witnessScript, TransactionSignature ... signatures) {
        ArrayList<byte[]> pushes = new ArrayList<byte[]>(signatures.length + 2);
        pushes.add(new byte[0]);
        for (TransactionSignature signature : signatures) {
            pushes.add(signature.encodeToBitcoin());
        }
        pushes.add(witnessScript.program());
        return TransactionWitness.of(pushes);
    }

    public static TransactionWitness of(List<byte[]> pushes) {
        return new TransactionWitness(pushes);
    }

    public static TransactionWitness of(byte[] ... pushes) {
        return TransactionWitness.of(Arrays.asList(pushes));
    }

    public static TransactionWitness read(ByteBuffer payload) throws BufferUnderflowException {
        VarInt pushCountVarInt = VarInt.read(payload);
        Preconditions.check(pushCountVarInt.fitsInt(), BufferUnderflowException::new);
        int pushCount = pushCountVarInt.intValue();
        ArrayList<byte[]> pushes = new ArrayList<byte[]>(Math.min(pushCount, 20));
        for (int y = 0; y < pushCount; ++y) {
            pushes.add(Buffers.readLengthPrefixedBytes(payload));
        }
        return new TransactionWitness(pushes);
    }

    private TransactionWitness(List<byte[]> pushes) {
        for (byte[] push : pushes) {
            Objects.requireNonNull(push);
        }
        this.pushes = pushes;
    }

    public byte[] getPush(int i2) {
        return this.pushes.get(i2);
    }

    public int getPushCount() {
        return this.pushes.size();
    }

    public ByteBuffer write(ByteBuffer buf) throws BufferOverflowException {
        VarInt.of(this.pushes.size()).write(buf);
        for (byte[] push : this.pushes) {
            Buffers.writeLengthPrefixedBytes(buf, push);
        }
        return buf;
    }

    public byte[] serialize() {
        return this.write(ByteBuffer.allocate(this.messageSize())).array();
    }

    public int messageSize() {
        int size = VarInt.sizeOf(this.pushes.size());
        for (byte[] push : this.pushes) {
            size += VarInt.sizeOf(push.length) + push.length;
        }
        return size;
    }

    @Deprecated
    public int getMessageSize() {
        return this.messageSize();
    }

    public String toString() {
        ArrayList<String> stringPushes = new ArrayList<String>(this.pushes.size());
        for (byte[] push : this.pushes) {
            if (push.length == 0) {
                stringPushes.add("EMPTY");
                continue;
            }
            stringPushes.add(ByteUtils.formatHex(push));
        }
        return InternalUtils.SPACE_JOINER.join(stringPushes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionWitness other = (TransactionWitness)o;
        if (this.pushes.size() != other.pushes.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.pushes.size(); ++i2) {
            if (Arrays.equals(this.pushes.get(i2), other.pushes.get(i2))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        for (byte[] push : this.pushes) {
            hashCode = 31 * hashCode + Arrays.hashCode(push);
        }
        return hashCode;
    }
}

