/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.bitcoinj.base.Sha256Hash;
import org.bitcoinj.core.PeerAddress;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionConfidence;
import org.bitcoinj.utils.Threading;

public class TxConfidenceTable {
    protected final ReentrantLock lock = Threading.lock(TxConfidenceTable.class);
    private final Map<Sha256Hash, WeakConfidenceReference> table;
    private final TransactionConfidence.Factory confidenceFactory;
    private ReferenceQueue<TransactionConfidence> referenceQueue;
    public static final int MAX_SIZE = 1000;

    public TxConfidenceTable(int size) {
        this(size, TransactionConfidence::new);
    }

    TxConfidenceTable(final int size, TransactionConfidence.Factory confidenceFactory) {
        this.table = new LinkedHashMap<Sha256Hash, WeakConfidenceReference>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Sha256Hash, WeakConfidenceReference> entry) {
                return this.size() > size;
            }
        };
        this.referenceQueue = new ReferenceQueue();
        this.confidenceFactory = confidenceFactory;
    }

    public TxConfidenceTable() {
        this(1000);
    }

    public TransactionConfidence getConfidence(Transaction tx) {
        return tx.getConfidence(this);
    }

    private void cleanTable() {
        this.lock.lock();
        try {
            Reference<TransactionConfidence> ref;
            while ((ref = this.referenceQueue.poll()) != null) {
                WeakConfidenceReference txRef = (WeakConfidenceReference)ref;
                this.table.remove(txRef.hash);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numBroadcastPeers(Sha256Hash txHash) {
        this.lock.lock();
        try {
            this.cleanTable();
            WeakConfidenceReference entry = this.table.get(txHash);
            if (entry == null) {
                int n = 0;
                return n;
            }
            TransactionConfidence confidence = (TransactionConfidence)entry.get();
            if (confidence == null) {
                this.table.remove(txHash);
                int n = 0;
                return n;
            }
            int n = confidence.numBroadcastPeers();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionConfidence seen(Sha256Hash hash, PeerAddress byPeer) {
        TransactionConfidence confidence;
        boolean fresh = false;
        this.lock.lock();
        try {
            this.cleanTable();
            confidence = this.getOrCreate(hash);
            fresh = confidence.markBroadcastBy(byPeer);
        }
        finally {
            this.lock.unlock();
        }
        if (fresh) {
            confidence.queueListeners(TransactionConfidence.Listener.ChangeReason.SEEN_PEERS);
        }
        return confidence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionConfidence getOrCreate(Sha256Hash hash) {
        Objects.requireNonNull(hash);
        this.lock.lock();
        try {
            TransactionConfidence confidence = this.getConfidence(hash);
            TransactionConfidence transactionConfidence = confidence != null ? confidence : this.newConfidence(hash);
            return transactionConfidence;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Nullable
    public TransactionConfidence get(Sha256Hash hash) {
        this.lock.lock();
        try {
            TransactionConfidence transactionConfidence = this.getConfidence(hash);
            return transactionConfidence;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Nullable
    private TransactionConfidence getConfidence(Sha256Hash hash) {
        WeakConfidenceReference ref = this.table.get(hash);
        return ref != null ? (TransactionConfidence)ref.get() : null;
    }

    private TransactionConfidence newConfidence(Sha256Hash hash) {
        TransactionConfidence newConfidence = this.confidenceFactory.createConfidence(hash);
        this.table.put(hash, new WeakConfidenceReference(newConfidence, this.referenceQueue));
        return newConfidence;
    }

    private static class WeakConfidenceReference
    extends WeakReference<TransactionConfidence> {
        final Sha256Hash hash;

        WeakConfidenceReference(TransactionConfidence confidence, ReferenceQueue<TransactionConfidence> queue) {
            super(confidence, queue);
            this.hash = confidence.getTransactionHash();
        }
    }
}

