/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import java.util.Locale;
import java.util.Objects;
import org.bitcoinj.base.Coin;
import org.bitcoinj.base.Sha256Hash;
import org.bitcoinj.script.Script;

public class UTXO {
    private final Coin value;
    private final Script script;
    private final Sha256Hash hash;
    private final long index;
    private final int height;
    private final boolean coinbase;
    private final String address;

    public UTXO(Sha256Hash hash, long index, Coin value, int height, boolean coinbase, Script script) {
        this(hash, index, value, height, coinbase, script, "");
    }

    public UTXO(Sha256Hash hash, long index, Coin value, int height, boolean coinbase, Script script, String address) {
        this.hash = Objects.requireNonNull(hash);
        this.index = index;
        this.value = Objects.requireNonNull(value);
        this.height = height;
        this.script = script;
        this.coinbase = coinbase;
        this.address = address;
    }

    public Coin getValue() {
        return this.value;
    }

    public Script getScript() {
        return this.script;
    }

    public Sha256Hash getHash() {
        return this.hash;
    }

    public long getIndex() {
        return this.index;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isCoinbase() {
        return this.coinbase;
    }

    public String getAddress() {
        return this.address;
    }

    public String toString() {
        return String.format(Locale.US, "Stored TxOut of %s (%s:%d)", this.value.toFriendlyString(), this.hash, this.index);
    }

    public int hashCode() {
        return Objects.hash(this.getIndex(), this.getHash(), this.getValue());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UTXO other = (UTXO)o;
        return this.getIndex() == other.getIndex() && this.getHash().equals(other.getHash()) && this.getValue().equals(((UTXO)o).getValue());
    }
}

