/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import com.google.common.net.InetAddresses;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import org.bitcoinj.base.VarInt;
import org.bitcoinj.base.internal.Buffers;
import org.bitcoinj.base.internal.ByteUtils;
import org.bitcoinj.base.internal.Preconditions;
import org.bitcoinj.base.internal.TimeUtils;
import org.bitcoinj.core.BaseMessage;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.PeerAddress;
import org.bitcoinj.core.ProtocolException;
import org.bitcoinj.core.ProtocolVersion;
import org.bitcoinj.core.Services;

public class VersionMessage
extends BaseMessage {
    public static final String BITCOINJ_VERSION = "0.17";
    public static final String LIBRARY_SUBVER = "/bitcoinj:0.17/";
    @Deprecated
    public static final int NODE_NETWORK = 1;
    @Deprecated
    public static final int NODE_BLOOM = 4;
    @Deprecated
    public static final int NODE_WITNESS = 8;
    @Deprecated
    public static final int NODE_NETWORK_LIMITED = 1024;
    @Deprecated
    public static final int NODE_BITCOIN_CASH = 32;
    public int clientVersion;
    public Services localServices;
    public Instant time;
    public Services receivingServices;
    public InetSocketAddress receivingAddr;
    public String subVer;
    public long bestHeight;
    public boolean relayTxesBeforeFilter;
    private static final int NETADDR_BYTES = 26;

    public static VersionMessage read(ByteBuffer payload) throws BufferUnderflowException, ProtocolException {
        int clientVersion = (int)ByteUtils.readUint32(payload);
        Preconditions.check(clientVersion >= ProtocolVersion.MINIMUM.intValue(), ProtocolException::new);
        Services localServices = Services.read(payload);
        Instant time = Instant.ofEpochSecond(ByteUtils.readInt64(payload));
        Services receivingServices = Services.read(payload);
        InetAddress receivingInetAddress = PeerAddress.getByAddress(Buffers.readBytes(payload, 16));
        int receivingPort = ByteUtils.readUint16BE(payload);
        InetSocketAddress receivingAddr = new InetSocketAddress(receivingInetAddress, receivingPort);
        Buffers.skipBytes(payload, 26);
        Buffers.skipBytes(payload, 8);
        String subVer = Buffers.readLengthPrefixedString(payload);
        long bestHeight = ByteUtils.readUint32(payload);
        boolean relayTxesBeforeFilter = clientVersion >= ProtocolVersion.BLOOM_FILTER.intValue() ? payload.get() != 0 : true;
        return new VersionMessage(clientVersion, localServices, time, receivingServices, receivingAddr, subVer, bestHeight, relayTxesBeforeFilter);
    }

    public VersionMessage(NetworkParameters params, int bestHeight) {
        this.clientVersion = ProtocolVersion.CURRENT.intValue();
        this.localServices = Services.none();
        this.time = TimeUtils.currentTime().truncatedTo(ChronoUnit.SECONDS);
        InetAddress localhost = InetAddresses.forString((String)"127.0.0.1");
        this.receivingServices = Services.none();
        this.receivingAddr = new InetSocketAddress(localhost, params.getPort());
        this.subVer = LIBRARY_SUBVER;
        this.bestHeight = bestHeight;
        this.relayTxesBeforeFilter = true;
    }

    private VersionMessage(int clientVersion, Services localServices, Instant time, Services receivingServices, InetSocketAddress receivingAddr, String subVer, long bestHeight, boolean relayTxesBeforeFilter) {
        this.clientVersion = clientVersion;
        this.localServices = localServices;
        this.time = time;
        this.receivingServices = receivingServices;
        this.receivingAddr = receivingAddr;
        this.subVer = subVer;
        this.bestHeight = bestHeight;
        this.relayTxesBeforeFilter = relayTxesBeforeFilter;
    }

    public int clientVersion() {
        return this.clientVersion;
    }

    public Services services() {
        return this.localServices;
    }

    @Override
    public void bitcoinSerializeToStream(OutputStream buf) throws IOException {
        ByteUtils.writeInt32LE(this.clientVersion, buf);
        buf.write(this.localServices.serialize());
        ByteUtils.writeInt64LE(this.time.getEpochSecond(), buf);
        buf.write(this.receivingServices.serialize());
        buf.write(PeerAddress.mapIntoIPv6(this.receivingAddr.getAddress().getAddress()));
        ByteUtils.writeInt16BE(this.receivingAddr.getPort(), buf);
        buf.write(new byte[26]);
        ByteUtils.writeInt32LE(0, buf);
        ByteUtils.writeInt32LE(0, buf);
        byte[] subVerBytes = this.subVer.getBytes(StandardCharsets.UTF_8);
        buf.write(VarInt.of(subVerBytes.length).serialize());
        buf.write(subVerBytes);
        ByteUtils.writeInt32LE(this.bestHeight, buf);
        buf.write(this.relayTxesBeforeFilter ? 1 : 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionMessage other = (VersionMessage)o;
        return other.bestHeight == this.bestHeight && other.clientVersion == this.clientVersion && other.localServices == this.localServices && other.time.equals(this.time) && other.subVer.equals(this.subVer) && other.receivingServices.equals(this.receivingServices) && other.receivingAddr.equals(this.receivingAddr) && other.relayTxesBeforeFilter == this.relayTxesBeforeFilter;
    }

    public int hashCode() {
        return Objects.hash(this.bestHeight, this.clientVersion, this.localServices, this.time, this.subVer, this.receivingServices, this.receivingAddr, this.relayTxesBeforeFilter);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("\n");
        builder.append("client version: ").append(this.clientVersion).append("\n");
        if (this.localServices.hasAny()) {
            builder.append("local services: ").append(this.localServices);
        }
        builder.append("\n");
        builder.append("time:           ").append(TimeUtils.dateTimeFormat(this.time)).append("\n");
        builder.append("receiving svc:  ").append(this.receivingServices).append("\n");
        builder.append("receiving addr: ").append(this.receivingAddr).append("\n");
        builder.append("sub version:    ").append(this.subVer).append("\n");
        builder.append("best height:    ").append(this.bestHeight).append("\n");
        builder.append("delay tx relay: ").append(!this.relayTxesBeforeFilter).append("\n");
        return builder.toString();
    }

    public VersionMessage duplicate() {
        return new VersionMessage(this.clientVersion, this.localServices, this.time, this.receivingServices, this.receivingAddr, this.subVer, this.bestHeight, this.relayTxesBeforeFilter);
    }

    public void appendToSubVer(String name, String version, @Nullable String comments) {
        VersionMessage.checkSubVerComponent(name);
        VersionMessage.checkSubVerComponent(version);
        if (comments != null) {
            VersionMessage.checkSubVerComponent(comments);
            this.subVer = this.subVer.concat(String.format(Locale.US, "%s:%s(%s)/", name, version, comments));
        } else {
            this.subVer = this.subVer.concat(String.format(Locale.US, "%s:%s/", name, version));
        }
    }

    private static void checkSubVerComponent(String component) {
        if (component.contains("/") || component.contains("(") || component.contains(")")) {
            throw new IllegalArgumentException("name contains invalid characters");
        }
    }

    @Deprecated
    public boolean isPingPongSupported() {
        return true;
    }

    @Deprecated
    public static String toStringServices(long services) {
        return Services.of(services).toString();
    }
}

