/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core.internal;

import com.google.common.io.BaseEncoding;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Locale;
import org.bitcoinj.base.internal.Preconditions;
import org.bouncycastle.jcajce.provider.digest.SHA3;

public class TorUtils {
    private static final BaseEncoding BASE32 = BaseEncoding.base32().omitPadding().lowerCase();

    public static String encodeOnionUrlV2(byte[] onionAddrBytes) {
        Preconditions.checkArgument(onionAddrBytes.length == 10);
        return BASE32.encode(onionAddrBytes) + ".onion";
    }

    public static String encodeOnionUrlV3(byte[] onionAddrBytes) {
        Preconditions.checkArgument(onionAddrBytes.length == 32);
        byte torVersion = 3;
        byte[] onionAddress = new byte[35];
        System.arraycopy(onionAddrBytes, 0, onionAddress, 0, 32);
        System.arraycopy(TorUtils.onionChecksum(onionAddrBytes, torVersion), 0, onionAddress, 32, 2);
        onionAddress[34] = torVersion;
        return BASE32.encode(onionAddress) + ".onion";
    }

    public static byte[] decodeOnionUrl(String onionUrl) {
        if (!onionUrl.toLowerCase(Locale.ROOT).endsWith(".onion")) {
            throw new IllegalArgumentException("not an onion URL: " + onionUrl);
        }
        byte[] onionAddress = BASE32.decode((CharSequence)onionUrl.substring(0, onionUrl.length() - 6));
        if (onionAddress.length == 10) {
            return onionAddress;
        }
        if (onionAddress.length == 35) {
            byte[] pubkey = Arrays.copyOfRange(onionAddress, 0, 32);
            byte[] checksum = Arrays.copyOfRange(onionAddress, 32, 34);
            byte torVersion = onionAddress[34];
            if (torVersion != 3) {
                throw new IllegalArgumentException("unknown version: " + onionUrl);
            }
            if (!Arrays.equals(checksum, TorUtils.onionChecksum(pubkey, torVersion))) {
                throw new IllegalArgumentException("bad checksum: " + onionUrl);
            }
            return pubkey;
        }
        throw new IllegalArgumentException("unrecognizable length: " + onionUrl);
    }

    private static byte[] onionChecksum(byte[] pubkey, byte version) {
        if (pubkey.length != 32) {
            throw new IllegalArgumentException();
        }
        SHA3.Digest256 digest256 = new SHA3.Digest256();
        digest256.update(".onion checksum".getBytes(StandardCharsets.US_ASCII));
        digest256.update(pubkey);
        digest256.update(version);
        return Arrays.copyOf(digest256.digest(), 2);
    }
}

