/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.crypto;

import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bitcoinj.base.internal.Preconditions;
import org.bitcoinj.crypto.ChildNumber;
import org.bitcoinj.crypto.DeterministicKey;
import org.bitcoinj.crypto.HDDerivationException;
import org.bitcoinj.crypto.HDKeyDerivation;
import org.bitcoinj.crypto.HDPath;

public class DeterministicHierarchy {
    private final Map<HDPath, DeterministicKey> keys = new HashMap<HDPath, DeterministicKey>();
    private final HDPath rootPath;
    private final Map<HDPath, ChildNumber> lastChildNumbers = new HashMap<HDPath, ChildNumber>();
    public static final Instant BIP32_STANDARDISATION_TIME = Instant.ofEpochSecond(1369267200L);
    @Deprecated
    public static final int BIP32_STANDARDISATION_TIME_SECS = Math.toIntExact(BIP32_STANDARDISATION_TIME.getEpochSecond());

    public DeterministicHierarchy(DeterministicKey rootKey) {
        this.putKey(rootKey);
        this.rootPath = rootKey.getPath();
    }

    public final void putKey(DeterministicKey key) {
        HDPath path = key.getPath();
        DeterministicKey parent = key.getParent();
        if (parent != null) {
            this.lastChildNumbers.put(parent.getPath(), key.getChildNumber());
        }
        this.keys.put(path, key);
    }

    public final void putKeys(List<DeterministicKey> keys2) {
        keys2.forEach(this::putKey);
    }

    public DeterministicKey get(List<ChildNumber> path, boolean relativePath, boolean create) {
        HDPath absolutePath;
        HDPath inputPath = HDPath.M(path);
        HDPath hDPath = absolutePath = relativePath ? this.rootPath.extend(path) : inputPath;
        if (!this.keys.containsKey(absolutePath)) {
            if (!create) {
                throw new IllegalArgumentException(String.format(Locale.US, "No key found for %s path %s.", relativePath ? "relative" : "absolute", inputPath.toString()));
            }
            Preconditions.checkArgument(absolutePath.size() > 0, () -> "can't derive the master key: nothing to derive from");
            DeterministicKey parent = this.get(absolutePath.subList(0, absolutePath.size() - 1), false, true);
            this.putKey(HDKeyDerivation.deriveChildKey(parent, absolutePath.get(absolutePath.size() - 1)));
        }
        return this.keys.get(absolutePath);
    }

    public DeterministicKey deriveNextChild(List<ChildNumber> parentPath, boolean relative, boolean createParent, boolean privateDerivation) {
        DeterministicKey parent = this.get(parentPath, relative, createParent);
        int nAttempts = 0;
        while (nAttempts++ < 100) {
            try {
                ChildNumber createChildNumber = this.getNextChildNumberToDerive(parent.getPath(), privateDerivation);
                return this.deriveChild(parent, createChildNumber);
            }
            catch (HDDerivationException hDDerivationException) {
            }
        }
        throw new HDDerivationException("Maximum number of child derivation attempts reached, this is probably an indication of a bug.");
    }

    private ChildNumber getNextChildNumberToDerive(HDPath path, boolean privateDerivation) {
        ChildNumber lastChildNumber = this.lastChildNumbers.get(path);
        ChildNumber nextChildNumber = new ChildNumber(lastChildNumber != null ? lastChildNumber.num() + 1 : 0, privateDerivation);
        this.lastChildNumbers.put(path, nextChildNumber);
        return nextChildNumber;
    }

    public int getNumChildren(HDPath path) {
        ChildNumber cn = this.lastChildNumbers.get(path);
        if (cn == null) {
            return 0;
        }
        return cn.num() + 1;
    }

    public DeterministicKey deriveChild(List<ChildNumber> parentPath, boolean relative, boolean createParent, ChildNumber createChildNumber) {
        return this.deriveChild(this.get(parentPath, relative, createParent), createChildNumber);
    }

    private DeterministicKey deriveChild(DeterministicKey parent, ChildNumber createChildNumber) {
        DeterministicKey childKey = HDKeyDerivation.deriveChildKey(parent, createChildNumber);
        this.putKey(childKey);
        return childKey;
    }

    public DeterministicKey getRootKey() {
        return this.get(this.rootPath, false, false);
    }
}

