/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.crypto;

import java.util.Arrays;
import javax.annotation.Nullable;
import org.bitcoinj.base.Base58;
import org.bitcoinj.base.Network;
import org.bitcoinj.base.exceptions.AddressFormatException;
import org.bitcoinj.base.internal.Preconditions;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.crypto.ECKey;
import org.bitcoinj.crypto.EncodedPrivateKey;
import org.bitcoinj.params.Networks;

public class DumpedPrivateKey
extends EncodedPrivateKey {
    public static DumpedPrivateKey fromBase58(@Nullable Network network, String base58) throws AddressFormatException, AddressFormatException.WrongNetwork {
        byte[] versionAndDataBytes = Base58.decodeChecked(base58);
        int version = versionAndDataBytes[0] & 0xFF;
        byte[] bytes = Arrays.copyOfRange(versionAndDataBytes, 1, versionAndDataBytes.length);
        if (network == null) {
            for (NetworkParameters p : Networks.get()) {
                if (version != p.getDumpedPrivateKeyHeader()) continue;
                return new DumpedPrivateKey(p.network(), bytes);
            }
            throw new AddressFormatException.InvalidPrefix("No network found for version " + version);
        }
        NetworkParameters params = NetworkParameters.of(network);
        if (version == params.getDumpedPrivateKeyHeader()) {
            return new DumpedPrivateKey(network, bytes);
        }
        throw new AddressFormatException.WrongNetwork(version);
    }

    @Deprecated
    public static DumpedPrivateKey fromBase58(@Nullable NetworkParameters params, String base58) throws AddressFormatException, AddressFormatException.WrongNetwork {
        return DumpedPrivateKey.fromBase58(params == null ? null : params.network(), base58);
    }

    private DumpedPrivateKey(Network network, byte[] bytes) {
        super(network, bytes);
        if (bytes.length != 32 && bytes.length != 33) {
            throw new AddressFormatException.InvalidDataLength("Wrong number of bytes for a private key (32 or 33): " + bytes.length);
        }
    }

    DumpedPrivateKey(Network network, byte[] keyBytes, boolean compressed) {
        this(network, DumpedPrivateKey.encode(keyBytes, compressed));
    }

    public String toBase58() {
        NetworkParameters params = NetworkParameters.of(this.network);
        return Base58.encodeChecked(params.getDumpedPrivateKeyHeader(), this.bytes);
    }

    private static byte[] encode(byte[] keyBytes, boolean compressed) {
        Preconditions.checkArgument(keyBytes.length == 32, () -> "private keys must be 32 bytes");
        if (!compressed) {
            return keyBytes;
        }
        byte[] bytes = new byte[33];
        System.arraycopy(keyBytes, 0, bytes, 0, 32);
        bytes[32] = 1;
        return bytes;
    }

    public ECKey getKey() {
        return ECKey.fromPrivate(Arrays.copyOf(this.bytes, 32), this.isPubKeyCompressed());
    }

    public boolean isPubKeyCompressed() {
        return this.bytes.length == 33 && this.bytes[32] == 1;
    }

    public String toString() {
        return this.toBase58();
    }
}

