/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.crypto;

import java.util.Arrays;
import java.util.Objects;
import org.bitcoinj.base.Network;
import org.bitcoinj.core.NetworkParameters;

public abstract class EncodedPrivateKey {
    protected final Network network;
    protected final byte[] bytes;

    protected EncodedPrivateKey(Network network, byte[] bytes) {
        this.network = Objects.requireNonNull(network);
        this.bytes = Objects.requireNonNull(bytes);
    }

    @Deprecated
    protected EncodedPrivateKey(NetworkParameters params, byte[] bytes) {
        this(Objects.requireNonNull(params).network(), Objects.requireNonNull(bytes));
    }

    public Network network() {
        return this.network;
    }

    @Deprecated
    public final NetworkParameters getParameters() {
        return NetworkParameters.of(this.network);
    }

    public int hashCode() {
        return Objects.hash(this.network, Arrays.hashCode(this.bytes));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncodedPrivateKey other = (EncodedPrivateKey)o;
        return this.network.equals(other.network) && Arrays.equals(this.bytes, other.bytes);
    }
}

