/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.crypto;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.bitcoinj.base.internal.ByteUtils;
import org.bitcoinj.base.internal.Preconditions;

public class PBKDF2SHA512 {
    private static final int H_LEN = 64;

    public static byte[] derive(String P, String S, int c, int dkLen) {
        Preconditions.checkArgument(c > 0, () -> "count must be greater than zero");
        Preconditions.checkArgument(dkLen > 0, () -> "derived key length must be greater than zero");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int l = (dkLen + 64 - 1) / 64;
            for (int i2 = 1; i2 <= l; ++i2) {
                byte[] T = PBKDF2SHA512.F(P, S, c, i2);
                baos.write(T);
            }
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        byte[] baDerived = new byte[dkLen];
        System.arraycopy(baos.toByteArray(), 0, baDerived, 0, baDerived.length);
        return baDerived;
    }

    private static byte[] F(String P, String S, int c, int i2) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] U_LAST = null;
        byte[] U_XOR = null;
        SecretKeySpec key = new SecretKeySpec(P.getBytes(StandardCharsets.UTF_8), "HmacSHA512");
        Mac mac = Mac.getInstance(key.getAlgorithm());
        mac.init(key);
        for (int j = 0; j < c; ++j) {
            byte[] baU;
            if (j == 0) {
                baU = ByteUtils.concat(S.getBytes(StandardCharsets.UTF_8), PBKDF2SHA512.INT(i2));
                U_LAST = U_XOR = mac.doFinal(baU);
                continue;
            }
            baU = mac.doFinal(U_LAST);
            for (int k = 0; k < U_XOR.length; ++k) {
                U_XOR[k] = (byte)(U_XOR[k] ^ baU[k]);
            }
            U_LAST = baU;
        }
        return U_XOR;
    }

    private static byte[] INT(int i2) {
        return ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(i2).array();
    }
}

