/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.kits;

import com.google.common.io.Closeables;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.Service;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bitcoinj.base.BitcoinNetwork;
import org.bitcoinj.base.ScriptType;
import org.bitcoinj.base.internal.PlatformUtils;
import org.bitcoinj.base.internal.Preconditions;
import org.bitcoinj.core.AbstractBlockChain;
import org.bitcoinj.core.BlockChain;
import org.bitcoinj.core.CheckpointManager;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.PeerAddress;
import org.bitcoinj.core.PeerGroup;
import org.bitcoinj.core.listeners.DownloadProgressTracker;
import org.bitcoinj.crypto.DeterministicKey;
import org.bitcoinj.net.discovery.DnsDiscovery;
import org.bitcoinj.net.discovery.PeerDiscovery;
import org.bitcoinj.store.BlockStore;
import org.bitcoinj.store.BlockStoreException;
import org.bitcoinj.store.SPVBlockStore;
import org.bitcoinj.wallet.DeterministicSeed;
import org.bitcoinj.wallet.KeyChainGroup;
import org.bitcoinj.wallet.KeyChainGroupStructure;
import org.bitcoinj.wallet.Wallet;
import org.bitcoinj.wallet.WalletExtension;
import org.bitcoinj.wallet.WalletProtobufSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WalletAppKit
extends AbstractIdleService
implements Closeable {
    protected static final Logger log = LoggerFactory.getLogger(WalletAppKit.class);
    protected final BitcoinNetwork network;
    protected final NetworkParameters params;
    protected final ScriptType preferredOutputScriptType;
    protected final KeyChainGroupStructure structure;
    protected final String filePrefix;
    protected volatile BlockChain vChain;
    protected volatile SPVBlockStore vStore;
    protected volatile Wallet vWallet;
    protected volatile PeerGroup vPeerGroup;
    protected final File directory;
    protected volatile File vWalletFile;
    protected boolean useAutoSave = true;
    protected PeerAddress[] peerAddresses;
    protected DownloadProgressTracker downloadListener = new DownloadProgressTracker();
    protected boolean autoStop = true;
    protected InputStream checkpoints;
    protected boolean blockingStartup = true;
    protected String userAgent;
    protected String version;
    @Nonnull
    protected WalletProtobufSerializer.WalletFactory walletFactory = WalletProtobufSerializer.WalletFactory.DEFAULT;
    @Nullable
    protected DeterministicSeed restoreFromSeed;
    @Nullable
    protected DeterministicKey restoreFromKey;
    @Nullable
    protected PeerDiscovery discovery;

    @Deprecated
    public WalletAppKit(NetworkParameters params, File directory, String filePrefix) {
        this((BitcoinNetwork)params.network(), ScriptType.P2PKH, KeyChainGroupStructure.BIP32, directory, filePrefix);
    }

    @Deprecated
    public WalletAppKit(NetworkParameters params, ScriptType preferredOutputScriptType, @Nullable KeyChainGroupStructure structure, File directory, String filePrefix) {
        this((BitcoinNetwork)params.network(), preferredOutputScriptType, structure, directory, filePrefix);
    }

    public WalletAppKit(BitcoinNetwork network, ScriptType preferredOutputScriptType, KeyChainGroupStructure structure, File directory, String filePrefix) {
        this.network = Objects.requireNonNull(network);
        this.params = NetworkParameters.of(this.network);
        this.preferredOutputScriptType = Objects.requireNonNull(preferredOutputScriptType);
        this.structure = Objects.requireNonNull(structure);
        this.directory = Objects.requireNonNull(directory);
        this.filePrefix = Objects.requireNonNull(filePrefix);
    }

    public static WalletAppKit launch(BitcoinNetwork network, File directory, String filePrefix) {
        return WalletAppKit.launch(network, directory, filePrefix, 0);
    }

    public static WalletAppKit launch(BitcoinNetwork network, File directory, String filePrefix, Consumer<WalletAppKit> configurer) {
        return WalletAppKit.launch(network, directory, filePrefix, configurer, 0);
    }

    public static WalletAppKit launch(BitcoinNetwork network, File directory, String filePrefix, int maxConnections) {
        return WalletAppKit.launch(network, directory, filePrefix, c -> {}, maxConnections);
    }

    public static WalletAppKit launch(BitcoinNetwork network, File directory, String filePrefix, Consumer<WalletAppKit> configurer, int maxConnections) {
        WalletAppKit kit = new WalletAppKit(network, ScriptType.P2WPKH, KeyChainGroupStructure.BIP32, directory, filePrefix);
        if (network == BitcoinNetwork.REGTEST) {
            kit.connectToLocalHost();
        }
        kit.setBlockingStartup(false);
        configurer.accept(kit);
        kit.startAsync();
        kit.awaitRunning();
        if (maxConnections > 0) {
            kit.peerGroup().setMaxConnections(maxConnections);
        }
        return kit;
    }

    public WalletAppKit setPeerNodes(PeerAddress ... addresses) {
        Preconditions.checkState(this.state() == Service.State.NEW, () -> "cannot call after startup");
        this.peerAddresses = addresses;
        return this;
    }

    public WalletAppKit connectToLocalHost() {
        return this.setPeerNodes(PeerAddress.localhost(this.params));
    }

    public WalletAppKit setAutoSave(boolean value) {
        Preconditions.checkState(this.state() == Service.State.NEW, () -> "cannot call after startup");
        this.useAutoSave = value;
        return this;
    }

    public WalletAppKit setDownloadListener(DownloadProgressTracker listener) {
        Objects.requireNonNull(listener);
        this.downloadListener = listener;
        return this;
    }

    public WalletAppKit setAutoStop(boolean autoStop) {
        this.autoStop = autoStop;
        return this;
    }

    public WalletAppKit setCheckpoints(InputStream checkpoints) {
        if (this.checkpoints != null) {
            Closeables.closeQuietly((InputStream)checkpoints);
        }
        this.checkpoints = Objects.requireNonNull(checkpoints);
        return this;
    }

    public WalletAppKit setBlockingStartup(boolean blockingStartup) {
        this.blockingStartup = blockingStartup;
        return this;
    }

    public WalletAppKit setUserAgent(String userAgent, String version) {
        this.userAgent = Objects.requireNonNull(userAgent);
        this.version = Objects.requireNonNull(version);
        return this;
    }

    public WalletAppKit setWalletFactory(@Nonnull WalletProtobufSerializer.WalletFactory walletFactory) {
        Objects.requireNonNull(walletFactory);
        this.walletFactory = walletFactory;
        return this;
    }

    public WalletAppKit restoreWalletFromSeed(DeterministicSeed seed) {
        this.restoreFromSeed = seed;
        return this;
    }

    public WalletAppKit restoreWalletFromKey(DeterministicKey accountKey) {
        this.restoreFromKey = accountKey;
        return this;
    }

    public WalletAppKit setDiscovery(@Nullable PeerDiscovery discovery) {
        this.discovery = discovery;
        return this;
    }

    protected List<WalletExtension> provideWalletExtensions() throws Exception {
        return Collections.emptyList();
    }

    protected void onSetupCompleted() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isChainFileLocked() throws IOException {
        try (RandomAccessFile file2 = null;){
            File file = new File(this.directory, this.filePrefix + ".spvchain");
            if (!file.exists()) {
                boolean bl = false;
                return bl;
            }
            if (file.isDirectory()) {
                boolean bl = false;
                return bl;
            }
            file2 = new RandomAccessFile(file, "rw");
            FileLock lock = file2.getChannel().tryLock();
            if (lock == null) {
                boolean bl = true;
                return bl;
            }
            lock.release();
            boolean bl = false;
            return bl;
        }
    }

    protected void startUp() throws Exception {
        if (!this.directory.exists() && !this.directory.mkdirs()) {
            throw new IOException("Could not create directory " + this.directory.getAbsolutePath());
        }
        log.info("Starting up with directory = {}", (Object)this.directory);
        File chainFile = new File(this.directory, this.filePrefix + ".spvchain");
        boolean chainFileExists = chainFile.exists();
        this.vWalletFile = new File(this.directory, this.filePrefix + ".wallet");
        boolean shouldReplayWallet = this.vWalletFile.exists() && !chainFileExists || this.restoreFromSeed != null || this.restoreFromKey != null;
        this.vWallet = this.createOrLoadWallet(shouldReplayWallet);
        this.vStore = new SPVBlockStore(this.params, chainFile);
        if (!chainFileExists || this.restoreFromSeed != null || this.restoreFromKey != null) {
            if (this.checkpoints == null && !PlatformUtils.isAndroidRuntime()) {
                this.checkpoints = CheckpointManager.openStream(this.params);
            }
            if (this.checkpoints != null) {
                Instant time;
                if (this.restoreFromSeed != null) {
                    time = this.restoreFromSeed.getCreationTime().orElse(Instant.EPOCH);
                    if (chainFileExists) {
                        log.info("Clearing the chain file in preparation for restore.");
                        this.vStore.clear();
                    }
                } else if (this.restoreFromKey != null) {
                    time = this.restoreFromKey.getCreationTime().orElse(Instant.EPOCH);
                    if (chainFileExists) {
                        log.info("Clearing the chain file in preparation for restore.");
                        this.vStore.clear();
                    }
                } else {
                    time = this.vWallet.earliestKeyCreationTime();
                }
                if (time.isAfter(Instant.EPOCH)) {
                    CheckpointManager.checkpoint(this.params, this.checkpoints, (BlockStore)this.vStore, time);
                } else {
                    log.warn("Creating a new uncheckpointed block store due to a wallet with a creation time of zero: this will result in a very slow chain sync");
                }
            } else if (chainFileExists) {
                log.info("Clearing the chain file in preparation for restore.");
                this.vStore.clear();
            }
        }
        this.vChain = new BlockChain(this.network, this.vStore);
        this.vPeerGroup = this.createPeerGroup();
        if (this.userAgent != null) {
            this.vPeerGroup.setUserAgent(this.userAgent, this.version);
        }
        if (this.peerAddresses != null) {
            for (PeerAddress addr : this.peerAddresses) {
                this.vPeerGroup.addAddress(addr);
            }
            this.vPeerGroup.setMaxConnections(this.peerAddresses.length);
            this.peerAddresses = null;
        } else if (this.params.network() != BitcoinNetwork.REGTEST) {
            this.vPeerGroup.addPeerDiscovery(this.discovery != null ? this.discovery : new DnsDiscovery(this.network));
        }
        this.vChain.addWallet(this.vWallet);
        this.vPeerGroup.addWallet(this.vWallet);
        this.onSetupCompleted();
        this.vPeerGroup.startAsync().whenComplete((result, t) -> {
            if (t != null) {
                throw new RuntimeException((Throwable)t);
            }
            this.vPeerGroup.startBlockChainDownload(this.downloadListener);
        });
        this.installShutdownHook();
        if (this.blockingStartup) {
            this.downloadListener.await();
        }
    }

    private Wallet createOrLoadWallet(boolean shouldReplayWallet) throws Exception {
        Wallet wallet;
        this.maybeMoveOldWalletOutOfTheWay();
        if (this.vWalletFile.exists()) {
            wallet = this.loadWallet(shouldReplayWallet);
        } else {
            wallet = this.createWallet();
            wallet.freshReceiveKey();
            for (WalletExtension e : this.provideWalletExtensions()) {
                wallet.addExtension(e);
            }
            wallet.saveToFile(this.vWalletFile);
            wallet = this.loadWallet(false);
        }
        if (this.useAutoSave) {
            this.setupAutoSave(wallet);
        }
        return wallet;
    }

    protected void setupAutoSave(Wallet wallet) {
        wallet.autosaveToFile(this.vWalletFile, Duration.ofSeconds(5L), null);
    }

    private Wallet loadWallet(boolean shouldReplayWallet) throws Exception {
        WalletExtension[] extensions = this.provideWalletExtensions().toArray(new WalletExtension[0]);
        return Wallet.loadFromFile(this.vWalletFile, this.walletFactory, shouldReplayWallet, false, extensions);
    }

    protected Wallet createWallet() {
        KeyChainGroup.Builder kcg = KeyChainGroup.builder(this.network, this.structure);
        if (this.restoreFromSeed != null) {
            kcg.fromSeed(this.restoreFromSeed, this.preferredOutputScriptType);
        } else if (this.restoreFromKey != null) {
            kcg.fromKey(this.restoreFromKey, this.preferredOutputScriptType).build();
        } else {
            kcg.fromRandom(this.preferredOutputScriptType);
        }
        return this.walletFactory.create(this.network, kcg.build());
    }

    private void maybeMoveOldWalletOutOfTheWay() {
        File newName;
        if (this.restoreFromSeed == null && this.restoreFromKey == null) {
            return;
        }
        if (!this.vWalletFile.exists()) {
            return;
        }
        int counter = 1;
        do {
            newName = new File(this.vWalletFile.getParent(), "Backup " + counter + " for " + this.vWalletFile.getName());
            ++counter;
        } while (newName.exists());
        log.info("Renaming old wallet file {} to {}", (Object)this.vWalletFile, (Object)newName);
        if (!this.vWalletFile.renameTo(newName)) {
            throw new RuntimeException("Failed to rename wallet for restore");
        }
    }

    protected PeerGroup createPeerGroup() {
        return new PeerGroup(this.network, (AbstractBlockChain)this.vChain);
    }

    private void installShutdownHook() {
        if (this.autoStop) {
            Runtime.getRuntime().addShutdownHook(new Thread(this::shutdownHook, "shutdownHook"));
        }
    }

    private void shutdownHook() {
        try {
            this.stopAsync();
            this.awaitTerminated();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void shutDown() throws Exception {
        try {
            this.vPeerGroup.stop();
            this.vWallet.saveToFile(this.vWalletFile);
            this.vStore.close();
            this.vPeerGroup = null;
            this.vWallet = null;
            this.vStore = null;
            this.vChain = null;
        }
        catch (BlockStoreException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() {
        this.stopAsync();
        this.awaitTerminated();
    }

    public BitcoinNetwork network() {
        return this.network;
    }

    public NetworkParameters params() {
        return this.params;
    }

    public BlockChain chain() {
        Preconditions.checkState(this.state() == Service.State.STARTING || this.state() == Service.State.RUNNING, () -> "cannot call until startup is complete");
        return this.vChain;
    }

    public BlockStore store() {
        Preconditions.checkState(this.state() == Service.State.STARTING || this.state() == Service.State.RUNNING, () -> "cannot call until startup is complete");
        return this.vStore;
    }

    public Wallet wallet() {
        Preconditions.checkState(this.state() == Service.State.STARTING || this.state() == Service.State.RUNNING, () -> "cannot call until startup is complete");
        return this.vWallet;
    }

    public PeerGroup peerGroup() {
        Preconditions.checkState(this.state() == Service.State.STARTING || this.state() == Service.State.RUNNING, () -> "cannot call until startup is complete");
        return this.vPeerGroup;
    }

    public File directory() {
        return this.directory;
    }
}

