/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import javax.net.SocketFactory;
import org.bitcoinj.base.internal.Preconditions;
import org.bitcoinj.core.Context;
import org.bitcoinj.net.MessageWriteTarget;
import org.bitcoinj.net.StreamConnection;
import org.bitcoinj.utils.ListenableCompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingClient
implements MessageWriteTarget {
    private static final Logger log = LoggerFactory.getLogger(BlockingClient.class);
    private static final int BUFFER_SIZE_LOWER_BOUND = 4096;
    private static final int BUFFER_SIZE_UPPER_BOUND = 65536;
    private Socket socket;
    private volatile boolean vCloseRequested = false;
    private CompletableFuture<SocketAddress> connectFuture = new CompletableFuture();

    public BlockingClient(SocketAddress serverAddress, StreamConnection connection, Duration connectTimeout, SocketFactory socketFactory, @Nullable Set<BlockingClient> clientSet) throws IOException {
        connection.setWriteTarget(this);
        this.socket = socketFactory.createSocket();
        Context context = Context.get();
        Thread t = new Thread(() -> {
            Context.propagate(context);
            if (clientSet != null) {
                clientSet.add(this);
            }
            try {
                this.socket.connect(serverAddress, Math.toIntExact(connectTimeout.toMillis()));
                connection.connectionOpened();
                this.connectFuture.complete(serverAddress);
                InputStream stream = this.socket.getInputStream();
                BlockingClient.runReadLoop(stream, connection);
            }
            catch (Exception e) {
                if (!this.vCloseRequested) {
                    log.error("Error trying to open/read from connection: {}: {}", (Object)serverAddress, (Object)e.getMessage());
                    this.connectFuture.completeExceptionally(e);
                }
            }
            finally {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {}
                if (clientSet != null) {
                    clientSet.remove(this);
                }
                connection.connectionClosed();
            }
        });
        t.setName("BlockingClient network thread for " + serverAddress);
        t.setDaemon(true);
        t.start();
    }

    public static void runReadLoop(InputStream stream, StreamConnection connection) throws Exception {
        ByteBuffer dbuf = ByteBuffer.allocateDirect(Math.min(Math.max(connection.getMaxMessageSize(), 4096), 65536));
        byte[] readBuff = new byte[dbuf.capacity()];
        while (true) {
            Preconditions.checkState(dbuf.remaining() > 0 && dbuf.remaining() <= readBuff.length);
            int read = stream.read(readBuff, 0, Math.max(1, Math.min(dbuf.remaining(), stream.available())));
            if (read == -1) {
                return;
            }
            dbuf.put(readBuff, 0, read);
            ((Buffer)dbuf).flip();
            int bytesConsumed = connection.receiveBytes(dbuf);
            Preconditions.checkState(dbuf.position() == bytesConsumed);
            dbuf.compact();
        }
    }

    @Override
    public void closeConnection() {
        try {
            this.vCloseRequested = true;
            this.socket.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized ListenableCompletableFuture<Void> writeBytes(byte[] message) throws IOException {
        try {
            OutputStream stream = this.socket.getOutputStream();
            stream.write(message);
            stream.flush();
            return ListenableCompletableFuture.completedFuture(null);
        }
        catch (IOException e) {
            log.error("Error writing message to connection, closing connection", e);
            this.closeConnection();
            throw e;
        }
    }

    public ListenableCompletableFuture<SocketAddress> getConnectFuture() {
        return ListenableCompletableFuture.of(this.connectFuture);
    }
}

