/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.net;

import com.google.common.util.concurrent.AbstractIdleService;
import java.io.IOException;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import javax.net.SocketFactory;
import org.bitcoinj.net.BlockingClient;
import org.bitcoinj.net.ClientConnectionManager;
import org.bitcoinj.net.StreamConnection;
import org.bitcoinj.utils.ListenableCompletableFuture;

public class BlockingClientManager
extends AbstractIdleService
implements ClientConnectionManager {
    private final SocketFactory socketFactory;
    private final Set<BlockingClient> clients = Collections.synchronizedSet(new HashSet());
    private Duration connectTimeout = Duration.ofSeconds(1L);

    public BlockingClientManager() {
        this.socketFactory = SocketFactory.getDefault();
    }

    public BlockingClientManager(SocketFactory socketFactory) {
        this.socketFactory = Objects.requireNonNull(socketFactory);
    }

    @Override
    public ListenableCompletableFuture<SocketAddress> openConnection(SocketAddress serverAddress, StreamConnection connection) {
        try {
            if (!this.isRunning()) {
                throw new IllegalStateException();
            }
            return new BlockingClient(serverAddress, connection, this.connectTimeout, this.socketFactory, this.clients).getConnectFuture();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Deprecated
    public void setConnectTimeoutMillis(int connectTimeoutMillis) {
        this.setConnectTimeout(Duration.ofMillis(connectTimeoutMillis));
    }

    protected void startUp() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutDown() throws Exception {
        Set<BlockingClient> set = this.clients;
        synchronized (set) {
            for (BlockingClient client : this.clients) {
                client.closeConnection();
            }
        }
    }

    @Override
    public int getConnectedClientCount() {
        return this.clients.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeConnections(int n) {
        if (!this.isRunning()) {
            throw new IllegalStateException();
        }
        Set<BlockingClient> set = this.clients;
        synchronized (set) {
            Iterator<BlockingClient> it = this.clients.iterator();
            while (n-- > 0 && it.hasNext()) {
                it.next().closeConnection();
            }
        }
    }
}

