/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.net;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.bitcoinj.base.internal.TimeUtils;
import org.bitcoinj.core.BloomFilter;
import org.bitcoinj.core.PeerFilterProvider;

public class FilterMerger {
    private final int bloomFilterTweak = new Random().nextInt();
    private volatile double vBloomFilterFPRate;
    private int lastBloomFilterElementCount;
    private BloomFilter lastFilter;

    public FilterMerger(double bloomFilterFPRate) {
        this.vBloomFilterFPRate = bloomFilterFPRate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result calculate(List<PeerFilterProvider> providerList) {
        List<PeerFilterProvider> providers = Collections.unmodifiableList(providerList);
        LinkedList<PeerFilterProvider> begunProviders = new LinkedList<PeerFilterProvider>();
        try {
            for (PeerFilterProvider provider : providers) {
                provider.beginBloomFilterCalculation();
                begunProviders.add(provider);
            }
            Result result = new Result();
            result.earliestKeyTime = Instant.MAX;
            int elements = 0;
            for (PeerFilterProvider p : providers) {
                result.earliestKeyTime = TimeUtils.earlier(result.earliestKeyTime, p.earliestKeyCreationTime());
                elements += p.getBloomFilterElementCount();
            }
            if (elements > 0) {
                this.lastBloomFilterElementCount = elements > this.lastBloomFilterElementCount ? elements + 100 : this.lastBloomFilterElementCount;
                double fpRate = this.vBloomFilterFPRate;
                BloomFilter filter2 = new BloomFilter(this.lastBloomFilterElementCount, fpRate, this.bloomFilterTweak, BloomFilter.BloomUpdate.UPDATE_ALL);
                for (PeerFilterProvider p : providers) {
                    filter2.merge(p.getBloomFilter(this.lastBloomFilterElementCount, fpRate, this.bloomFilterTweak));
                }
                result.changed = !filter2.equals(this.lastFilter);
                result.filter = this.lastFilter = filter2;
            }
            result.earliestKeyTime = result.earliestKeyTime.minus(7L, ChronoUnit.DAYS);
            Result result2 = result;
            return result2;
        }
        finally {
            for (PeerFilterProvider provider : begunProviders) {
                provider.endBloomFilterCalculation();
            }
        }
    }

    @Deprecated
    public void setBloomFilterFPRate(double bloomFilterFPRate) {
        this.vBloomFilterFPRate = bloomFilterFPRate;
    }

    public double getBloomFilterFPRate() {
        return this.vBloomFilterFPRate;
    }

    public BloomFilter getLastFilter() {
        return this.lastFilter;
    }

    public static class Result {
        public BloomFilter filter;
        public Instant earliestKeyTime;
        public boolean changed;
    }
}

