/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.net;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.time.Duration;
import org.bitcoinj.net.MessageWriteTarget;
import org.bitcoinj.net.NioClientManager;
import org.bitcoinj.net.SocketTimeoutTask;
import org.bitcoinj.net.StreamConnection;
import org.bitcoinj.net.TimeoutHandler;
import org.bitcoinj.utils.ListenableCompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NioClient
implements MessageWriteTarget {
    private static final Logger log = LoggerFactory.getLogger(NioClient.class);
    private final Handler handler;
    private final NioClientManager manager = new NioClientManager();

    public NioClient(SocketAddress serverAddress, StreamConnection parser, Duration connectTimeout) throws IOException {
        this.manager.startAsync();
        this.manager.awaitRunning();
        this.handler = new Handler(parser, connectTimeout);
        this.manager.openConnection(serverAddress, this.handler).whenComplete((result, t) -> {
            if (t != null) {
                log.error("Connect to {} failed: {}", (Object)serverAddress, (Object)Throwables.getRootCause((Throwable)t));
            }
        });
    }

    @Override
    public void closeConnection() {
        this.handler.writeTarget.closeConnection();
    }

    @Override
    public synchronized ListenableCompletableFuture<Void> writeBytes(byte[] message) throws IOException {
        return this.handler.writeTarget.writeBytes(message);
    }

    class Handler
    implements TimeoutHandler,
    StreamConnection {
        private final StreamConnection upstreamConnection;
        private final SocketTimeoutTask timeoutTask;
        private MessageWriteTarget writeTarget;
        private boolean closeOnOpen = false;
        private boolean closeCalled = false;

        Handler(StreamConnection upstreamConnection, Duration connectTimeout) {
            this.upstreamConnection = upstreamConnection;
            this.timeoutTask = new SocketTimeoutTask(this::timeoutOccurred);
            this.setSocketTimeout(connectTimeout);
            this.setTimeoutEnabled(true);
        }

        private synchronized void timeoutOccurred() {
            this.closeOnOpen = true;
            this.connectionClosed();
        }

        @Override
        public void setTimeoutEnabled(boolean timeoutEnabled) {
            this.timeoutTask.setTimeoutEnabled(timeoutEnabled);
        }

        @Override
        public void setSocketTimeout(Duration timeout2) {
            this.timeoutTask.setSocketTimeout(timeout2);
        }

        @Override
        public synchronized void connectionClosed() {
            NioClient.this.manager.stopAsync();
            if (!this.closeCalled) {
                this.closeCalled = true;
                this.upstreamConnection.connectionClosed();
            }
        }

        @Override
        public synchronized void connectionOpened() {
            if (!this.closeOnOpen) {
                this.upstreamConnection.connectionOpened();
            }
        }

        @Override
        public int receiveBytes(ByteBuffer buff) throws Exception {
            return this.upstreamConnection.receiveBytes(buff);
        }

        @Override
        public synchronized void setWriteTarget(MessageWriteTarget writeTarget) {
            if (this.closeOnOpen) {
                writeTarget.closeConnection();
            } else {
                this.setTimeoutEnabled(false);
                this.writeTarget = writeTarget;
                this.upstreamConnection.setWriteTarget(writeTarget);
            }
        }

        @Override
        public int getMaxMessageSize() {
            return this.upstreamConnection.getMaxMessageSize();
        }
    }
}

