/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.net;

import java.time.Duration;
import java.util.Timer;
import java.util.TimerTask;
import org.bitcoinj.net.TimeoutHandler;

public class SocketTimeoutTask
implements TimeoutHandler {
    private final Runnable actualTask;
    private TimerTask timeoutTask;
    private Duration timeout = Duration.ZERO;
    private boolean timeoutEnabled = true;
    private static final Timer timeoutTimer = new Timer("AbstractTimeoutHandler timeouts", true);

    public SocketTimeoutTask(Runnable actualTask) {
        this.actualTask = actualTask;
    }

    @Override
    public final synchronized void setTimeoutEnabled(boolean timeoutEnabled) {
        this.timeoutEnabled = timeoutEnabled;
        this.resetTimeout();
    }

    @Override
    public final synchronized void setSocketTimeout(Duration timeout2) {
        this.timeout = timeout2;
        this.resetTimeout();
    }

    @Deprecated
    synchronized void resetTimeout() {
        if (this.timeoutTask != null) {
            this.timeoutTask.cancel();
        }
        if (this.timeout.isZero() || !this.timeoutEnabled) {
            return;
        }
        this.timeoutTask = SocketTimeoutTask.timerTask(this.actualTask);
        timeoutTimer.schedule(this.timeoutTask, this.timeout.toMillis());
    }

    private static TimerTask timerTask(final Runnable r) {
        return new TimerTask(){

            @Override
            public void run() {
                r.run();
            }
        };
    }
}

