/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.net.discovery;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.bitcoinj.base.Network;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Services;
import org.bitcoinj.net.discovery.MultiplexingDiscovery;
import org.bitcoinj.net.discovery.PeerDiscovery;
import org.bitcoinj.net.discovery.PeerDiscoveryException;
import org.bitcoinj.utils.DaemonThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsDiscovery
extends MultiplexingDiscovery {
    private static final Logger log = LoggerFactory.getLogger(DnsDiscovery.class);

    public DnsDiscovery(Network network) {
        this(NetworkParameters.of(network).getDnsSeeds(), network);
    }

    public DnsDiscovery(String[] dnsSeeds, Network network) {
        super(network, DnsDiscovery.buildDiscoveries(network, dnsSeeds));
    }

    @Deprecated
    public DnsDiscovery(NetworkParameters netParams) {
        this(netParams.getDnsSeeds(), netParams.network());
    }

    @Deprecated
    public DnsDiscovery(String[] dnsSeeds, NetworkParameters params) {
        this(dnsSeeds, params.network());
    }

    private static List<PeerDiscovery> buildDiscoveries(Network network, String[] seeds) {
        ArrayList<PeerDiscovery> discoveries = new ArrayList<PeerDiscovery>();
        if (seeds != null) {
            for (String seed : seeds) {
                discoveries.add(new DnsSeedDiscovery(network, seed));
            }
        }
        return discoveries;
    }

    @Override
    protected ExecutorService createExecutor() {
        return Executors.newFixedThreadPool(this.seeds.size(), new DaemonThreadFactory("DNS seed lookups"));
    }

    public static class DnsSeedDiscovery
    implements PeerDiscovery {
        private final String hostname;
        private final NetworkParameters params;

        public DnsSeedDiscovery(Network network, String hostname) {
            this.hostname = hostname;
            this.params = NetworkParameters.of(network);
        }

        @Deprecated
        public DnsSeedDiscovery(NetworkParameters params, String hostname) {
            this(params.network(), hostname);
        }

        @Override
        public List<InetSocketAddress> getPeers(long services, Duration timeout2) throws PeerDiscoveryException {
            InetAddress[] response = null;
            if (services != 0L) {
                String hostnameWithServices = "x" + Long.toHexString(services) + "." + this.hostname;
                log.info("Requesting {} peers from {}", (Object)Services.of(services).toString(), (Object)hostnameWithServices);
                try {
                    response = InetAddress.getAllByName(hostnameWithServices);
                    log.info("Got {} peers from {}", (Object)response.length, (Object)hostnameWithServices);
                }
                catch (UnknownHostException e) {
                    log.info("Seed {} doesn't appear to support service bit filtering: {}", (Object)this.hostname, (Object)e.getMessage());
                }
            }
            if (response == null || response.length == 0) {
                log.info("Requesting all peers from {}", (Object)this.hostname);
                try {
                    response = InetAddress.getAllByName(this.hostname);
                    log.info("Got {} peers from {}", (Object)response.length, (Object)this.hostname);
                }
                catch (UnknownHostException e) {
                    throw new PeerDiscoveryException(e);
                }
            }
            ArrayList<InetSocketAddress> result = new ArrayList<InetSocketAddress>(response.length);
            for (InetAddress r : response) {
                result.add(new InetSocketAddress(r, this.params.getPort()));
            }
            return result;
        }

        @Override
        public void shutdown() {
        }

        public String toString() {
            return this.hostname;
        }
    }
}

