/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.net.discovery;

import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.bitcoinj.base.BitcoinNetwork;
import org.bitcoinj.base.Network;
import org.bitcoinj.base.internal.Preconditions;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.net.discovery.DnsDiscovery;
import org.bitcoinj.net.discovery.PeerDiscovery;
import org.bitcoinj.net.discovery.PeerDiscoveryException;
import org.bitcoinj.utils.ContextPropagatingThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiplexingDiscovery
implements PeerDiscovery {
    private static final Logger log = LoggerFactory.getLogger(MultiplexingDiscovery.class);
    protected final List<PeerDiscovery> seeds;
    @Deprecated
    protected final NetworkParameters netParams;
    private volatile ExecutorService vThreadPool;
    private final boolean parallelQueries;
    private final boolean shufflePeers;

    public static MultiplexingDiscovery forServices(Network network, long services) {
        return MultiplexingDiscovery.forServices(network, services, true, true);
    }

    public static MultiplexingDiscovery forServices(Network network, long services, boolean parallelQueries, boolean shufflePeers) {
        ArrayList<PeerDiscovery> discoveries = new ArrayList<PeerDiscovery>();
        String[] dnsSeeds = NetworkParameters.of(network).getDnsSeeds();
        if (dnsSeeds != null) {
            for (String dnsSeed : dnsSeeds) {
                discoveries.add(new DnsDiscovery.DnsSeedDiscovery(network, dnsSeed));
            }
        }
        return new MultiplexingDiscovery(network, discoveries, parallelQueries, shufflePeers);
    }

    @Deprecated
    public static MultiplexingDiscovery forServices(NetworkParameters params, long services) {
        return MultiplexingDiscovery.forServices(params.network(), services);
    }

    @Deprecated
    public static MultiplexingDiscovery forServices(NetworkParameters params, long services, boolean parallelQueries, boolean shufflePeers) {
        return MultiplexingDiscovery.forServices(params.network(), services, parallelQueries, shufflePeers);
    }

    public MultiplexingDiscovery(Network network, List<PeerDiscovery> seeds) {
        this(network, seeds, true, true);
    }

    @Deprecated
    public MultiplexingDiscovery(NetworkParameters params, List<PeerDiscovery> seeds) {
        this(params.network(), seeds);
    }

    private MultiplexingDiscovery(Network network, List<PeerDiscovery> seeds, boolean parallelQueries, boolean shufflePeers) {
        Preconditions.checkArgument(!seeds.isEmpty() || network == BitcoinNetwork.REGTEST);
        this.netParams = NetworkParameters.of(network);
        this.seeds = seeds;
        this.parallelQueries = parallelQueries;
        this.shufflePeers = shufflePeers;
    }

    @Override
    public List<InetSocketAddress> getPeers(long services, Duration timeout2) throws PeerDiscoveryException {
        this.vThreadPool = this.createExecutor();
        try {
            ArrayList<Callable<List>> tasks = new ArrayList<Callable<List>>();
            if (this.parallelQueries) {
                for (PeerDiscovery seed : this.seeds) {
                    tasks.add(() -> seed.getPeers(services, timeout2));
                }
            } else {
                tasks.add(() -> {
                    LinkedList<InetSocketAddress> peers = new LinkedList<InetSocketAddress>();
                    for (PeerDiscovery seed : this.seeds) {
                        peers.addAll(seed.getPeers(services, timeout2));
                    }
                    return peers;
                });
            }
            List futures = this.vThreadPool.invokeAll(tasks, timeout2.toMillis(), TimeUnit.MILLISECONDS);
            ArrayList<InetSocketAddress> addrs = new ArrayList<InetSocketAddress>();
            for (int i2 = 0; i2 < futures.size(); ++i2) {
                List inetAddresses;
                Future future = futures.get(i2);
                if (future.isCancelled()) {
                    log.warn("Seed {}: timed out", this.parallelQueries ? this.seeds.get(i2) : "any");
                    continue;
                }
                try {
                    inetAddresses = (List)future.get();
                }
                catch (ExecutionException e) {
                    log.warn("Seed {}: failed to look up: {}", this.parallelQueries ? this.seeds.get(i2) : "any", (Object)e.getMessage());
                    continue;
                }
                addrs.addAll(inetAddresses);
            }
            if (addrs.size() == 0) {
                throw new PeerDiscoveryException("No peer discovery returned any results in " + timeout2.toMillis() + " ms. Check internet connection?");
            }
            if (this.shufflePeers) {
                Collections.shuffle(addrs);
            }
            this.vThreadPool.shutdownNow();
            ArrayList<InetSocketAddress> arrayList = addrs;
            return arrayList;
        }
        catch (InterruptedException e) {
            throw new PeerDiscoveryException(e);
        }
        finally {
            this.vThreadPool.shutdown();
        }
    }

    protected ExecutorService createExecutor() {
        return Executors.newFixedThreadPool(this.seeds.size(), new ContextPropagatingThreadFactory("Multiplexing discovery"));
    }

    @Override
    public void shutdown() {
        ExecutorService tp = this.vThreadPool;
        if (tp != null) {
            tp.shutdown();
        }
    }
}

