/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.net.discovery;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.net.discovery.PeerDiscovery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeedPeers
implements PeerDiscovery {
    private final List<InetSocketAddress> seedAddrs;
    private int pnseedIndex;
    private static final Logger log = LoggerFactory.getLogger(SeedPeers.class);

    public SeedPeers(InetSocketAddress[] seedAddrs) {
        this.seedAddrs = Arrays.asList(seedAddrs);
    }

    @Deprecated
    public SeedPeers(NetworkParameters params) {
        this(params.getAddrSeeds(), params);
    }

    @Deprecated
    public SeedPeers(int[] seedAddrInts, NetworkParameters params) {
        this.seedAddrs = new LinkedList<InetSocketAddress>();
        if (seedAddrInts == null) {
            return;
        }
        for (int seedAddrInt : seedAddrInts) {
            try {
                InetSocketAddress seedAddr = new InetSocketAddress(SeedPeers.convertAddress(seedAddrInt), params.getPort());
                this.seedAddrs.add(seedAddr);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
    }

    @Nullable
    public InetSocketAddress getPeer() {
        return this.nextPeer();
    }

    @Nullable
    private InetSocketAddress nextPeer() {
        if (this.pnseedIndex >= this.seedAddrs.size()) {
            return null;
        }
        return this.seedAddrs.get(this.pnseedIndex++);
    }

    @Override
    public List<InetSocketAddress> getPeers(long services, Duration timeout2) {
        if (services != 0L) {
            log.info("Pre-determined peers cannot be filtered by services: {}", (Object)services);
        }
        return Collections.unmodifiableList(this.seedAddrs);
    }

    @Override
    public void shutdown() {
    }

    private static InetAddress convertAddress(int seed) throws UnknownHostException {
        byte[] v4addr = ByteBuffer.allocate(4).putInt(seed).array();
        return InetAddress.getByAddress(v4addr);
    }
}

