/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.params;

import java.math.BigInteger;
import javax.annotation.Nullable;
import org.bitcoinj.base.BitcoinNetwork;
import org.bitcoinj.base.Coin;
import org.bitcoinj.base.Sha256Hash;
import org.bitcoinj.base.internal.ByteUtils;
import org.bitcoinj.base.internal.Preconditions;
import org.bitcoinj.base.internal.Stopwatch;
import org.bitcoinj.base.utils.MonetaryFormat;
import org.bitcoinj.core.BitcoinSerializer;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.StoredBlock;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.params.MainNetParams;
import org.bitcoinj.params.RegTestParams;
import org.bitcoinj.params.SigNetParams;
import org.bitcoinj.params.TestNet3Params;
import org.bitcoinj.protocols.payments.PaymentProtocol;
import org.bitcoinj.store.BlockStore;
import org.bitcoinj.store.BlockStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BitcoinNetworkParams
extends NetworkParameters {
    @Deprecated
    public static final String BITCOIN_SCHEME = "bitcoin";
    public static final int REWARD_HALVING_INTERVAL = 210000;
    private static final Logger log = LoggerFactory.getLogger(BitcoinNetworkParams.class);
    protected Block genesisBlock;

    public BitcoinNetworkParams(BitcoinNetwork network) {
        super(network);
        this.interval = 2016;
        this.subsidyDecreaseBlockCount = 210000;
    }

    @Nullable
    public static BitcoinNetworkParams fromID(String id) {
        if (id.equals(BitcoinNetwork.ID_MAINNET)) {
            return MainNetParams.get();
        }
        if (id.equals(BitcoinNetwork.ID_TESTNET)) {
            return TestNet3Params.get();
        }
        if (id.equals(BitcoinNetwork.ID_SIGNET)) {
            return SigNetParams.get();
        }
        if (id.equals(BitcoinNetwork.ID_REGTEST)) {
            return RegTestParams.get();
        }
        return null;
    }

    public static BitcoinNetworkParams of(BitcoinNetwork network) {
        switch (network) {
            case MAINNET: {
                return MainNetParams.get();
            }
            case TESTNET: {
                return TestNet3Params.get();
            }
            case SIGNET: {
                return SigNetParams.get();
            }
            case REGTEST: {
                return RegTestParams.get();
            }
        }
        throw new IllegalArgumentException("Unknown network");
    }

    @Override
    @Deprecated
    public String getPaymentProtocolId() {
        return PaymentProtocol.protocolIdFromParams(this);
    }

    public final boolean isRewardHalvingPoint(int previousHeight) {
        return (previousHeight + 1) % 210000 == 0;
    }

    public Coin getBlockInflation(int height) {
        return Coin.FIFTY_COINS.shiftRight(height / this.getSubsidyDecreaseBlockCount());
    }

    public final boolean isDifficultyTransitionPoint(int previousHeight) {
        return (previousHeight + 1) % this.getInterval() == 0;
    }

    @Override
    public void checkDifficultyTransitions(StoredBlock storedPrev, Block nextBlock, BlockStore blockStore) throws VerificationException, BlockStoreException {
        BigInteger maxTarget;
        int targetTimespan;
        Block prev = storedPrev.getHeader();
        if (!this.isDifficultyTransitionPoint(storedPrev.getHeight())) {
            if (nextBlock.getDifficultyTarget() != prev.getDifficultyTarget()) {
                throw new VerificationException("Unexpected change in difficulty at height " + storedPrev.getHeight() + ": " + Long.toHexString(nextBlock.getDifficultyTarget()) + " vs " + Long.toHexString(prev.getDifficultyTarget()));
            }
            return;
        }
        Stopwatch watch = Stopwatch.start();
        Sha256Hash hash = prev.getHash();
        StoredBlock cursor = null;
        int interval = this.getInterval();
        for (int i2 = 0; i2 < interval; ++i2) {
            cursor = blockStore.get(hash);
            if (cursor == null) {
                throw new VerificationException("Difficulty transition point but we did not find a way back to the last transition point. Not found: " + hash);
            }
            hash = cursor.getHeader().getPrevBlockHash();
        }
        Preconditions.checkState(cursor != null && this.isDifficultyTransitionPoint(cursor.getHeight() - 1), () -> "didn't arrive at a transition point");
        watch.stop();
        if (watch.elapsed().toMillis() > 50L) {
            log.info("Difficulty transition traversal took {}", (Object)watch);
        }
        Block blockIntervalAgo = cursor.getHeader();
        int timespan = (int)(prev.time().getEpochSecond() - blockIntervalAgo.time().getEpochSecond());
        if (timespan < (targetTimespan = this.getTargetTimespan()) / 4) {
            timespan = targetTimespan / 4;
        }
        if (timespan > targetTimespan * 4) {
            timespan = targetTimespan * 4;
        }
        BigInteger newTarget = ByteUtils.decodeCompactBits(prev.getDifficultyTarget());
        newTarget = newTarget.multiply(BigInteger.valueOf(timespan));
        if ((newTarget = newTarget.divide(BigInteger.valueOf(targetTimespan))).compareTo(maxTarget = this.getMaxTarget()) > 0) {
            log.info("Difficulty hit proof of work limit: {} vs {}", (Object)Long.toHexString(ByteUtils.encodeCompactBits(newTarget)), (Object)Long.toHexString(ByteUtils.encodeCompactBits(maxTarget)));
            newTarget = maxTarget;
        }
        int accuracyBytes = (int)(nextBlock.getDifficultyTarget() >>> 24) - 3;
        long receivedTargetCompact = nextBlock.getDifficultyTarget();
        BigInteger mask = BigInteger.valueOf(0xFFFFFFL).shiftLeft(accuracyBytes * 8);
        long newTargetCompact = ByteUtils.encodeCompactBits(newTarget = newTarget.and(mask));
        if (newTargetCompact != receivedTargetCompact) {
            throw new VerificationException("Network provided difficulty bits do not match what was calculated: " + Long.toHexString(newTargetCompact) + " vs " + Long.toHexString(receivedTargetCompact));
        }
    }

    @Override
    @Deprecated
    public Coin getMaxMoney() {
        return BitcoinNetwork.MAX_MONEY;
    }

    @Override
    @Deprecated
    public MonetaryFormat getMonetaryFormat() {
        return new MonetaryFormat();
    }

    @Override
    public BitcoinSerializer getSerializer() {
        return new BitcoinSerializer(this.network);
    }

    @Override
    @Deprecated
    public String getUriScheme() {
        return BITCOIN_SCHEME;
    }

    @Override
    @Deprecated
    public boolean hasMaxMoney() {
        return this.network().hasMaxMoney();
    }
}

