/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.params;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.bitcoinj.base.Network;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.params.MainNetParams;
import org.bitcoinj.params.TestNet3Params;

public class Networks {
    private static Set<NetworkParameters> networks = Networks.unmodifiableSet(TestNet3Params.get(), MainNetParams.get());

    public static Set<NetworkParameters> get() {
        return networks;
    }

    public static Optional<NetworkParameters> find(Network network) {
        return networks.stream().filter(p -> p.getId().equals(network.id())).findFirst();
    }

    public static void register(NetworkParameters network) {
        Networks.register(Collections.singleton(network));
    }

    public static void register(Collection<NetworkParameters> networks) {
        Networks.networks = Networks.combinedSet(Networks.networks, networks);
    }

    public static void unregister(NetworkParameters network) {
        networks = Networks.removeFromSet(networks, network);
    }

    private static Set<NetworkParameters> unmodifiableSet(NetworkParameters ... ts) {
        return Collections.unmodifiableSet(new HashSet<NetworkParameters>(Arrays.asList(ts)));
    }

    private static <T> Set<T> combinedSet(Collection<T> a, Collection<T> b) {
        HashSet<T> tempSet = new HashSet<T>(a);
        tempSet.addAll(b);
        return Collections.unmodifiableSet(tempSet);
    }

    private static <T> Set<T> removeFromSet(Set<T> set, T item) {
        HashSet<T> tempSet = new HashSet<T>(set);
        tempSet.remove(item);
        return Collections.unmodifiableSet(tempSet);
    }
}

