/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.params;

import java.time.Instant;
import org.bitcoinj.base.BitcoinNetwork;
import org.bitcoinj.base.Sha256Hash;
import org.bitcoinj.base.internal.ByteUtils;
import org.bitcoinj.base.internal.Preconditions;
import org.bitcoinj.core.Block;
import org.bitcoinj.params.BitcoinNetworkParams;

public class RegTestParams
extends BitcoinNetworkParams {
    private static final Instant GENESIS_TIME = Instant.ofEpochSecond(1296688602L);
    private static final long GENESIS_NONCE = 2L;
    private static final Sha256Hash GENESIS_HASH = Sha256Hash.wrap("0f9188f13cb7b2c71f2a335e3a4fc328bf5beb436012afca590b1a11466e2206");
    private static RegTestParams instance;

    public RegTestParams() {
        super(BitcoinNetwork.REGTEST);
        this.targetTimespan = 1209600;
        this.maxTarget = ByteUtils.decodeCompactBits(545259519L);
        this.interval = Integer.MAX_VALUE;
        this.subsidyDecreaseBlockCount = 150;
        this.port = 18444;
        this.packetMagic = -88099366;
        this.dumpedPrivateKeyHeader = 239;
        this.addressHeader = 111;
        this.p2shHeader = 196;
        this.segwitAddressHrp = "bcrt";
        this.spendableCoinbaseDepth = 100;
        this.bip32HeaderP2PKHpub = 70617039;
        this.bip32HeaderP2PKHpriv = 70615956;
        this.bip32HeaderP2WPKHpub = 73342198;
        this.bip32HeaderP2WPKHpriv = 73341116;
        this.majorityEnforceBlockUpgrade = 750;
        this.majorityRejectBlockOutdated = 950;
        this.majorityWindow = 1000;
        this.dnsSeeds = null;
        this.addrSeeds = null;
    }

    @Override
    public boolean allowEmptyPeerChain() {
        return true;
    }

    public static synchronized RegTestParams get() {
        if (instance == null) {
            instance = new RegTestParams();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Block getGenesisBlock() {
        Sha256Hash sha256Hash = GENESIS_HASH;
        synchronized (sha256Hash) {
            if (this.genesisBlock == null) {
                this.genesisBlock = Block.createGenesis(GENESIS_TIME, 545259519L, 2L);
                Preconditions.checkState(this.genesisBlock.getHash().equals(GENESIS_HASH), () -> "invalid genesis hash");
            }
        }
        return this.genesisBlock;
    }
}

