/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.params;

import java.time.Instant;
import org.bitcoinj.base.BitcoinNetwork;
import org.bitcoinj.base.Sha256Hash;
import org.bitcoinj.base.internal.ByteUtils;
import org.bitcoinj.base.internal.Preconditions;
import org.bitcoinj.core.Block;
import org.bitcoinj.params.BitcoinNetworkParams;

public class SigNetParams
extends BitcoinNetworkParams {
    public static final int TESTNET_MAJORITY_WINDOW = 100;
    public static final int TESTNET_MAJORITY_REJECT_BLOCK_OUTDATED = 75;
    public static final int TESTNET_MAJORITY_ENFORCE_BLOCK_UPGRADE = 51;
    private static final long GENESIS_DIFFICULTY = 503543726L;
    private static final Instant GENESIS_TIME = Instant.ofEpochSecond(1598918400L);
    private static final long GENESIS_NONCE = 52613770L;
    private static final Sha256Hash GENESIS_HASH = Sha256Hash.wrap("00000008819873e925422c1ff0f99f7cc9bbb232af63a077a480a3633bee1ef6");
    private static SigNetParams instance;

    public SigNetParams() {
        super(BitcoinNetwork.SIGNET);
        this.targetTimespan = 1209600;
        this.maxTarget = ByteUtils.decodeCompactBits(545259519L);
        this.port = 38333;
        this.packetMagic = 168021824;
        this.dumpedPrivateKeyHeader = 239;
        this.addressHeader = 111;
        this.p2shHeader = 196;
        this.segwitAddressHrp = "tb";
        this.spendableCoinbaseDepth = 100;
        this.bip32HeaderP2PKHpub = 70617039;
        this.bip32HeaderP2PKHpriv = 70615956;
        this.bip32HeaderP2WPKHpub = this.bip32HeaderP2PKHpub;
        this.bip32HeaderP2WPKHpriv = this.bip32HeaderP2PKHpriv;
        this.majorityEnforceBlockUpgrade = 51;
        this.majorityRejectBlockOutdated = 75;
        this.majorityWindow = 100;
        this.dnsSeeds = new String[]{"seed.signet.bitcoin.sprovoost.nl", "seed.signet.achownodes.xyz"};
        this.addrSeeds = null;
    }

    public static synchronized SigNetParams get() {
        if (instance == null) {
            instance = new SigNetParams();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Block getGenesisBlock() {
        Sha256Hash sha256Hash = GENESIS_HASH;
        synchronized (sha256Hash) {
            if (this.genesisBlock == null) {
                this.genesisBlock = Block.createGenesis(GENESIS_TIME, 503543726L, 52613770L);
                Preconditions.checkState(this.genesisBlock.getHash().equals(GENESIS_HASH), () -> "invalid genesis hash");
            }
        }
        return this.genesisBlock;
    }
}

