/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.params;

import java.math.BigInteger;
import java.time.Instant;
import org.bitcoinj.base.BitcoinNetwork;
import org.bitcoinj.base.Sha256Hash;
import org.bitcoinj.base.internal.ByteUtils;
import org.bitcoinj.base.internal.Preconditions;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.StoredBlock;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.params.BitcoinNetworkParams;
import org.bitcoinj.store.BlockStore;
import org.bitcoinj.store.BlockStoreException;

public class TestNet3Params
extends BitcoinNetworkParams {
    public static final int TESTNET_MAJORITY_WINDOW = 100;
    public static final int TESTNET_MAJORITY_REJECT_BLOCK_OUTDATED = 75;
    public static final int TESTNET_MAJORITY_ENFORCE_BLOCK_UPGRADE = 51;
    private static final Instant GENESIS_TIME = Instant.ofEpochSecond(1296688602L);
    private static final long GENESIS_NONCE = 414098458L;
    private static final Sha256Hash GENESIS_HASH = Sha256Hash.wrap("000000000933ea01ad0ee984209779baaec3ced90fa3f408719526f8d77f4943");
    private static TestNet3Params instance;
    private static final Instant testnetDiffDate;

    public TestNet3Params() {
        super(BitcoinNetwork.TESTNET);
        this.targetTimespan = 1209600;
        this.maxTarget = ByteUtils.decodeCompactBits(486604799L);
        this.port = 18333;
        this.packetMagic = 185665799;
        this.dumpedPrivateKeyHeader = 239;
        this.addressHeader = 111;
        this.p2shHeader = 196;
        this.segwitAddressHrp = "tb";
        this.spendableCoinbaseDepth = 100;
        this.bip32HeaderP2PKHpub = 70617039;
        this.bip32HeaderP2PKHpriv = 70615956;
        this.bip32HeaderP2WPKHpub = 73342198;
        this.bip32HeaderP2WPKHpriv = 73341116;
        this.majorityEnforceBlockUpgrade = 51;
        this.majorityRejectBlockOutdated = 75;
        this.majorityWindow = 100;
        this.dnsSeeds = new String[]{"testnet-seed.bitcoin.jonasschnelli.ch", "seed.tbtc.petertodd.net", "seed.testnet.bitcoin.sprovoost.nl", "testnet-seed.bluematt.me", "seed.testnet.achownodes.xyz"};
        this.addrSeeds = null;
    }

    public static synchronized TestNet3Params get() {
        if (instance == null) {
            instance = new TestNet3Params();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Block getGenesisBlock() {
        Sha256Hash sha256Hash = GENESIS_HASH;
        synchronized (sha256Hash) {
            if (this.genesisBlock == null) {
                this.genesisBlock = Block.createGenesis(GENESIS_TIME, 486604799L, 414098458L);
                Preconditions.checkState(this.genesisBlock.getHash().equals(GENESIS_HASH), () -> "invalid genesis hash");
            }
        }
        return this.genesisBlock;
    }

    @Override
    public void checkDifficultyTransitions(StoredBlock storedPrev, Block nextBlock, BlockStore blockStore) throws VerificationException, BlockStoreException {
        if (!this.isDifficultyTransitionPoint(storedPrev.getHeight()) && nextBlock.time().isAfter(testnetDiffDate)) {
            Block prev = storedPrev.getHeader();
            long timeDelta = nextBlock.time().getEpochSecond() - prev.time().getEpochSecond();
            if (timeDelta >= 0L && timeDelta <= 1200L) {
                BigInteger newTarget;
                StoredBlock cursor = storedPrev;
                while (!cursor.getHeader().equals(this.getGenesisBlock()) && cursor.getHeight() % this.getInterval() != 0 && cursor.getHeader().getDifficultyTargetAsInteger().equals(this.getMaxTarget())) {
                    cursor = cursor.getPrev(blockStore);
                }
                BigInteger cursorTarget = cursor.getHeader().getDifficultyTargetAsInteger();
                if (!cursorTarget.equals(newTarget = nextBlock.getDifficultyTargetAsInteger())) {
                    throw new VerificationException("Testnet block transition that is not allowed: " + Long.toHexString(cursor.getHeader().getDifficultyTarget()) + " vs " + Long.toHexString(nextBlock.getDifficultyTarget()));
                }
            }
        } else {
            super.checkDifficultyTransitions(storedPrev, nextBlock, blockStore);
        }
    }

    static {
        testnetDiffDate = Instant.ofEpochMilli(1329264000000L);
    }
}

