/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.params;

import org.bitcoinj.base.BitcoinNetwork;
import org.bitcoinj.base.internal.ByteUtils;
import org.bitcoinj.base.internal.TimeUtils;
import org.bitcoinj.core.Block;
import org.bitcoinj.params.BitcoinNetworkParams;

public class UnitTestParams
extends BitcoinNetworkParams {
    public static final int UNITNET_MAJORITY_WINDOW = 8;
    public static final int TESTNET_MAJORITY_REJECT_BLOCK_OUTDATED = 6;
    public static final int TESTNET_MAJORITY_ENFORCE_BLOCK_UPGRADE = 4;
    private static UnitTestParams instance;

    public UnitTestParams() {
        super(BitcoinNetwork.TESTNET);
        this.targetTimespan = 200000000;
        this.maxTarget = ByteUtils.decodeCompactBits(545259519L);
        this.interval = 10;
        this.subsidyDecreaseBlockCount = 100;
        this.port = 18333;
        this.packetMagic = 185665799;
        this.dumpedPrivateKeyHeader = 239;
        this.addressHeader = 111;
        this.p2shHeader = 196;
        this.segwitAddressHrp = "tb";
        this.spendableCoinbaseDepth = 5;
        this.bip32HeaderP2PKHpub = 70617039;
        this.bip32HeaderP2PKHpriv = 70615956;
        this.bip32HeaderP2WPKHpub = 73342198;
        this.bip32HeaderP2WPKHpriv = 73341116;
        this.majorityEnforceBlockUpgrade = 3;
        this.majorityRejectBlockOutdated = 4;
        this.majorityWindow = 7;
        this.dnsSeeds = null;
        this.addrSeeds = null;
    }

    public static synchronized UnitTestParams get() {
        if (instance == null) {
            instance = new UnitTestParams();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Block getGenesisBlock() {
        UnitTestParams unitTestParams = this;
        synchronized (unitTestParams) {
            if (this.genesisBlock == null) {
                this.genesisBlock = Block.createGenesis(TimeUtils.currentTime(), 545259519L);
            }
        }
        return this.genesisBlock;
    }
}

