/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.protocols.payments;

import com.google.common.base.MoreObjects;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.bitcoinj.base.Address;
import org.bitcoinj.base.Coin;
import org.bitcoinj.base.internal.TimeUtils;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.crypto.X509Utils;
import org.bitcoinj.params.BitcoinNetworkParams;
import org.bitcoinj.params.MainNetParams;
import org.bitcoinj.params.RegTestParams;
import org.bitcoinj.params.SigNetParams;
import org.bitcoinj.params.TestNet3Params;
import org.bitcoinj.params.UnitTestParams;
import org.bitcoinj.protobuf.payments.Protos;
import org.bitcoinj.protocols.payments.PaymentProtocolException;
import org.bitcoinj.protocols.payments.PaymentSession;
import org.bitcoinj.script.ScriptBuilder;

public class PaymentProtocol {
    public static final String MIMETYPE_PAYMENTREQUEST = "application/bitcoin-paymentrequest";
    public static final String MIMETYPE_PAYMENT = "application/bitcoin-payment";
    public static final String MIMETYPE_PAYMENTACK = "application/bitcoin-paymentack";
    public static final String PAYMENT_PROTOCOL_ID_MAINNET = "main";
    public static final String PAYMENT_PROTOCOL_ID_TESTNET = "test";
    public static final String PAYMENT_PROTOCOL_ID_SIGNET = "signet";
    public static final String PAYMENT_PROTOCOL_ID_UNIT_TESTS = "unittest";
    public static final String PAYMENT_PROTOCOL_ID_REGTEST = "regtest";

    public static Protos.PaymentRequest.Builder createPaymentRequest(NetworkParameters params, @Nullable Coin amount, Address toAddress, @Nullable String memo, @Nullable String paymentUrl, @Nullable byte[] merchantData) {
        return PaymentProtocol.createPaymentRequest(params, Collections.singletonList(PaymentProtocol.createPayToAddressOutput(amount, toAddress)), memo, paymentUrl, merchantData);
    }

    public static Protos.PaymentRequest.Builder createPaymentRequest(NetworkParameters params, List<Protos.Output> outputs, @Nullable String memo, @Nullable String paymentUrl, @Nullable byte[] merchantData) {
        Protos.PaymentDetails.Builder paymentDetails = Protos.PaymentDetails.newBuilder();
        paymentDetails.setNetwork(PaymentProtocol.protocolIdFromParams(params));
        for (Protos.Output output : outputs) {
            paymentDetails.addOutputs(output);
        }
        if (memo != null) {
            paymentDetails.setMemo(memo);
        }
        if (paymentUrl != null) {
            paymentDetails.setPaymentUrl(paymentUrl);
        }
        if (merchantData != null) {
            paymentDetails.setMerchantData(ByteString.copyFrom(merchantData));
        }
        paymentDetails.setTime(TimeUtils.currentTime().getEpochSecond());
        Protos.PaymentRequest.Builder paymentRequest = Protos.PaymentRequest.newBuilder();
        paymentRequest.setSerializedPaymentDetails(((Protos.PaymentDetails)paymentDetails.build()).toByteString());
        return paymentRequest;
    }

    public static PaymentSession parsePaymentRequest(Protos.PaymentRequest paymentRequest) throws PaymentProtocolException {
        return new PaymentSession(paymentRequest, false, null);
    }

    public static void signPaymentRequest(Protos.PaymentRequest.Builder paymentRequest, X509Certificate[] certificateChain, PrivateKey privateKey) {
        try {
            Protos.X509Certificates.Builder certificates = Protos.X509Certificates.newBuilder();
            for (X509Certificate certificate : certificateChain) {
                certificates.addCertificate(ByteString.copyFrom(certificate.getEncoded()));
            }
            paymentRequest.setPkiType("x509+sha256");
            paymentRequest.setPkiData(((Protos.X509Certificates)certificates.build()).toByteString());
            paymentRequest.setSignature(ByteString.EMPTY);
            Protos.PaymentRequest paymentRequestToSign = (Protos.PaymentRequest)paymentRequest.build();
            if (!"RSA".equalsIgnoreCase(privateKey.getAlgorithm())) {
                throw new IllegalStateException(privateKey.getAlgorithm());
            }
            String algorithm = "SHA256withRSA";
            Signature signature = Signature.getInstance(algorithm);
            signature.initSign(privateKey);
            signature.update(paymentRequestToSign.toByteArray());
            paymentRequest.setSignature(ByteString.copyFrom(signature.sign()));
        }
        catch (GeneralSecurityException x) {
            throw new RuntimeException(x);
        }
    }

    @Nullable
    public static PkiVerificationData verifyPaymentRequestPki(Protos.PaymentRequest paymentRequest, KeyStore trustStore) throws PaymentProtocolException {
        ArrayList<X509Certificate> certs = null;
        try {
            String algorithm;
            String pkiType = paymentRequest.getPkiType();
            if ("none".equals(pkiType)) {
                return null;
            }
            if ("x509+sha256".equals(pkiType)) {
                algorithm = "SHA256withRSA";
            } else if ("x509+sha1".equals(pkiType)) {
                algorithm = "SHA1withRSA";
            } else {
                throw new PaymentProtocolException.InvalidPkiType("Unsupported PKI type: " + pkiType);
            }
            Protos.X509Certificates protoCerts = Protos.X509Certificates.parseFrom(paymentRequest.getPkiData());
            if (protoCerts.getCertificateCount() == 0) {
                throw new PaymentProtocolException.InvalidPkiData("No certificates provided in message: server config error");
            }
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            certs = new ArrayList<X509Certificate>();
            for (ByteString bytes : protoCerts.getCertificateList()) {
                certs.add((X509Certificate)certificateFactory.generateCertificate(bytes.newInput()));
            }
            CertPath path = certificateFactory.generateCertPath(certs);
            PKIXParameters params = new PKIXParameters(trustStore);
            params.setRevocationEnabled(false);
            CertPathValidator validator = CertPathValidator.getInstance("PKIX");
            PKIXCertPathValidatorResult result = (PKIXCertPathValidatorResult)validator.validate(path, params);
            PublicKey publicKey = result.getPublicKey();
            Signature signature = Signature.getInstance(algorithm);
            signature.initVerify(publicKey);
            Protos.PaymentRequest.Builder reqToCheck = (Protos.PaymentRequest.Builder)paymentRequest.toBuilder();
            reqToCheck.setSignature(ByteString.EMPTY);
            signature.update(((Protos.PaymentRequest)reqToCheck.build()).toByteArray());
            if (!signature.verify(paymentRequest.getSignature().toByteArray())) {
                throw new PaymentProtocolException.PkiVerificationException("Invalid signature, this payment request is not valid.");
            }
            X509Certificate cert = (X509Certificate)certs.get(0);
            String displayName = X509Utils.getDisplayNameFromCertificate(cert, true);
            if (displayName == null) {
                throw new PaymentProtocolException.PkiVerificationException("Could not extract name from certificate");
            }
            return new PkiVerificationData(displayName, publicKey, result.getTrustAnchor());
        }
        catch (InvalidProtocolBufferException e) {
            throw new PaymentProtocolException.InvalidPkiData(e);
        }
        catch (InvalidKeyException | SignatureException | CertificateException e) {
            throw new PaymentProtocolException.PkiVerificationException(e);
        }
        catch (InvalidAlgorithmParameterException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (CertPathValidatorException e) {
            throw new PaymentProtocolException.PkiVerificationException(e, certs);
        }
    }

    public static Protos.Payment createPaymentMessage(List<Transaction> transactions, @Nullable Coin refundAmount, @Nullable Address refundAddress, @Nullable String memo, @Nullable byte[] merchantData) {
        if (refundAddress != null) {
            if (refundAmount == null) {
                throw new IllegalArgumentException("Specify refund amount if refund address is specified.");
            }
            return PaymentProtocol.createPaymentMessage(transactions, Collections.singletonList(PaymentProtocol.createPayToAddressOutput(refundAmount, refundAddress)), memo, merchantData);
        }
        return PaymentProtocol.createPaymentMessage(transactions, null, memo, merchantData);
    }

    public static Protos.Payment createPaymentMessage(List<Transaction> transactions, @Nullable List<Protos.Output> refundOutputs, @Nullable String memo, @Nullable byte[] merchantData) {
        Protos.Payment.Builder builder = Protos.Payment.newBuilder();
        for (Transaction transaction : transactions) {
            builder.addTransactions(ByteString.copyFrom(transaction.serialize()));
        }
        if (refundOutputs != null) {
            for (Protos.Output output : refundOutputs) {
                builder.addRefundTo(output);
            }
        }
        if (memo != null) {
            builder.setMemo(memo);
        }
        if (merchantData != null) {
            builder.setMerchantData(ByteString.copyFrom(merchantData));
        }
        return (Protos.Payment)builder.build();
    }

    public static List<Transaction> parseTransactionsFromPaymentMessage(NetworkParameters params, Protos.Payment paymentMessage) {
        ArrayList<Transaction> transactions = new ArrayList<Transaction>(paymentMessage.getTransactionsCount());
        for (ByteString transaction : paymentMessage.getTransactionsList()) {
            transactions.add(params.getDefaultSerializer().makeTransaction(ByteBuffer.wrap(transaction.toByteArray())));
        }
        return transactions;
    }

    public static Protos.PaymentACK createPaymentAck(Protos.Payment paymentMessage, @Nullable String memo) {
        Protos.PaymentACK.Builder builder = Protos.PaymentACK.newBuilder();
        builder.setPayment(paymentMessage);
        if (memo != null) {
            builder.setMemo(memo);
        }
        return (Protos.PaymentACK)builder.build();
    }

    public static Ack parsePaymentAck(Protos.PaymentACK paymentAck) {
        String memo = paymentAck.hasMemo() ? paymentAck.getMemo() : null;
        return new Ack(memo);
    }

    public static Protos.Output createPayToAddressOutput(@Nullable Coin amount, Address address) {
        Protos.Output.Builder output = Protos.Output.newBuilder();
        if (amount != null) {
            NetworkParameters params = NetworkParameters.of(address.network());
            if (params.network().exceedsMaxMoney(amount)) {
                throw new IllegalArgumentException("Amount too big: " + amount);
            }
            output.setAmount(amount.value);
        } else {
            output.setAmount(0L);
        }
        output.setScript(ByteString.copyFrom(ScriptBuilder.createOutputScript(address).program()));
        return (Protos.Output)output.build();
    }

    @Nullable
    public static BitcoinNetworkParams paramsFromPmtProtocolID(String pmtProtocolId) {
        if (pmtProtocolId.equals(PAYMENT_PROTOCOL_ID_MAINNET)) {
            return MainNetParams.get();
        }
        if (pmtProtocolId.equals(PAYMENT_PROTOCOL_ID_TESTNET)) {
            return TestNet3Params.get();
        }
        if (pmtProtocolId.equals(PAYMENT_PROTOCOL_ID_SIGNET)) {
            return SigNetParams.get();
        }
        if (pmtProtocolId.equals(PAYMENT_PROTOCOL_ID_REGTEST)) {
            return RegTestParams.get();
        }
        if (pmtProtocolId.equals(PAYMENT_PROTOCOL_ID_UNIT_TESTS)) {
            return UnitTestParams.get();
        }
        return null;
    }

    public static String protocolIdFromParams(NetworkParameters params) {
        if (params instanceof MainNetParams) {
            return PAYMENT_PROTOCOL_ID_MAINNET;
        }
        if (params instanceof TestNet3Params) {
            return PAYMENT_PROTOCOL_ID_TESTNET;
        }
        if (params instanceof SigNetParams) {
            return PAYMENT_PROTOCOL_ID_SIGNET;
        }
        if (params instanceof RegTestParams) {
            return PAYMENT_PROTOCOL_ID_REGTEST;
        }
        if (params instanceof UnitTestParams) {
            return PAYMENT_PROTOCOL_ID_UNIT_TESTS;
        }
        throw new IllegalArgumentException("Unknown network");
    }

    public static class PkiVerificationData {
        public final String displayName;
        public final PublicKey merchantSigningKey;
        public final TrustAnchor rootAuthority;
        public final String rootAuthorityName;

        private PkiVerificationData(@Nullable String displayName, PublicKey merchantSigningKey, TrustAnchor rootAuthority) throws PaymentProtocolException.PkiVerificationException {
            try {
                this.displayName = displayName;
                this.merchantSigningKey = merchantSigningKey;
                this.rootAuthority = rootAuthority;
                this.rootAuthorityName = X509Utils.getDisplayNameFromCertificate(rootAuthority.getTrustedCert(), true);
            }
            catch (CertificateParsingException x) {
                throw new PaymentProtocolException.PkiVerificationException(x);
            }
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("displayName", (Object)this.displayName).add("rootAuthorityName", (Object)this.rootAuthorityName).add("merchantSigningKey", (Object)this.merchantSigningKey).add("rootAuthority", (Object)this.rootAuthority).toString();
        }
    }

    public static class Ack {
        @Nullable
        private final String memo;

        Ack(@Nullable String memo) {
            this.memo = memo;
        }

        @Nullable
        public String getMemo() {
            return this.memo;
        }
    }

    public static class Output {
        @Nullable
        public final Coin amount;
        public final byte[] scriptData;

        public Output(@Nullable Coin amount, byte[] scriptData) {
            this.amount = amount;
            this.scriptData = scriptData;
        }
    }
}

