/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.protocols.payments;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyStoreException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import org.bitcoinj.base.Address;
import org.bitcoinj.base.Coin;
import org.bitcoinj.base.internal.TimeUtils;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.crypto.TrustStoreLoader;
import org.bitcoinj.params.MainNetParams;
import org.bitcoinj.protobuf.payments.Protos;
import org.bitcoinj.protocols.payments.PaymentProtocol;
import org.bitcoinj.protocols.payments.PaymentProtocolException;
import org.bitcoinj.uri.BitcoinURI;
import org.bitcoinj.utils.ListenableCompletableFuture;
import org.bitcoinj.utils.Threading;
import org.bitcoinj.wallet.SendRequest;

public class PaymentSession {
    private static final ExecutorService executor = Threading.THREAD_POOL;
    private NetworkParameters params;
    private Protos.PaymentRequest paymentRequest;
    private Protos.PaymentDetails paymentDetails;
    private Coin totalValue = Coin.ZERO;
    @Nullable
    public final PaymentProtocol.PkiVerificationData pkiVerificationData;

    public static ListenableCompletableFuture<PaymentSession> createFromBitcoinUri(BitcoinURI uri) throws PaymentProtocolException {
        return PaymentSession.createFromBitcoinUri(uri, true, null);
    }

    public static ListenableCompletableFuture<PaymentSession> createFromBitcoinUri(BitcoinURI uri, boolean verifyPki) throws PaymentProtocolException {
        return PaymentSession.createFromBitcoinUri(uri, verifyPki, null);
    }

    public static ListenableCompletableFuture<PaymentSession> createFromBitcoinUri(BitcoinURI uri, boolean verifyPki, @Nullable TrustStoreLoader trustStoreLoader) throws PaymentProtocolException {
        String url = uri.getPaymentRequestUrl();
        if (url == null) {
            throw new PaymentProtocolException.InvalidPaymentRequestURL("No payment request URL (r= parameter) in BitcoinURI " + uri);
        }
        try {
            return ListenableCompletableFuture.of(PaymentSession.fetchPaymentRequest(new URI(url), verifyPki, trustStoreLoader));
        }
        catch (URISyntaxException e) {
            throw new PaymentProtocolException.InvalidPaymentRequestURL(e);
        }
    }

    public static ListenableCompletableFuture<PaymentSession> createFromUrl(String url) throws PaymentProtocolException {
        return PaymentSession.createFromUrl(url, true, null);
    }

    public static ListenableCompletableFuture<PaymentSession> createFromUrl(String url, boolean verifyPki) throws PaymentProtocolException {
        return PaymentSession.createFromUrl(url, verifyPki, null);
    }

    public static ListenableCompletableFuture<PaymentSession> createFromUrl(String url, boolean verifyPki, @Nullable TrustStoreLoader trustStoreLoader) throws PaymentProtocolException {
        if (url == null) {
            throw new PaymentProtocolException.InvalidPaymentRequestURL("null paymentRequestUrl");
        }
        try {
            return ListenableCompletableFuture.of(PaymentSession.fetchPaymentRequest(new URI(url), verifyPki, trustStoreLoader));
        }
        catch (URISyntaxException e) {
            throw new PaymentProtocolException.InvalidPaymentRequestURL(e);
        }
    }

    private static CompletableFuture<PaymentSession> fetchPaymentRequest(URI uri, boolean verifyPki, @Nullable TrustStoreLoader trustStoreLoader) {
        return CompletableFuture.supplyAsync(() -> {
            HttpURLConnection connection = (HttpURLConnection)uri.toURL().openConnection();
            connection.setRequestProperty("Accept", "application/bitcoin-paymentrequest");
            connection.setUseCaches(false);
            Protos.PaymentRequest paymentRequest = Protos.PaymentRequest.parseFrom(connection.getInputStream());
            return new PaymentSession(paymentRequest, verifyPki, trustStoreLoader);
        }, executor);
    }

    public PaymentSession(Protos.PaymentRequest request) throws PaymentProtocolException {
        this(request, true, null);
    }

    public PaymentSession(Protos.PaymentRequest request, boolean verifyPki) throws PaymentProtocolException {
        this(request, verifyPki, null);
    }

    public PaymentSession(Protos.PaymentRequest request, boolean verifyPki, @Nullable TrustStoreLoader trustStoreLoader) throws PaymentProtocolException {
        TrustStoreLoader nonNullTrustStoreLoader = trustStoreLoader != null ? trustStoreLoader : new TrustStoreLoader.DefaultTrustStoreLoader();
        this.parsePaymentRequest(request);
        if (verifyPki) {
            try {
                this.pkiVerificationData = PaymentProtocol.verifyPaymentRequestPki(request, nonNullTrustStoreLoader.getKeyStore());
            }
            catch (IOException | KeyStoreException x) {
                throw new PaymentProtocolException(x);
            }
        } else {
            this.pkiVerificationData = null;
        }
    }

    public List<PaymentProtocol.Output> getOutputs() {
        ArrayList<PaymentProtocol.Output> outputs = new ArrayList<PaymentProtocol.Output>(this.paymentDetails.getOutputsCount());
        for (Protos.Output output : this.paymentDetails.getOutputsList()) {
            Coin amount = output.hasAmount() ? Coin.valueOf(output.getAmount()) : null;
            outputs.add(new PaymentProtocol.Output(amount, output.getScript().toByteArray()));
        }
        return outputs;
    }

    @Nullable
    public String getMemo() {
        if (this.paymentDetails.hasMemo()) {
            return this.paymentDetails.getMemo();
        }
        return null;
    }

    public Coin getValue() {
        return this.totalValue;
    }

    public Instant time() {
        return Instant.ofEpochSecond(this.paymentDetails.getTime());
    }

    @Deprecated
    public Date getDate() {
        return Date.from(this.time());
    }

    public Optional<Instant> expires() {
        if (this.paymentDetails.hasExpires()) {
            return Optional.of(Instant.ofEpochSecond(this.paymentDetails.getExpires()));
        }
        return Optional.empty();
    }

    @Nullable
    @Deprecated
    public Date getExpires() {
        return this.expires().map(Date::from).orElse(null);
    }

    public boolean isExpired() {
        return this.expires().map(time -> TimeUtils.currentTime().isAfter((Instant)time)).orElse(false);
    }

    @Nullable
    public String getPaymentUrl() {
        if (this.paymentDetails.hasPaymentUrl()) {
            return this.paymentDetails.getPaymentUrl();
        }
        return null;
    }

    @Nullable
    public byte[] getMerchantData() {
        if (this.paymentDetails.hasMerchantData()) {
            return this.paymentDetails.getMerchantData().toByteArray();
        }
        return null;
    }

    public SendRequest getSendRequest() {
        Transaction tx = new Transaction();
        for (Protos.Output output : this.paymentDetails.getOutputsList()) {
            tx.addOutput(new TransactionOutput(tx, Coin.valueOf(output.getAmount()), output.getScript().toByteArray()));
        }
        return SendRequest.forTx(tx).fromPaymentDetails(this.paymentDetails);
    }

    public ListenableCompletableFuture<PaymentProtocol.Ack> sendPayment(List<Transaction> txns, @Nullable Address refundAddr, @Nullable String memo) {
        URL url;
        Protos.Payment payment = null;
        try {
            payment = this.getPayment(txns, refundAddr, memo);
        }
        catch (IOException e) {
            return ListenableCompletableFuture.failedFuture(e);
        }
        if (payment == null) {
            return ListenableCompletableFuture.failedFuture(new PaymentProtocolException.InvalidPaymentRequestURL("Missing Payment URL"));
        }
        if (this.isExpired()) {
            return ListenableCompletableFuture.failedFuture(new PaymentProtocolException.Expired("PaymentRequest is expired"));
        }
        try {
            url = new URL(this.paymentDetails.getPaymentUrl());
        }
        catch (MalformedURLException e) {
            return ListenableCompletableFuture.failedFuture(new PaymentProtocolException.InvalidPaymentURL(e));
        }
        return ListenableCompletableFuture.of(this.sendPayment(url, payment));
    }

    @Nullable
    public Protos.Payment getPayment(List<Transaction> txns, @Nullable Address refundAddr, @Nullable String memo) throws IOException {
        if (this.paymentDetails.hasPaymentUrl()) {
            return PaymentProtocol.createPaymentMessage(txns, this.totalValue, refundAddr, memo, this.getMerchantData());
        }
        return null;
    }

    @VisibleForTesting
    protected CompletableFuture<PaymentProtocol.Ack> sendPayment(URL url, Protos.Payment payment) {
        return CompletableFuture.supplyAsync(() -> {
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/bitcoin-payment");
            connection.setRequestProperty("Accept", "application/bitcoin-paymentack");
            connection.setRequestProperty("Content-Length", Integer.toString(payment.getSerializedSize()));
            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            DataOutputStream outStream = new DataOutputStream(connection.getOutputStream());
            payment.writeTo(outStream);
            outStream.flush();
            outStream.close();
            Protos.PaymentACK paymentAck = Protos.PaymentACK.parseFrom(connection.getInputStream());
            return PaymentProtocol.parsePaymentAck(paymentAck);
        }, executor);
    }

    private void parsePaymentRequest(Protos.PaymentRequest request) throws PaymentProtocolException {
        try {
            if (request == null) {
                throw new PaymentProtocolException("request cannot be null");
            }
            if (request.getPaymentDetailsVersion() != 1) {
                throw new PaymentProtocolException.InvalidVersion("Version 1 required. Received version " + request.getPaymentDetailsVersion());
            }
            this.paymentRequest = request;
            if (!request.hasSerializedPaymentDetails()) {
                throw new PaymentProtocolException("No PaymentDetails");
            }
            this.paymentDetails = (Protos.PaymentDetails)((Protos.PaymentDetails.Builder)Protos.PaymentDetails.newBuilder().mergeFrom(request.getSerializedPaymentDetails())).build();
            if (this.paymentDetails == null) {
                throw new PaymentProtocolException("Invalid PaymentDetails");
            }
            this.params = !this.paymentDetails.hasNetwork() ? MainNetParams.get() : PaymentProtocol.paramsFromPmtProtocolID(this.paymentDetails.getNetwork());
            if (this.params == null) {
                throw new PaymentProtocolException.InvalidNetwork("Invalid network " + this.paymentDetails.getNetwork());
            }
            if (this.paymentDetails.getOutputsCount() < 1) {
                throw new PaymentProtocolException.InvalidOutputs("No outputs");
            }
            for (Protos.Output output : this.paymentDetails.getOutputsList()) {
                if (!output.hasAmount()) continue;
                this.totalValue = this.totalValue.add(Coin.valueOf(output.getAmount()));
            }
            if (this.params.network().exceedsMaxMoney(this.totalValue)) {
                throw new PaymentProtocolException.InvalidOutputs("The outputs are way too big.");
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new PaymentProtocolException(e);
        }
    }

    @Nullable
    public PaymentProtocol.PkiVerificationData verifyPki() {
        return this.pkiVerificationData;
    }

    public NetworkParameters getNetworkParameters() {
        return this.params;
    }

    public Protos.PaymentRequest getPaymentRequest() {
        return this.paymentRequest;
    }

    public Protos.PaymentDetails getPaymentDetails() {
        return this.paymentDetails;
    }
}

